/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.poifs.property;

import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.common.POIFSBigBlockSize;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.property.Property;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.property.PropertyFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.property.PropertyTableBase;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.BlockWritable;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.HeaderBlock;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.PropertyBlock;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.RawDataBlockList;
import java.io.IOException;
import java.io.OutputStream;

public final class PropertyTable
extends PropertyTableBase
implements BlockWritable {
    private POIFSBigBlockSize _bigBigBlockSize;
    private BlockWritable[] _blocks;

    public PropertyTable(HeaderBlock headerBlock) {
        super(headerBlock);
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
        this._blocks = null;
    }

    public PropertyTable(HeaderBlock headerBlock, RawDataBlockList blockList) throws IOException {
        super(headerBlock, PropertyFactory.convertToProperties(blockList.fetchBlocks(headerBlock.getPropertyStart(), -1)));
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
        this._blocks = null;
    }

    public void preWrite() {
        int k;
        Property[] properties = this._properties.toArray(new Property[this._properties.size()]);
        for (k = 0; k < properties.length; ++k) {
            properties[k].setIndex(k);
        }
        this._blocks = PropertyBlock.createPropertyBlockArray(this._bigBigBlockSize, this._properties);
        for (k = 0; k < properties.length; ++k) {
            properties[k].preWrite();
        }
    }

    @Override
    public int countBlocks() {
        return this._blocks == null ? 0 : this._blocks.length;
    }

    @Override
    public void writeBlocks(OutputStream stream) throws IOException {
        if (this._blocks != null) {
            for (int j = 0; j < this._blocks.length; ++j) {
                this._blocks[j].writeBlocks(stream);
            }
        }
    }
}

