/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PropertyModifier;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;

@Internal
public final class PieceDescriptor {
    short descriptor;
    int fc;
    PropertyModifier prm;
    boolean unicode;

    public PieceDescriptor(byte[] buf, int offset) {
        this.descriptor = LittleEndian.getShort(buf, offset);
        this.fc = LittleEndian.getInt(buf, offset += 2);
        this.prm = new PropertyModifier(LittleEndian.getShort(buf, offset += 4));
        if ((this.fc & 0x40000000) == 0) {
            this.unicode = true;
        } else {
            this.unicode = false;
            this.fc &= 0xBFFFFFFF;
            this.fc /= 2;
        }
    }

    public int getFilePosition() {
        return this.fc;
    }

    public void setFilePosition(int pos) {
        this.fc = pos;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public PropertyModifier getPrm() {
        return this.prm;
    }

    protected byte[] toByteArray() {
        int tempFc = this.fc;
        if (!this.unicode) {
            tempFc *= 2;
            tempFc |= 0x40000000;
        }
        int offset = 0;
        byte[] buf = new byte[8];
        LittleEndian.putShort(buf, offset, this.descriptor);
        LittleEndian.putInt(buf, offset += 2, tempFc);
        LittleEndian.putShort(buf, offset += 4, this.prm.getValue());
        return buf;
    }

    public static int getSizeInBytes() {
        return 8;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.descriptor;
        result = 31 * result + (this.prm == null ? 0 : this.prm.hashCode());
        result = 31 * result + (this.unicode ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PieceDescriptor other = (PieceDescriptor)obj;
        if (this.descriptor != other.descriptor) {
            return false;
        }
        if (this.prm == null ? other.prm != null : !this.prm.equals(other.prm)) {
            return false;
        }
        return this.unicode == other.unicode;
    }

    public String toString() {
        return "PieceDescriptor (pos: " + this.getFilePosition() + "; " + (this.isUnicode() ? "unicode" : "non-unicode") + "; prm: " + this.getPrm() + ")";
    }
}

