/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.util.BitField;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.Arrays;

@Internal
public class PictureDescriptor {
    private static final int LCB_OFFSET = 0;
    private static final int CBHEADER_OFFSET = 4;
    private static final int MFP_MM_OFFSET = 6;
    private static final int MFP_XEXT_OFFSET = 8;
    private static final int MFP_YEXT_OFFSET = 10;
    private static final int MFP_HMF_OFFSET = 12;
    private static final int DXAGOAL_OFFSET = 28;
    private static final int DYAGOAL_OFFSET = 30;
    private static final int MX_OFFSET = 32;
    private static final int MY_OFFSET = 34;
    private static final int DXACROPLEFT_OFFSET = 36;
    private static final int DYACROPTOP_OFFSET = 38;
    private static final int DXACROPRIGHT_OFFSET = 40;
    private static final int DYACROPBOTTOM_OFFSET = 42;
    protected int lcb;
    protected int cbHeader;
    protected int mfp_mm;
    protected int mfp_xExt;
    protected int mfp_yExt;
    protected int mfp_hMF;
    protected byte[] offset14 = new byte[14];
    protected short dxaGoal = 0;
    protected short dyaGoal = 0;
    protected short mx;
    protected short my;
    protected float dxaCropLeft = 0.0f;
    protected float dyaCropTop = 0.0f;
    protected float dxaCropRight = 0.0f;
    protected float dyaCropBottom = 0.0f;
    protected float fBright;
    protected float fContrast;
    protected boolean bGrayScl;
    protected float fThreshold;
    protected boolean bSetBright;
    protected boolean bSetContrast;
    protected boolean bSetGrayScl;
    protected boolean bSetThreshold;

    public float getBright() {
        return this.fBright;
    }

    public float getContrast() {
        return this.fContrast;
    }

    public boolean isGrayScl() {
        return this.bGrayScl;
    }

    public float getThreshold() {
        return this.fThreshold;
    }

    public boolean isSetBright() {
        return this.bSetBright;
    }

    public boolean isSetContrast() {
        return this.bSetContrast;
    }

    public boolean isSetGrayScl() {
        return this.bSetGrayScl;
    }

    public boolean isSetThreshold() {
        return this.bSetThreshold;
    }

    public PictureDescriptor() {
    }

    public PictureDescriptor(byte[] _dataStream, int startOffset) {
        this.lcb = LittleEndian.getInt(_dataStream, startOffset + 0);
        this.cbHeader = LittleEndian.getUShort(_dataStream, startOffset + 4);
        this.mfp_mm = LittleEndian.getUShort(_dataStream, startOffset + 6);
        this.mfp_xExt = LittleEndian.getUShort(_dataStream, startOffset + 8);
        this.mfp_yExt = LittleEndian.getUShort(_dataStream, startOffset + 10);
        this.mfp_hMF = LittleEndian.getUShort(_dataStream, startOffset + 12);
        this.offset14 = LittleEndian.getByteArray(_dataStream, startOffset + 14, 14);
        this.dxaGoal = LittleEndian.getShort(_dataStream, startOffset + 28);
        this.dyaGoal = LittleEndian.getShort(_dataStream, startOffset + 30);
        this.mx = LittleEndian.getShort(_dataStream, startOffset + 32);
        this.my = LittleEndian.getShort(_dataStream, startOffset + 34);
        int pictureOffset = startOffset + 68;
        if (this.mfp_mm == 102) {
            int cchPicName = _dataStream[pictureOffset] & 0xFFFF;
            pictureOffset += 1 + cchPicName;
        }
        OfficeArtRecordHeader officeArtRecHeader = this.readHeader(_dataStream, pictureOffset);
        short recVer = this.getRecVer(officeArtRecHeader);
        short recInstance = this.getRecInstance(officeArtRecHeader);
        if (recVer == 15 && recInstance == 0 && officeArtRecHeader.recType == 61444) {
            long len = officeArtRecHeader.recLength;
            pictureOffset += 8;
            officeArtRecHeader = null;
            while (len > 0L && pictureOffset < _dataStream.length) {
                officeArtRecHeader = this.readHeader(_dataStream, pictureOffset);
                len -= officeArtRecHeader.recLength;
                pictureOffset += 8;
                recVer = this.getRecVer(officeArtRecHeader);
                recInstance = this.getRecInstance(officeArtRecHeader);
                if (recVer == 3 && officeArtRecHeader.recType == 61451) {
                    int nPropertyNum = this.getRecInstance(officeArtRecHeader);
                    int nIndex = 0;
                    for (nIndex = 0; nIndex < nPropertyNum; ++nIndex) {
                        int propValue;
                        OfficeArtOpid officeArtOpid = this.readOfficeArtOpid(_dataStream, pictureOffset);
                        short opid = this.getOpid(officeArtOpid);
                        boolean bBid = this.isfBid(officeArtOpid);
                        boolean bComplex = this.isfComplex(officeArtOpid);
                        byte[] fixedPoint = null;
                        if (opid == 256 && !bBid && !bComplex) {
                            fixedPoint = LittleEndian.getByteArray(_dataStream, pictureOffset + 2, 4);
                            this.dyaCropTop = this.getRealNumFromFixedPoint(fixedPoint);
                        }
                        if (opid == 257 && !bBid && !bComplex) {
                            fixedPoint = LittleEndian.getByteArray(_dataStream, pictureOffset + 2, 4);
                            this.dyaCropBottom = this.getRealNumFromFixedPoint(fixedPoint);
                        }
                        if (opid == 258 && !bBid && !bComplex) {
                            fixedPoint = LittleEndian.getByteArray(_dataStream, pictureOffset + 2, 4);
                            this.dxaCropLeft = this.getRealNumFromFixedPoint(fixedPoint);
                        }
                        if (opid == 259 && !bBid && !bComplex) {
                            fixedPoint = LittleEndian.getByteArray(_dataStream, pictureOffset + 2, 4);
                            this.dxaCropRight = this.getRealNumFromFixedPoint(fixedPoint);
                        }
                        if (opid == 265 && !bBid && !bComplex) {
                            propValue = LittleEndian.getInt(_dataStream, pictureOffset + 2);
                            this.bSetBright = true;
                            this.fBright = (float)propValue / 32768.0f * 255.0f;
                        }
                        if (opid == 264 && !bBid && !bComplex) {
                            propValue = LittleEndian.getInt(_dataStream, pictureOffset + 2);
                            this.bSetContrast = true;
                            this.fContrast = Math.min((float)propValue / 65536.0f, 10.0f);
                        }
                        if (opid == 319 && !bBid && !bComplex) {
                            BlipBooleanProperties blipProperties = this.readBlipBooleanProperties(_dataStream, pictureOffset + 2);
                            if (this.isfUsefPictureBiLevel(blipProperties)) {
                                if (this.isfPictureBiLevel(blipProperties)) {
                                    this.bSetThreshold = true;
                                    this.fThreshold = 128.0f;
                                }
                            } else if (this.isfUsefPictureGray(blipProperties) && this.isfPictureGray(blipProperties)) {
                                this.bSetGrayScl = true;
                                this.bGrayScl = true;
                            }
                        }
                        pictureOffset += 6;
                    }
                    break;
                }
                pictureOffset = (int)((long)pictureOffset + officeArtRecHeader.recLength);
            }
        }
    }

    private short getRecVer(OfficeArtRecordHeader officeArtRecHeader) {
        return (short)officeArtRecHeader.recVer.getValue(officeArtRecHeader.recFlag);
    }

    private short getRecInstance(OfficeArtRecordHeader officeArtRecHeader) {
        return (short)officeArtRecHeader.recInstance.getValue(officeArtRecHeader.recFlag);
    }

    private OfficeArtRecordHeader readHeader(byte[] _dataStream, int startoffset) {
        OfficeArtRecordHeader officeArt = new OfficeArtRecordHeader();
        officeArt.recVer = new BitField(15);
        officeArt.recInstance = new BitField(65520);
        if (startoffset + 4 < _dataStream.length) {
            officeArt.recFlag = LittleEndian.getShort(_dataStream, startoffset);
            officeArt.recType = LittleEndian.getUShort(_dataStream, startoffset + 2);
            officeArt.recLength = LittleEndian.getUInt(_dataStream, startoffset + 4);
        }
        return officeArt;
    }

    private OfficeArtOpid readOfficeArtOpid(byte[] _dataStream, int startoffset) {
        OfficeArtOpid officeArtOpid = new OfficeArtOpid();
        officeArtOpid.opid = new BitField(16383);
        officeArtOpid.fBid = new BitField(16384);
        officeArtOpid.fComplex = new BitField(32768);
        officeArtOpid.flag = LittleEndian.getShort(_dataStream, startoffset);
        return officeArtOpid;
    }

    private short getOpid(OfficeArtOpid officeArtOpid) {
        return officeArtOpid.opid.getShortValue(officeArtOpid.flag);
    }

    private boolean isfBid(OfficeArtOpid officeArtOpid) {
        return officeArtOpid.fBid.getShortValue(officeArtOpid.flag) == 1;
    }

    private boolean isfComplex(OfficeArtOpid officeArtOpid) {
        return officeArtOpid.fComplex.getShortValue(officeArtOpid.flag) == 1;
    }

    private float getRealNumFromFixedPoint(byte[] data) {
        short integral = LittleEndian.getShort(data, 2);
        int fractional = LittleEndian.getUShort(data, 0);
        return (float)integral + (float)fractional / 65536.0f;
    }

    private BlipBooleanProperties readBlipBooleanProperties(byte[] _dataStream, int startoffset) {
        BlipBooleanProperties properties = new BlipBooleanProperties();
        properties.propValue = LittleEndian.getInt(_dataStream, startoffset);
        properties.fPictureBiLevel = new BitField(131072);
        properties.fUsefPictureBiLevel = new BitField(2);
        properties.fPictureGray = new BitField(262144);
        properties.fUsefPictureGray = new BitField(4);
        return properties;
    }

    private boolean isfUsefPictureBiLevel(BlipBooleanProperties properties) {
        return properties.fUsefPictureBiLevel.getValue(properties.propValue) == 1;
    }

    private boolean isfPictureBiLevel(BlipBooleanProperties properties) {
        return properties.fPictureBiLevel.getValue(properties.propValue) == 1;
    }

    private boolean isfUsefPictureGray(BlipBooleanProperties properties) {
        return properties.fUsefPictureBiLevel.getValue(properties.propValue) == 1;
    }

    private boolean isfPictureGray(BlipBooleanProperties properties) {
        return properties.fPictureBiLevel.getValue(properties.propValue) == 1;
    }

    public short getZoomX() {
        return this.mx;
    }

    public short getZoomY() {
        return this.my;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[PICF]\n");
        stringBuilder.append("        lcb           = ").append(this.lcb).append('\n');
        stringBuilder.append("        cbHeader      = ").append(this.cbHeader).append('\n');
        stringBuilder.append("        mfp.mm        = ").append(this.mfp_mm).append('\n');
        stringBuilder.append("        mfp.xExt      = ").append(this.mfp_xExt).append('\n');
        stringBuilder.append("        mfp.yExt      = ").append(this.mfp_yExt).append('\n');
        stringBuilder.append("        mfp.hMF       = ").append(this.mfp_hMF).append('\n');
        stringBuilder.append("        offset14      = ").append(Arrays.toString(this.offset14)).append('\n');
        stringBuilder.append("        dxaGoal       = ").append(this.dxaGoal).append('\n');
        stringBuilder.append("        dyaGoal       = ").append(this.dyaGoal).append('\n');
        stringBuilder.append("        dxaCropLeft   = ").append(this.dxaCropLeft).append('\n');
        stringBuilder.append("        dyaCropTop    = ").append(this.dyaCropTop).append('\n');
        stringBuilder.append("        dxaCropRight  = ").append(this.dxaCropRight).append('\n');
        stringBuilder.append("        dyaCropBottom = ").append(this.dyaCropBottom).append('\n');
        stringBuilder.append("[/PICF]");
        return stringBuilder.toString();
    }

    public class OfficeArtRecordHeader {
        public BitField recVer;
        public BitField recInstance;
        public short recFlag;
        public int recType;
        public long recLength;
    }

    public class OfficeArtOpid {
        public BitField opid;
        public BitField fBid;
        public BitField fComplex;
        public short flag;
    }

    public class BlipBooleanProperties {
        public BitField fPictureBiLevel;
        public BitField fPictureGray;
        public BitField fUsefPictureBiLevel;
        public BitField fUsefPictureGray;
        int propValue;
    }
}

