/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.CharIndexTranslator;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.ComplexFileTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.GenericPropertyNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PAPFormattedDiskPage;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PAPX;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PlexOfCps;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PropertyModifier;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PropertyNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.TextPiece;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.TextPieceTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.io.HWPFFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.io.HWPFOutputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm.SprmBuffer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm.SprmIterator;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm.SprmOperation;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedList;

@Internal
public class PAPBinTable {
    protected ArrayList<PAPX> _paragraphs = new ArrayList();

    public PAPBinTable() {
    }

    public PAPBinTable(byte[] documentStream, byte[] tableStream, byte[] dataStream, int offset, int size, int fcMin, TextPieceTable tpt) {
        this(documentStream, tableStream, dataStream, offset, size, tpt);
    }

    public PAPBinTable(byte[] documentStream, byte[] tableStream, byte[] dataStream, int offset, int size, CharIndexTranslator charIndexTranslator) {
        long start = System.currentTimeMillis();
        PlexOfCps binTable = new PlexOfCps(tableStream, offset, size, 4);
        int length = binTable.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = binTable.getProperty(x);
            int pageNum = LittleEndian.getInt(node.getBytes());
            int pageOffset = 512 * pageNum;
            PAPFormattedDiskPage pfkp = new PAPFormattedDiskPage(documentStream, dataStream, pageOffset, charIndexTranslator);
            int fkpSize = pfkp.size();
            for (int y = 0; y < fkpSize; ++y) {
                PAPX papx = pfkp.getPAPX(y);
                if (papx == null) continue;
                this._paragraphs.add(papx);
            }
        }
    }

    public void rebuild(StringBuilder docText, ComplexFileTable complexFileTable) {
        long start = System.currentTimeMillis();
        if (complexFileTable != null) {
            SprmBuffer[] sprmBuffers = complexFileTable.getGrpprls();
            for (TextPiece textPiece : complexFileTable.getTextPieceTable().getTextPieces()) {
                short igrpprl;
                PropertyModifier prm = textPiece.getPieceDescriptor().getPrm();
                if (!prm.isComplex() || (igrpprl = prm.getIgrpprl()) < 0 || igrpprl >= sprmBuffers.length) continue;
                boolean hasPap = false;
                SprmBuffer sprmBuffer = sprmBuffers[igrpprl];
                SprmIterator iterator = sprmBuffer.iterator();
                while (iterator.hasNext()) {
                    SprmOperation sprmOperation = iterator.next();
                    if (sprmOperation.getType() != 1) continue;
                    hasPap = true;
                    break;
                }
                if (!hasPap) continue;
                SprmBuffer newSprmBuffer = new SprmBuffer(2);
                newSprmBuffer.append(sprmBuffer.toByteArray());
                PAPX papx = new PAPX(textPiece.getStart(), textPiece.getEnd(), newSprmBuffer);
                this._paragraphs.add(papx);
            }
        }
        ArrayList<PAPX> oldPapxSortedByEndPos = new ArrayList<PAPX>(this._paragraphs);
        Collections.sort(oldPapxSortedByEndPos, PropertyNode.EndComparator.instance);
        start = System.currentTimeMillis();
        final IdentityHashMap<PAPX, Integer> papxToFileOrder = new IdentityHashMap<PAPX, Integer>();
        int counter = 0;
        for (PAPX papx : this._paragraphs) {
            papxToFileOrder.put(papx, counter++);
        }
        Comparator<PAPX> papxFileOrderComparator = new Comparator<PAPX>(){

            @Override
            public int compare(PAPX o1, PAPX o2) {
                Integer i1 = (Integer)papxToFileOrder.get(o1);
                Integer i2 = (Integer)papxToFileOrder.get(o2);
                return i1.compareTo(i2);
            }
        };
        start = System.currentTimeMillis();
        LinkedList<PAPX> newPapxs = new LinkedList<PAPX>();
        int lastParStart = 0;
        int lastPapxIndex = 0;
        for (int charIndex = 0; charIndex < docText.length(); ++charIndex) {
            PAPX existing;
            char c = docText.charAt(charIndex);
            if (c != '\r' && c != '\u0007' && c != '\f') continue;
            int startInclusive = lastParStart;
            int endExclusive = charIndex + 1;
            boolean broken = false;
            LinkedList<PAPX> papxs = new LinkedList<PAPX>();
            for (int papxIndex = lastPapxIndex; papxIndex < oldPapxSortedByEndPos.size(); ++papxIndex) {
                broken = false;
                PAPX papx = (PAPX)oldPapxSortedByEndPos.get(papxIndex);
                assert (startInclusive == 0 || papxIndex + 1 == oldPapxSortedByEndPos.size() || papx.getEnd() > startInclusive);
                if (papx.getEnd() - 1 > charIndex) {
                    lastPapxIndex = papxIndex;
                    broken = true;
                    break;
                }
                papxs.add(papx);
            }
            if (!broken) {
                lastPapxIndex = oldPapxSortedByEndPos.size() - 1;
            }
            if (papxs.size() == 0) {
                PAPX papx = new PAPX(startInclusive, endExclusive, new SprmBuffer(2));
                newPapxs.add(papx);
                lastParStart = endExclusive;
                continue;
            }
            if (papxs.size() == 1 && (existing = (PAPX)papxs.get(0)).getStart() == startInclusive && existing.getEnd() == endExclusive) {
                newPapxs.add(existing);
                lastParStart = endExclusive;
                continue;
            }
            Collections.sort(papxs, papxFileOrderComparator);
            SprmBuffer sprmBuffer = null;
            for (PAPX papx : papxs) {
                if (sprmBuffer == null) {
                    try {
                        sprmBuffer = (SprmBuffer)papx.getSprmBuf().clone();
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        throw new Error(e);
                    }
                }
                sprmBuffer.append(papx.getGrpprl(), 2);
            }
            PAPX newPapx = new PAPX(startInclusive, endExclusive, sprmBuffer);
            newPapxs.add(newPapx);
            lastParStart = endExclusive;
        }
        this._paragraphs = new ArrayList(newPapxs);
        start = System.currentTimeMillis();
    }

    public void insert(int listIndex, int cpStart, SprmBuffer buf) {
        PAPX forInsert = new PAPX(0, 0, buf);
        forInsert.setStart(cpStart);
        forInsert.setEnd(cpStart);
        if (listIndex == this._paragraphs.size()) {
            this._paragraphs.add(forInsert);
        } else {
            PAPX currentPap = this._paragraphs.get(listIndex);
            if (currentPap != null && currentPap.getStart() < cpStart) {
                SprmBuffer clonedBuf = null;
                try {
                    clonedBuf = (SprmBuffer)currentPap.getSprmBuf().clone();
                }
                catch (CloneNotSupportedException exc) {
                    exc.printStackTrace();
                }
                PAPX clone = new PAPX(0, 0, clonedBuf);
                clone.setStart(cpStart);
                clone.setEnd(currentPap.getEnd());
                currentPap.setEnd(cpStart);
                this._paragraphs.add(listIndex + 1, forInsert);
                this._paragraphs.add(listIndex + 2, clone);
            } else {
                this._paragraphs.add(listIndex, forInsert);
            }
        }
    }

    public void adjustForDelete(int listIndex, int offset, int length) {
        int x;
        int size = this._paragraphs.size();
        int endMark = offset + length;
        int endIndex = listIndex;
        PAPX papx = this._paragraphs.get(endIndex);
        while (papx.getEnd() < endMark) {
            papx = this._paragraphs.get(++endIndex);
        }
        if (listIndex == endIndex) {
            papx = this._paragraphs.get(endIndex);
            papx.setEnd(papx.getEnd() - endMark + offset);
        } else {
            papx = this._paragraphs.get(listIndex);
            papx.setEnd(offset);
            for (x = listIndex + 1; x < endIndex; ++x) {
                papx = this._paragraphs.get(x);
                papx.setStart(offset);
                papx.setEnd(offset);
            }
            papx = this._paragraphs.get(endIndex);
            papx.setEnd(papx.getEnd() - endMark + offset);
        }
        for (x = endIndex + 1; x < size; ++x) {
            papx = this._paragraphs.get(x);
            papx.setStart(papx.getStart() - length);
            papx.setEnd(papx.getEnd() - length);
        }
    }

    public void adjustForInsert(int listIndex, int length) {
        int size = this._paragraphs.size();
        PAPX papx = this._paragraphs.get(listIndex);
        papx.setEnd(papx.getEnd() + length);
        for (int x = listIndex + 1; x < size; ++x) {
            papx = this._paragraphs.get(x);
            papx.setStart(papx.getStart() + length);
            papx.setEnd(papx.getEnd() + length);
        }
    }

    public ArrayList<PAPX> getParagraphs() {
        return this._paragraphs;
    }

    @Deprecated
    public void writeTo(HWPFFileSystem sys, CharIndexTranslator translator) throws IOException {
        HWPFOutputStream wordDocumentStream = sys.getStream("WordDocument");
        HWPFOutputStream tableStream = sys.getStream("1Table");
        this.writeTo(wordDocumentStream, tableStream, translator);
    }

    public void writeTo(HWPFOutputStream wordDocumentStream, HWPFOutputStream tableStream, CharIndexTranslator translator) throws IOException {
        PlexOfCps binTable = new PlexOfCps(4);
        int docOffset = wordDocumentStream.getOffset();
        int mod = docOffset % 512;
        if (mod != 0) {
            byte[] padding = new byte[512 - mod];
            wordDocumentStream.write(padding);
        }
        docOffset = wordDocumentStream.getOffset();
        int pageNum = docOffset / 512;
        int endingFc = translator.getByteIndex(this._paragraphs.get(this._paragraphs.size() - 1).getEnd());
        ArrayList<PAPX> overflow = this._paragraphs;
        do {
            PAPX startingProp = overflow.get(0);
            int start = translator.getByteIndex(startingProp.getStart());
            PAPFormattedDiskPage pfkp = new PAPFormattedDiskPage();
            pfkp.fill(overflow);
            byte[] bufFkp = pfkp.toByteArray(tableStream, translator);
            wordDocumentStream.write(bufFkp);
            overflow = pfkp.getOverflow();
            int end = endingFc;
            if (overflow != null) {
                end = translator.getByteIndex(overflow.get(0).getStart());
            }
            byte[] intHolder = new byte[4];
            LittleEndian.putInt(intHolder, pageNum++);
            binTable.addProperty(new GenericPropertyNode(start, end, intHolder));
        } while (overflow != null);
        tableStream.write(binTable.toByteArray());
    }
}

