/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.DefaultEscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import java.util.ArrayList;
import java.util.List;

@Internal
public final class EscherRecordHolder {
    private final ArrayList<EscherRecord> escherRecords = new ArrayList();

    public EscherRecordHolder() {
    }

    public EscherRecordHolder(byte[] data, int offset, int size) {
        this();
        this.fillEscherRecords(data, offset, size);
    }

    private void fillEscherRecords(byte[] data, int offset, int size) {
        int bytesRead;
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
        for (int pos = offset; pos < offset + size; pos += bytesRead + 1) {
            EscherRecord r = recordFactory.createRecord(data, pos);
            this.escherRecords.add(r);
            bytesRead = r.fillFields(data, pos, recordFactory);
        }
    }

    public List<EscherRecord> getEscherRecords() {
        return this.escherRecords;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.escherRecords.size() == 0) {
            buffer.append("No Escher Records Decoded").append("\n");
        }
        for (EscherRecord r : this.escherRecords) {
            buffer.append(r.toString());
        }
        return buffer.toString();
    }

    public EscherContainerRecord getEscherContainer() {
        for (EscherRecord er : this.escherRecords) {
            if (!(er instanceof EscherContainerRecord)) continue;
            return (EscherContainerRecord)er;
        }
        return null;
    }

    public EscherRecord findFirstWithId(short id2) {
        return EscherRecordHolder.findFirstWithId(id2, this.getEscherRecords());
    }

    private static EscherRecord findFirstWithId(short id2, List<EscherRecord> records) {
        for (EscherRecord r : records) {
            if (r.getRecordId() != id2) continue;
            return r;
        }
        for (EscherRecord r : records) {
            EscherRecord found;
            if (!r.isContainerRecord() || (found = EscherRecordHolder.findFirstWithId(id2, r.getChildRecords())) == null) continue;
            return found;
        }
        return null;
    }

    public List<? extends EscherContainerRecord> getDgContainers() {
        ArrayList<EscherContainerRecord> dgContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            if (escherRecord.getRecordId() != -4094) continue;
            dgContainers.add((EscherContainerRecord)escherRecord);
        }
        return dgContainers;
    }

    public List<? extends EscherContainerRecord> getDggContainers() {
        ArrayList<EscherContainerRecord> dggContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            if (escherRecord.getRecordId() != -4096) continue;
            dggContainers.add((EscherContainerRecord)escherRecord);
        }
        return dggContainers;
    }

    public List<? extends EscherContainerRecord> getBStoreContainers() {
        ArrayList<EscherContainerRecord> bStoreContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherContainerRecord escherContainerRecord : this.getDggContainers()) {
            for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                if (escherRecord.getRecordId() != -4095) continue;
                bStoreContainers.add((EscherContainerRecord)escherRecord);
            }
        }
        return bStoreContainers;
    }

    public List<? extends EscherContainerRecord> getSpgrContainers() {
        ArrayList<EscherContainerRecord> spgrContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherContainerRecord escherContainerRecord : this.getDgContainers()) {
            for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                if (escherRecord.getRecordId() != -4093) continue;
                spgrContainers.add((EscherContainerRecord)escherRecord);
            }
        }
        return spgrContainers;
    }

    public List<? extends EscherContainerRecord> getSpContainers() {
        ArrayList<EscherContainerRecord> spContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherContainerRecord escherContainerRecord : this.getSpgrContainers()) {
            for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                spContainers.add((EscherContainerRecord)escherRecord);
            }
        }
        return spContainers;
    }
}

