/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf;

import com.ahmadullahpk.alldocumentreader.xs.fc.EncryptedDocumentException;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.CFBFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.CHPBinTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FileInformationBlock;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FontTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.ListTables;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PAPBinTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.SectionTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.StyleSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.TextPieceTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.ObjectPoolImpl;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.ObjectsPool;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Range;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public abstract class HWPFDocumentCore {
    protected static final String STREAM_OBJECT_POOL = "ObjectPool";
    protected static final String STREAM_WORD_DOCUMENT = "WordDocument";
    protected ObjectPoolImpl _objectPool;
    protected FileInformationBlock _fib;
    protected StyleSheet _ss;
    protected CHPBinTable _cbt;
    protected PAPBinTable _pbt;
    protected SectionTable _st;
    protected FontTable _ft;
    protected ListTables _lt;
    protected byte[] _mainStream;
    protected CFBFileSystem cfbFS;

    public static CFBFileSystem verifyAndBuildPOIFS(InputStream istream) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(istream, 6);
        byte[] first6 = new byte[6];
        pis.read(first6);
        if (first6[0] == 123 && first6[1] == 92 && first6[2] == 114 && first6[3] == 116 && first6[4] == 102) {
            throw new IllegalArgumentException("The document is really a RTF file");
        }
        pis.unread(first6);
        return new CFBFileSystem(pis);
    }

    public HWPFDocumentCore(InputStream istream) throws IOException {
        this.cfbFS = HWPFDocumentCore.verifyAndBuildPOIFS(istream);
        this._mainStream = this.cfbFS.getPropertyRawData(STREAM_WORD_DOCUMENT);
        this._fib = new FileInformationBlock(this._mainStream);
        if (this._fib.isFEncrypted()) {
            throw new EncryptedDocumentException("Cannot process encrypted office files!");
        }
    }

    public abstract Range getRange();

    public abstract Range getOverallRange();

    public String getDocumentText() {
        return this.getText().toString();
    }

    @Internal
    public abstract StringBuilder getText();

    public CHPBinTable getCharacterTable() {
        return this._cbt;
    }

    public PAPBinTable getParagraphTable() {
        return this._pbt;
    }

    public SectionTable getSectionTable() {
        return this._st;
    }

    public StyleSheet getStyleSheet() {
        return this._ss;
    }

    public ListTables getListTables() {
        return this._lt;
    }

    public FontTable getFontTable() {
        return this._ft;
    }

    public FileInformationBlock getFileInformationBlock() {
        return this._fib;
    }

    public ObjectsPool getObjectsPool() {
        return this._objectPool;
    }

    public abstract TextPieceTable getTextTable();
}

