/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.HWPFDocumentCore;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.OldWordFileFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.BookmarksTables;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.CHPBinTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.CPSplitCalculator;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.ComplexFileTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.EscherRecordHolder;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FSPADocumentPart;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FSPATable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FieldsTables;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FontTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.ListTables;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PAPBinTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PicturesTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PlcfTxbxBkd;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.SectionTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.ShapesTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.StyleSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.SubdocumentType;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.TextPieceTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Bookmarks;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.BookmarksImpl;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Fields;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.FieldsImpl;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFList;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.OfficeDrawings;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.OfficeDrawingsImpl;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Range;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import java.io.IOException;
import java.io.InputStream;

public final class HWPFDocument
extends HWPFDocumentCore {
    private static final String PROPERTY_PRESERVE_BIN_TABLES = "com.wxiwei.fc.hwpf.preserveBinTables";
    private static final String PROPERTY_PRESERVE_TEXT_TABLE = "com.wxiwei.fc.hwpf.preserveTextTable";
    private static final String STREAM_DATA = "Data";
    private static final String STREAM_TABLE_0 = "0Table";
    private static final String STREAM_TABLE_1 = "1Table";
    protected byte[] _tableStream;
    protected byte[] _dataStream;
    protected ComplexFileTable _cft;
    protected StringBuilder _text;
    private FSPATable _fspaHeaders;
    private FSPATable _fspaMain;
    protected EscherRecordHolder _escherRecordHolder;
    protected PicturesTable _pictures;
    @Deprecated
    protected ShapesTable _officeArts;
    protected OfficeDrawingsImpl _officeDrawingsHeaders;
    protected OfficeDrawingsImpl _officeDrawingsMain;
    protected BookmarksTables _bookmarksTables;
    protected Bookmarks _bookmarks;
    protected FieldsTables _fieldsTables;
    protected Fields _fields;
    protected PlcfTxbxBkd txbxBkd;

    public HWPFDocument(InputStream istream) throws IOException {
        super(istream);
        CPSplitCalculator _cpSplit = new CPSplitCalculator(this._fib);
        if (this._fib.getNFib() < 106) {
            if (this._fib.getNFib() == 0) {
                throw new NullPointerException();
            }
            throw new OldWordFileFormatException("The document is too old - Word 95 or older. Try HWPFOldDocument instead?");
        }
        String name = STREAM_TABLE_0;
        if (this._fib.isFWhichTblStm()) {
            name = STREAM_TABLE_1;
        }
        try {
            this._tableStream = this.cfbFS.getPropertyRawData(name);
        }
        catch (Exception fnfe) {
            throw new IllegalStateException("Table Stream '" + name + "' wasn't found - Either the document is corrupt, or is Word95 (or earlier)");
        }
        this._fib.fillVariableFields(this._mainStream, this._tableStream);
        try {
            this._dataStream = this.cfbFS.getPropertyRawData(STREAM_DATA);
        }
        catch (Exception e) {
            this._dataStream = new byte[0];
        }
        int fcMin = 0;
        this._cft = new ComplexFileTable(this._mainStream, this._tableStream, this._fib.getFcClx(), fcMin);
        TextPieceTable _tpt = this._cft.getTextPieceTable();
        this._cbt = new CHPBinTable(this._mainStream, this._tableStream, this._fib.getFcPlcfbteChpx(), this._fib.getLcbPlcfbteChpx(), _tpt);
        this._pbt = new PAPBinTable(this._mainStream, this._tableStream, this._dataStream, this._fib.getFcPlcfbtePapx(), this._fib.getLcbPlcfbtePapx(), _tpt);
        this._text = _tpt.getText();
        this._cbt.rebuild(this._cft);
        this._pbt.rebuild(this._text, this._cft);
        this._fspaHeaders = new FSPATable(this._tableStream, this._fib, FSPADocumentPart.HEADER);
        this._fspaMain = new FSPATable(this._tableStream, this._fib, FSPADocumentPart.MAIN);
        this._escherRecordHolder = this._fib.getFcDggInfo() != 0 ? new EscherRecordHolder(this._tableStream, this._fib.getFcDggInfo(), this._fib.getLcbDggInfo()) : new EscherRecordHolder();
        this._pictures = new PicturesTable(this, this._dataStream, this._mainStream, this._fspaMain, this._escherRecordHolder);
        this._officeArts = new ShapesTable(this._tableStream, this._fib);
        this._officeDrawingsHeaders = new OfficeDrawingsImpl(this._fspaHeaders, this._escherRecordHolder, this._mainStream);
        this._officeDrawingsMain = new OfficeDrawingsImpl(this._fspaMain, this._escherRecordHolder, this._mainStream);
        this._st = new SectionTable(this._mainStream, this._tableStream, this._fib.getFcPlcfsed(), this._fib.getLcbPlcfsed(), fcMin, _tpt, _cpSplit);
        this._ss = new StyleSheet(this._tableStream, this._fib.getFcStshf());
        this._ft = new FontTable(this._tableStream, this._fib.getFcSttbfffn(), this._fib.getLcbSttbfffn());
        int listOffset = this._fib.getFcPlcfLst();
        int lfoOffset = this._fib.getFcPlfLfo();
        if (listOffset != 0 && this._fib.getLcbPlcfLst() != 0) {
            this._lt = new ListTables(this._tableStream, this._fib.getFcPlcfLst(), this._fib.getFcPlfLfo());
        }
        this._bookmarksTables = new BookmarksTables(this._tableStream, this._fib);
        this._bookmarks = new BookmarksImpl(this._bookmarksTables);
        this._fieldsTables = new FieldsTables(this._tableStream, this._fib);
        this._fields = new FieldsImpl(this._fieldsTables);
        this.txbxBkd = new PlcfTxbxBkd(this._tableStream, this._fib.getFcPlcfTxbxBkd(), this._fib.getLcbPlcfTxbxBkd());
    }

    @Override
    @Internal
    public TextPieceTable getTextTable() {
        return this._cft.getTextPieceTable();
    }

    @Override
    @Internal
    public StringBuilder getText() {
        return this._text;
    }

    @Override
    public Range getOverallRange() {
        return new Range(0, this._text.length(), this);
    }

    @Override
    public Range getRange() {
        return this.getRange(SubdocumentType.MAIN);
    }

    private Range getRange(SubdocumentType subdocument) {
        int startCp = 0;
        for (SubdocumentType previos : SubdocumentType.ORDERED) {
            int length = this.getFileInformationBlock().getSubdocumentTextStreamLength(previos);
            if (subdocument == previos) {
                return new Range(startCp, startCp + length, this);
            }
            startCp += length;
        }
        throw new UnsupportedOperationException("Subdocument type not supported: " + (Object)((Object)subdocument));
    }

    public Range getFootnoteRange() {
        return this.getRange(SubdocumentType.FOOTNOTE);
    }

    public Range getEndnoteRange() {
        return this.getRange(SubdocumentType.ENDNOTE);
    }

    public Range getCommentsRange() {
        return this.getRange(SubdocumentType.ANNOTATION);
    }

    public Range getMainTextboxRange() {
        return this.getRange(SubdocumentType.TEXTBOX);
    }

    public Range getHeaderStoryRange() {
        return this.getRange(SubdocumentType.HEADER);
    }

    public int characterLength() {
        return this._text.length();
    }

    public PicturesTable getPicturesTable() {
        return this._pictures;
    }

    @Internal
    public EscherRecordHolder getEscherRecordHolder() {
        return this._escherRecordHolder;
    }

    @Deprecated
    @Internal
    public ShapesTable getShapesTable() {
        return this._officeArts;
    }

    public OfficeDrawings getOfficeDrawingsHeaders() {
        return this._officeDrawingsHeaders;
    }

    public OfficeDrawings getOfficeDrawingsMain() {
        return this._officeDrawingsMain;
    }

    public Bookmarks getBookmarks() {
        return this._bookmarks;
    }

    @Deprecated
    @Internal
    public FieldsTables getFieldsTables() {
        return this._fieldsTables;
    }

    public Fields getFields() {
        return this._fields;
    }

    @Internal
    public byte[] getDataStream() {
        return this._dataStream;
    }

    @Internal
    public byte[] getTableStream() {
        return this._tableStream;
    }

    public int registerList(HWPFList list) {
        if (this._lt == null) {
            this._lt = new ListTables();
        }
        return this._lt.addList(list.getListData(), list.getOverride());
    }

    public void delete(int start, int length) {
        Range r = new Range(start, start + length, this);
        r.delete();
    }

    public int getTextboxStart(int txbx) {
        return this.txbxBkd.getCharPosition(txbx);
    }

    public int getTextboxEnd(int txbx) {
        return this.txbxBkd.getCharPosition(txbx + 1);
    }
}

