/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.LabelSSTRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.common.UnicodeString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFFont;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.IFont;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.RichTextString;
import java.util.Iterator;

public final class HSSFRichTextString
implements Comparable<HSSFRichTextString>,
RichTextString {
    public static final short NO_FONT = 0;
    private UnicodeString _string;
    private InternalWorkbook _book;
    private LabelSSTRecord _record;

    public HSSFRichTextString() {
        this("");
    }

    public HSSFRichTextString(String string2) {
        this._string = string2 == null ? new UnicodeString("") : new UnicodeString(string2);
    }

    HSSFRichTextString(InternalWorkbook book, LabelSSTRecord record) {
        this.setWorkbookReferences(book, record);
        this._string = book.getSSTString(record.getSSTIndex());
    }

    void setWorkbookReferences(InternalWorkbook book, LabelSSTRecord record) {
        this._book = book;
        this._record = record;
    }

    private UnicodeString cloneStringIfRequired() {
        if (this._book == null) {
            return this._string;
        }
        UnicodeString s = (UnicodeString)this._string.clone();
        return s;
    }

    private void addToSSTIfRequired() {
        if (this._book != null) {
            int index = this._book.addSSTString(this._string);
            this._record.setSSTIndex(index);
            this._string = this._book.getSSTString(index);
        }
    }

    @Override
    public void applyFont(int startIndex, int endIndex, short fontIndex) {
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("Start index must be less than end index.");
        }
        if (startIndex < 0 || endIndex > this.length()) {
            throw new IllegalArgumentException("Start and end index not in range.");
        }
        if (startIndex == endIndex) {
            return;
        }
        short currentFont = 0;
        if (endIndex != this.length()) {
            currentFont = this.getFontAtIndex(endIndex);
        }
        this._string = this.cloneStringIfRequired();
        Iterator<UnicodeString.FormatRun> formatting = this._string.formatIterator();
        if (formatting != null) {
            while (formatting.hasNext()) {
                UnicodeString.FormatRun r = formatting.next();
                if (r.getCharacterPos() < startIndex || r.getCharacterPos() >= endIndex) continue;
                formatting.remove();
            }
        }
        this._string.addFormatRun(new UnicodeString.FormatRun((short)startIndex, fontIndex));
        if (endIndex != this.length()) {
            this._string.addFormatRun(new UnicodeString.FormatRun((short)endIndex, currentFont));
        }
        this.addToSSTIfRequired();
    }

    @Override
    public void applyFont(int startIndex, int endIndex, IFont font) {
        this.applyFont(startIndex, endIndex, ((HSSFFont)font).getIndex());
    }

    @Override
    public void applyFont(IFont font) {
        this.applyFont(0, this._string.getCharCount(), font);
    }

    @Override
    public void clearFormatting() {
        this._string = this.cloneStringIfRequired();
        this._string.clearFormatting();
        this.addToSSTIfRequired();
    }

    public int getSSTIndex() {
        return this._record.getSSTIndex();
    }

    @Override
    public String getString() {
        return this._string.getString();
    }

    public UnicodeString getUnicodeString() {
        return this.cloneStringIfRequired();
    }

    UnicodeString getRawUnicodeString() {
        return this._string;
    }

    void setUnicodeString(UnicodeString str) {
        this._string = str;
    }

    @Override
    public int length() {
        return this._string.getCharCount();
    }

    public short getFontAtIndex(int index) {
        UnicodeString.FormatRun r;
        int size = this._string.getFormatRunCount();
        UnicodeString.FormatRun currentRun = null;
        for (int i = 0; i < size && (r = this._string.getFormatRun(i)).getCharacterPos() <= index; ++i) {
            currentRun = r;
        }
        if (currentRun == null) {
            return 0;
        }
        return currentRun.getFontIndex();
    }

    @Override
    public int numFormattingRuns() {
        return this._string.getFormatRunCount();
    }

    @Override
    public int getIndexOfFormattingRun(int index) {
        UnicodeString.FormatRun r = this._string.getFormatRun(index);
        return r.getCharacterPos();
    }

    public short getFontOfFormattingRun(int index) {
        UnicodeString.FormatRun r = this._string.getFormatRun(index);
        return r.getFontIndex();
    }

    @Override
    public int compareTo(HSSFRichTextString r) {
        return this._string.compareTo(r._string);
    }

    public boolean equals(Object o) {
        if (o instanceof HSSFRichTextString) {
            return this._string.equals(((HSSFRichTextString)o)._string);
        }
        return false;
    }

    public String toString() {
        return this._string.toString();
    }

    @Override
    public void applyFont(short fontIndex) {
        this.applyFont(0, this._string.getCharCount(), fontIndex);
    }
}

