/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.CollaboratingWorkbooksEnvironment;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.IStabilityClassifier;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.WorkbookEvaluator;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.BoolEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NumberEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.StringEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.udf.UDFFinder;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFEvaluationCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFEvaluationWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFName;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFRichTextString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFRow;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.CellValue;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.FormulaEvaluator;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ICell;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ACell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ASheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;

public class HSSFFormulaEvaluator
implements FormulaEvaluator {
    private WorkbookEvaluator _bookEvaluator;
    private AWorkbook _book;
    private HSSFEvaluationCell hssfEvaluationCell = null;

    public HSSFFormulaEvaluator(ASheet sheet, AWorkbook workbook) {
        this(workbook);
        this._book = workbook;
    }

    public HSSFFormulaEvaluator(AWorkbook workbook) {
        this(workbook, null);
        this._book = workbook;
    }

    public HSSFFormulaEvaluator(AWorkbook workbook, IStabilityClassifier stabilityClassifier) {
        this(workbook, stabilityClassifier, null);
    }

    private HSSFFormulaEvaluator(AWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        this._bookEvaluator = new WorkbookEvaluator(HSSFEvaluationWorkbook.create(workbook), stabilityClassifier, udfFinder);
    }

    public static HSSFFormulaEvaluator create(AWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        return new HSSFFormulaEvaluator(workbook, stabilityClassifier, udfFinder);
    }

    public static void setupEnvironment(String[] workbookNames, HSSFFormulaEvaluator[] evaluators) {
        WorkbookEvaluator[] wbEvals = new WorkbookEvaluator[evaluators.length];
        for (int i = 0; i < wbEvals.length; ++i) {
            wbEvals[i] = evaluators[i]._bookEvaluator;
        }
        CollaboratingWorkbooksEnvironment.setup(workbookNames, wbEvals);
    }

    public void setCurrentRow(HSSFRow row) {
    }

    @Override
    public void clearAllCachedResultValues() {
        this._bookEvaluator.clearAllCachedResultValues();
    }

    public void notifyUpdateCell(ACell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell(cell));
    }

    @Override
    public void notifyUpdateCell(ICell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell((ACell)((Object)cell)));
    }

    public void notifyDeleteCell(ACell cell) {
        this._bookEvaluator.notifyDeleteCell(new HSSFEvaluationCell(cell));
    }

    @Override
    public void notifyDeleteCell(ICell cell) {
        this._bookEvaluator.notifyDeleteCell(new HSSFEvaluationCell((ACell)((Object)cell)));
    }

    @Override
    public void notifySetFormula(ICell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell((ACell)((Object)cell)));
    }

    @Override
    public CellValue evaluate(ICell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 4: {
                return CellValue.valueOf(cell.getBooleanCellValue());
            }
            case 5: {
                return CellValue.getError(cell.getErrorCellValue());
            }
            case 2: {
                return this.evaluateFormulaCellValue(cell);
            }
            case 0: {
                return new CellValue(cell.getNumericCellValue());
            }
            case 1: {
                return new CellValue(cell.getRichStringCellValue().getString());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + cell.getCellType() + ")");
    }

    @Override
    public int evaluateFormulaCell(ICell cell) {
        if (cell == null || cell.getCellType() != 2) {
            return -1;
        }
        CellValue cv = this.evaluateFormulaCellValue(cell);
        HSSFFormulaEvaluator.setCellValue(cell, cv);
        return cv.getCellType();
    }

    @Override
    public HSSFCell evaluateInCell(ICell cell) {
        if (cell == null) {
            return null;
        }
        HSSFCell result = (HSSFCell)cell;
        if (cell.getCellType() == 2) {
            CellValue cv = this.evaluateFormulaCellValue(cell);
            HSSFFormulaEvaluator.setCellValue(cell, cv);
            HSSFFormulaEvaluator.setCellType(cell, cv);
        }
        return result;
    }

    private static void setCellType(ICell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                cell.setCellType(cellType);
                return;
            }
        }
        throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
    }

    private static void setCellValue(ICell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 4: {
                cell.setCellValue(cv.getBooleanValue());
                break;
            }
            case 5: {
                cell.setCellErrorValue(cv.getErrorValue());
                break;
            }
            case 0: {
                cell.setCellValue(cv.getNumberValue());
                break;
            }
            case 1: {
                cell.setCellValue(new HSSFRichTextString(cv.getStringValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
            }
        }
    }

    public static void evaluateAllFormulaCells(AWorkbook wb) {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(wb, new HSSFFormulaEvaluator(wb));
    }

    public static void evaluateAllFormulaCells(Workbook wb) {
    }

    private static void evaluateAllFormulaCells(Workbook wb, FormulaEvaluator evaluator) {
    }

    @Override
    public void evaluateAll() {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(this._book, this);
    }

    public CellValue evaluateFormulaCellValue(ICell cell) {
        if (this.hssfEvaluationCell != null) {
            this.hssfEvaluationCell.setHSSFCell((ACell)((Object)cell));
        } else {
            this.hssfEvaluationCell = new HSSFEvaluationCell((ACell)((Object)cell));
        }
        this._bookEvaluator.clearAllCachedResultValues();
        ValueEval eval = this._bookEvaluator.evaluate(this.hssfEvaluationCell);
        if (eval instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval;
            return new CellValue(ne.getNumberValue());
        }
        if (eval instanceof BoolEval) {
            BoolEval be = (BoolEval)eval;
            return CellValue.valueOf(be.getBooleanValue());
        }
        if (eval instanceof StringEval) {
            StringEval ne = (StringEval)eval;
            return new CellValue(ne.getStringValue());
        }
        if (eval instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)eval).getErrorCode());
        }
        if (eval == null) {
            return null;
        }
        throw new RuntimeException("Unexpected eval class (" + eval.getClass().getName() + ")");
    }

    public ValueEval evaluateFormulaValueEval(ACell cell) {
        if (this.hssfEvaluationCell != null) {
            this.hssfEvaluationCell.setHSSFCell(cell);
        } else {
            this.hssfEvaluationCell = new HSSFEvaluationCell(cell);
        }
        this._bookEvaluator.clearAllCachedResultValues();
        return this._bookEvaluator.evaluate(this.hssfEvaluationCell);
    }

    public ValueEval evaluateFormulaValueEval(HSSFName name) {
        return null;
    }
}

