/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFRichTextString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFTextbox;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;

public class HSSFAutoShape
extends HSSFTextbox {
    private Float[] adjusts;

    public HSSFAutoShape(AWorkbook workbook, EscherContainerRecord escherContainer, HSSFShape parent, HSSFAnchor anchor, int shapeType) {
        super(escherContainer, parent, anchor);
        this.setShapeType(shapeType);
        this.processLineWidth();
        this.processLine(escherContainer, workbook);
        this.processSimpleBackground(escherContainer, workbook);
        this.processRotationAndFlip(escherContainer);
        String unicodeText = ShapeKit.getUnicodeGeoText(escherContainer);
        if (unicodeText != null && unicodeText.length() > 0) {
            this.setString(new HSSFRichTextString(unicodeText));
            this.setWordArt(true);
            this.setNoFill(true);
            this.setFontColor(this.getFillColor());
        }
    }

    public Float[] getAdjustmentValue() {
        return this.adjusts;
    }

    public void setAdjustmentValue(EscherContainerRecord escherContainer) {
        this.adjusts = ShapeKit.getAdjustmentValue(escherContainer);
    }
}

