/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.crypto;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.crypto.RC4;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.HexDump;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianOutputStream;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class Biff8EncryptionKey {
    private static final int KEY_DIGEST_LENGTH = 5;
    private static final int PASSWORD_HASH_NUMBER_OF_BYTES_USED = 5;
    private final byte[] _keyDigest;
    private static final ThreadLocal<String> _userPasswordTLS = new ThreadLocal();

    public static Biff8EncryptionKey create(byte[] docId) {
        return new Biff8EncryptionKey(Biff8EncryptionKey.createKeyDigest("VelvetSweatshop", docId));
    }

    public static Biff8EncryptionKey create(String password, byte[] docIdData) {
        return new Biff8EncryptionKey(Biff8EncryptionKey.createKeyDigest(password, docIdData));
    }

    Biff8EncryptionKey(byte[] keyDigest) {
        if (keyDigest.length != 5) {
            throw new IllegalArgumentException("Expected 5 byte key digest, but got " + HexDump.toHex(keyDigest));
        }
        this._keyDigest = keyDigest;
    }

    static byte[] createKeyDigest(String password, byte[] docIdData) {
        MessageDigest md5;
        Biff8EncryptionKey.check16Bytes(docIdData, "docId");
        int nChars = Math.min(password.length(), 16);
        byte[] passwordData = new byte[nChars * 2];
        for (int i = 0; i < nChars; ++i) {
            char ch = password.charAt(i);
            passwordData[i * 2 + 0] = (byte)(ch << 0 & 0xFF);
            passwordData[i * 2 + 1] = (byte)(ch << 8 & 0xFF);
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md5.update(passwordData);
        byte[] passwordHash = md5.digest();
        md5.reset();
        for (int i = 0; i < 16; ++i) {
            md5.update(passwordHash, 0, 5);
            md5.update(docIdData, 0, docIdData.length);
        }
        byte[] kd = md5.digest();
        byte[] result = new byte[5];
        System.arraycopy(kd, 0, result, 0, 5);
        return result;
    }

    public boolean validate(byte[] saltData, byte[] saltHash) {
        MessageDigest md5;
        Biff8EncryptionKey.check16Bytes(saltData, "saltData");
        Biff8EncryptionKey.check16Bytes(saltHash, "saltHash");
        RC4 rc4 = this.createRC4(0);
        byte[] saltDataPrime = (byte[])saltData.clone();
        rc4.encrypt(saltDataPrime);
        byte[] saltHashPrime = (byte[])saltHash.clone();
        rc4.encrypt(saltHashPrime);
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md5.update(saltDataPrime);
        byte[] finalSaltResult = md5.digest();
        return Arrays.equals(saltHashPrime, finalSaltResult);
    }

    private static byte[] xor(byte[] a, byte[] b) {
        byte[] c = new byte[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (byte)(a[i] ^ b[i]);
        }
        return c;
    }

    private static void check16Bytes(byte[] data, String argName) {
        if (data.length != 16) {
            throw new IllegalArgumentException("Expected 16 byte " + argName + ", but got " + HexDump.toHex(data));
        }
    }

    RC4 createRC4(int keyBlockNo) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md5.update(this._keyDigest);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        new LittleEndianOutputStream(baos).writeInt(keyBlockNo);
        md5.update(baos.toByteArray());
        byte[] digest = md5.digest();
        return new RC4(digest);
    }

    public static void setCurrentUserPassword(String password) {
        _userPasswordTLS.set(password);
    }

    public static String getCurrentUserPassword() {
        return _userPasswordTLS.get();
    }
}

