/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CommonObjectDataSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.EmbeddedObjectRefSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.EndSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.FtCblsSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.GroupMarkerSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.LbsDataSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.NoteStructureSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.HexDump;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianInput;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianOutput;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianOutputStream;
import java.io.ByteArrayOutputStream;

public abstract class SubRecord {
    protected SubRecord() {
    }

    public static SubRecord createSubRecord(LittleEndianInput in, int cmoOt) {
        int sid = in.readUShort();
        int secondUShort = in.readUShort();
        switch (sid) {
            case 21: {
                return new CommonObjectDataSubRecord(in, secondUShort);
            }
            case 9: {
                return new EmbeddedObjectRefSubRecord(in, secondUShort);
            }
            case 6: {
                return new GroupMarkerSubRecord(in, secondUShort);
            }
            case 0: {
                return new EndSubRecord(in, secondUShort);
            }
            case 13: {
                return new NoteStructureSubRecord(in, secondUShort);
            }
            case 19: {
                return new LbsDataSubRecord(in, secondUShort, cmoOt);
            }
            case 12: {
                return new FtCblsSubRecord(in, secondUShort);
            }
        }
        return new UnknownSubRecord(in, sid, secondUShort);
    }

    protected abstract int getDataSize();

    public byte[] serialize() {
        int size = this.getDataSize() + 4;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        this.serialize(new LittleEndianOutputStream(baos));
        if (baos.size() != size) {
            throw new RuntimeException("write size mismatch");
        }
        return baos.toByteArray();
    }

    public abstract void serialize(LittleEndianOutput var1);

    public abstract Object clone();

    public boolean isTerminating() {
        return false;
    }

    private static final class UnknownSubRecord
    extends SubRecord {
        private final int _sid;
        private final byte[] _data;

        public UnknownSubRecord(LittleEndianInput in, int sid, int size) {
            this._sid = sid;
            byte[] buf = new byte[size];
            in.readFully(buf);
            this._data = buf;
        }

        @Override
        protected int getDataSize() {
            return this._data.length;
        }

        @Override
        public void serialize(LittleEndianOutput out) {
            out.writeShort(this._sid);
            out.writeShort(this._data.length);
            out.write(this._data);
        }

        @Override
        public Object clone() {
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append("sid=").append(HexDump.shortToHex(this._sid));
            sb.append(" size=").append(this._data.length);
            sb.append(" : ").append(HexDump.toHex(this._data));
            sb.append("]\n");
            return sb.toString();
        }
    }
}

