/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.DefaultEscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBoolProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientDataRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherDgRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherDggRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSerializationListener;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpgrRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherTextboxRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.CommentShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.ConvertAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.DrawingManager2;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.TextboxShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.AbstractEscherHolderRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CommonObjectDataSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.ContinueRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.DrawingRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.EndSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.GroupMarkerSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.NoteRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.ObjRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.TextObjectRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFChart;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFClientAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFPatriarch;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShapeContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShapeFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFTextbox;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogger;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class EscherAggregate
extends AbstractEscherHolderRecord {
    public static final short sid = 9876;
    private static POILogger log = POILogFactory.getLogger(EscherAggregate.class);
    protected HSSFPatriarch patriarch;
    private Map<EscherRecord, Record> shapeToObj = new HashMap<EscherRecord, Record>();
    private Map<EscherRecord, List<Record>> chartToObj = new HashMap<EscherRecord, List<Record>>();
    private DrawingManager2 drawingManager;
    private short drawingGroupId;
    private List tailRec = new ArrayList();

    public EscherAggregate(DrawingManager2 drawingManager) {
        this.drawingManager = drawingManager;
    }

    @Override
    public short getSid() {
        return 9876;
    }

    @Override
    public String toString() {
        String nl = System.getProperty("line.separtor");
        StringBuffer result = new StringBuffer();
        result.append('[').append(this.getRecordName()).append(']' + nl);
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            result.append(escherRecord.toString());
        }
        result.append("[/").append(this.getRecordName()).append(']' + nl);
        return result.toString();
    }

    public static int shapeContainRecords(List records, int currentDrawingRecord) {
        int count = 0;
        if ((EscherAggregate.sid(records, currentDrawingRecord) == 236 || EscherAggregate.sid(records, currentDrawingRecord) == 60) && EscherAggregate.isObjectRecord(records, currentDrawingRecord + 1)) {
            CommonObjectDataSubRecord commonObjectDataSubRecord;
            Record record = (Record)records.get(currentDrawingRecord + 1);
            count = 2;
            if (record instanceof ObjRecord && ((ObjRecord)record).getSubRecords().get(0) instanceof CommonObjectDataSubRecord && (commonObjectDataSubRecord = (CommonObjectDataSubRecord)((ObjRecord)record).getSubRecords().get(0)).getObjectType() == 5) {
                ArrayList<Record> chartRecordsList = new ArrayList<Record>();
                record = (Record)records.get(currentDrawingRecord += 2);
                while (record.getSid() != 10) {
                    chartRecordsList.add(record);
                    ++count;
                    record = (Record)records.get(++currentDrawingRecord);
                }
                return count + 1;
            }
            if (records.get(currentDrawingRecord + 2) instanceof NoteRecord) {
                ++count;
            }
        }
        return count;
    }

    public static int nextDrawingRecord(List records, int currentIndex) {
        int max = records.size();
        for (int i = currentIndex + 1; i < max; ++i) {
            Record record;
            Object rb = records.get(i);
            if (!(rb instanceof Record) || (record = (Record)rb).getSid() != 236 && record.getSid() != 60) continue;
            return i;
        }
        return -1;
    }

    public static EscherAggregate createAggregate(List records, int locFirstDrawingRecord, DrawingManager2 drawingManager) {
        int bytesRead;
        final ArrayList shapeRecords = new ArrayList();
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory(){

            @Override
            public EscherRecord createRecord(byte[] data, int offset) {
                EscherRecord r = super.createRecord(data, offset);
                if (r.getRecordId() == -4079 || r.getRecordId() == -4083) {
                    shapeRecords.add(r);
                }
                return r;
            }
        };
        EscherAggregate agg = new EscherAggregate(drawingManager);
        int loc = locFirstDrawingRecord;
        int dataSize = 0;
        while (loc > -1 && loc + 1 < records.size() && (EscherAggregate.sid(records, loc) == 236 || EscherAggregate.sid(records, loc) == 60)) {
            if (EscherAggregate.isObjectRecord(records, loc + 1)) {
                dataSize = EscherAggregate.sid(records, loc) == 60 ? (dataSize += ((ContinueRecord)records.get(loc)).getDataSize()) : (dataSize += ((DrawingRecord)records.get(loc)).getData().length);
            }
            loc = EscherAggregate.nextDrawingRecord(records, loc);
        }
        byte[] buffer = new byte[dataSize];
        int offset = 0;
        loc = locFirstDrawingRecord;
        while (loc > -1 && loc + 1 < records.size() && (EscherAggregate.sid(records, loc) == 236 || EscherAggregate.sid(records, loc) == 60)) {
            if (EscherAggregate.isObjectRecord(records, loc + 1)) {
                byte[] data;
                if (EscherAggregate.sid(records, loc) == 60) {
                    ContinueRecord contd = (ContinueRecord)records.get(loc);
                    data = contd.getData();
                } else {
                    DrawingRecord drawingRecord = (DrawingRecord)records.get(loc);
                    data = drawingRecord.getData();
                }
                if (data != null) {
                    System.arraycopy(data, 0, buffer, offset, data.length);
                    offset += data.length;
                }
            }
            loc = EscherAggregate.nextDrawingRecord(records, loc);
        }
        for (int pos = 0; pos < dataSize; pos += bytesRead) {
            try {
                EscherRecord r = recordFactory.createRecord(buffer, pos);
                bytesRead = r.fillFields(buffer, pos, recordFactory);
                agg.addEscherRecord(r);
                continue;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        loc = locFirstDrawingRecord;
        int shapeIndex = 0;
        agg.shapeToObj = new HashMap<EscherRecord, Record>();
        while (loc > -1 && loc + 1 < records.size() && (EscherAggregate.sid(records, loc) == 236 || EscherAggregate.sid(records, loc) == 60)) {
            if (!EscherAggregate.isObjectRecord(records, loc + 1)) {
                loc = EscherAggregate.nextDrawingRecord(records, loc);
                continue;
            }
            Record record = (Record)records.get(loc + 1);
            try {
                if (record instanceof ObjRecord && ((ObjRecord)record).getSubRecords().get(0) instanceof CommonObjectDataSubRecord) {
                    CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)((ObjRecord)record).getSubRecords().get(0);
                    if (commonObjectDataSubRecord.getObjectType() == 5) {
                        ArrayList<Record> chartRecordsList = new ArrayList<Record>();
                        record = (Record)records.get(loc += 2);
                        while (record.getSid() != 10) {
                            chartRecordsList.add(record);
                            record = (Record)records.get(++loc);
                        }
                        agg.chartToObj.put((EscherRecord)shapeRecords.get(shapeIndex++), chartRecordsList);
                        ++loc;
                        continue;
                    }
                    agg.shapeToObj.put((EscherRecord)shapeRecords.get(shapeIndex++), record);
                    loc += 2;
                    continue;
                }
                agg.shapeToObj.put((EscherRecord)shapeRecords.get(shapeIndex++), record);
                loc += 2;
            }
            catch (Exception e) {
                break;
            }
        }
        return agg;
    }

    @Override
    public int serialize(int offset, byte[] data) {
        int i;
        this.convertUserModelToRecords();
        List<EscherRecord> records = this.getEscherRecords();
        int size = this.getEscherRecordSize(records);
        byte[] buffer = new byte[size];
        final ArrayList spEndingOffsets = new ArrayList();
        final ArrayList shapes = new ArrayList();
        int pos = 0;
        for (EscherRecord e : records) {
            pos += e.serialize(pos, buffer, new EscherSerializationListener(){

                @Override
                public void beforeRecordSerialize(int offset, short recordId, EscherRecord record) {
                }

                @Override
                public void afterRecordSerialize(int offset, short recordId, int size, EscherRecord record) {
                    if (recordId == -4079 || recordId == -4083) {
                        spEndingOffsets.add(offset);
                        shapes.add(record);
                    }
                }
            });
        }
        shapes.add(0, null);
        spEndingOffsets.add(0, null);
        pos = offset;
        for (i = 1; i < shapes.size(); ++i) {
            int endOffset = (Integer)spEndingOffsets.get(i) - 1;
            int startOffset = i == 1 ? 0 : (Integer)spEndingOffsets.get(i - 1);
            DrawingRecord drawing = new DrawingRecord();
            byte[] drawingData = new byte[endOffset - startOffset + 1];
            System.arraycopy(buffer, startOffset, drawingData, 0, drawingData.length);
            drawing.setData(drawingData);
            int temp = drawing.serialize(pos, data);
            pos += temp;
            Record obj = this.shapeToObj.get(shapes.get(i));
            temp = obj.serialize(pos, data);
            pos += temp;
        }
        for (i = 0; i < this.tailRec.size(); ++i) {
            Record rec = (Record)this.tailRec.get(i);
            pos += rec.serialize(pos, data);
        }
        int bytesWritten = pos - offset;
        if (bytesWritten != this.getRecordSize()) {
            throw new RecordFormatException(bytesWritten + " bytes written but getRecordSize() reports " + this.getRecordSize());
        }
        return bytesWritten;
    }

    private int getEscherRecordSize(List records) {
        int size = 0;
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            size += ((EscherRecord)iterator.next()).getRecordSize();
        }
        return size;
    }

    @Override
    public int getRecordSize() {
        this.convertUserModelToRecords();
        List<EscherRecord> records = this.getEscherRecords();
        int rawEscherSize = this.getEscherRecordSize(records);
        int drawingRecordSize = rawEscherSize + this.shapeToObj.size() * 4;
        int objRecordSize = 0;
        for (Record r : this.shapeToObj.values()) {
            objRecordSize += r.getRecordSize();
        }
        int tailRecordSize = 0;
        for (Record r : this.tailRec) {
            tailRecordSize += r.getRecordSize();
        }
        return drawingRecordSize + objRecordSize + tailRecordSize;
    }

    Object associateShapeToObjRecord(EscherRecord r, ObjRecord objRecord) {
        return this.shapeToObj.put(r, objRecord);
    }

    public HSSFPatriarch getPatriarch() {
        return this.patriarch;
    }

    public void setPatriarch(HSSFPatriarch patriarch) {
        this.patriarch = patriarch;
    }

    public void convertRecordsToUserModel(AWorkbook workbook) {
        if (this.patriarch == null) {
            throw new IllegalStateException("Must call setPatriarch() first");
        }
        List<EscherContainerRecord> containerList = this.getgetEscherContainers();
        if (containerList.size() == 0) {
            return;
        }
        HSSFShape shape = null;
        int index = 0;
        if (containerList.get(index).getChildContainers().size() > 0) {
            EscherContainerRecord topContainer;
            List<EscherContainerRecord> tcc;
            if ((tcc = (topContainer = containerList.get(index++).getChildContainers().get(0)).getChildContainers()).size() == 0) {
                throw new IllegalStateException("No child escher containers at the point that should hold the patriach data, and one container per top level shape!");
            }
            EscherContainerRecord patriachContainer = tcc.get(0);
            EscherSpgrRecord spgr = null;
            Iterator<EscherRecord> it = patriachContainer.getChildIterator();
            while (it.hasNext()) {
                EscherRecord r = it.next();
                if (!(r instanceof EscherSpgrRecord)) continue;
                spgr = (EscherSpgrRecord)r;
                break;
            }
            if (spgr != null) {
                this.patriarch.setCoordinates(spgr.getRectX1(), spgr.getRectY1(), spgr.getRectX2(), spgr.getRectY2());
            }
            for (int i = 1; i < tcc.size(); ++i) {
                EscherContainerRecord shapeContainer = tcc.get(i);
                shape = HSSFShapeFactory.createShape(workbook, this.shapeToObj, shapeContainer, null);
                if (shape == null) continue;
                this.convertRecordsToUserModel(shapeContainer, shape);
                this.patriarch.addShape(shape);
            }
        }
        while (index < containerList.size()) {
            EscherContainerRecord shapeContainer = containerList.get(index);
            shape = HSSFShapeFactory.createShape(workbook, this.shapeToObj, shapeContainer, null);
            if (shape != null) {
                this.convertRecordsToUserModel(shapeContainer, shape);
                this.patriarch.addShape(shape);
            }
            ++index;
        }
        this.drawingManager.getDgg().setFileIdClusters(new EscherDggRecord.FileIdCluster[0]);
    }

    private void convertRecordsToUserModel(EscherContainerRecord shapeContainer, Object model) {
        Iterator<EscherRecord> it = shapeContainer.getChildIterator();
        while (it.hasNext()) {
            EscherRecord r = it.next();
            if (r instanceof EscherSpgrRecord) {
                EscherSpgrRecord spgr = (EscherSpgrRecord)r;
                if (model instanceof HSSFShapeGroup) {
                    HSSFShapeGroup group = (HSSFShapeGroup)model;
                    group.setCoordinates(spgr.getRectX1(), spgr.getRectY1(), spgr.getRectX2(), spgr.getRectY2());
                    continue;
                }
                throw new IllegalStateException("Got top level anchor but not processing a group");
            }
            if (r instanceof EscherClientAnchorRecord) continue;
            if (r instanceof EscherTextboxRecord) {
                EscherTextboxRecord tbr = (EscherTextboxRecord)r;
                Record obj = this.shapeToObj.get(tbr);
                if (!(obj instanceof TextObjectRecord) || !(model instanceof HSSFTextbox)) continue;
                TextObjectRecord textObj = (TextObjectRecord)obj;
                HSSFTextbox textbox = (HSSFTextbox)model;
                if (!textbox.isWordArt()) {
                    textbox.setString(textObj.getStr());
                }
                textbox.setHorizontalAlignment((short)textObj.getHorizontalTextAlignment());
                textbox.setVerticalAlignment((short)textObj.getVerticalTextAlignment());
                continue;
            }
            if (r instanceof EscherClientDataRecord && model instanceof HSSFChart) {
                EscherClientDataRecord cdr = (EscherClientDataRecord)r;
                List<Record> recordsList = this.chartToObj.get(cdr);
                HSSFChart.convertRecordsToChart(recordsList, (HSSFChart)model);
                continue;
            }
            if (!(r instanceof EscherSpRecord) && !(r instanceof EscherOptRecord)) continue;
        }
    }

    public void clear() {
        this.clearEscherRecords();
        this.shapeToObj.clear();
        this.chartToObj.clear();
    }

    @Override
    protected String getRecordName() {
        return "ESCHERAGGREGATE";
    }

    private static boolean isObjectRecord(List records, int loc) {
        return EscherAggregate.sid(records, loc) == 93 || EscherAggregate.sid(records, loc) == 438;
    }

    private void convertUserModelToRecords() {
        if (this.patriarch != null) {
            this.shapeToObj.clear();
            this.tailRec.clear();
            this.chartToObj.clear();
            this.clearEscherRecords();
            if (this.patriarch.getChildren().size() != 0) {
                this.convertPatriarch(this.patriarch);
                EscherContainerRecord dgContainer = (EscherContainerRecord)this.getEscherRecord(0);
                EscherContainerRecord spgrContainer = null;
                Iterator<EscherRecord> iter = dgContainer.getChildIterator();
                while (iter.hasNext()) {
                    EscherRecord child = iter.next();
                    if (child.getRecordId() != -4093) continue;
                    spgrContainer = (EscherContainerRecord)child;
                }
                this.convertShapes(this.patriarch, spgrContainer, this.shapeToObj);
                this.patriarch = null;
            }
        }
    }

    private void convertShapes(HSSFShapeContainer parent, EscherContainerRecord escherParent, Map shapeToObj) {
        if (escherParent == null) {
            throw new IllegalArgumentException("Parent record required");
        }
        List shapes = parent.getChildren();
        for (HSSFShape shape : shapes) {
            if (shape instanceof HSSFShapeGroup) {
                this.convertGroup((HSSFShapeGroup)shape, escherParent, shapeToObj);
                continue;
            }
            AbstractShape shapeModel = AbstractShape.createShape(shape, this.drawingManager.allocateShapeId(this.drawingGroupId));
            shapeToObj.put(this.findClientData(shapeModel.getSpContainer()), shapeModel.getObjRecord());
            if (shapeModel instanceof TextboxShape) {
                EscherRecord escherTextbox = ((TextboxShape)shapeModel).getEscherTextbox();
                shapeToObj.put(escherTextbox, ((TextboxShape)shapeModel).getTextObjectRecord());
                if (shapeModel instanceof CommentShape) {
                    CommentShape comment = (CommentShape)shapeModel;
                    this.tailRec.add(comment.getNoteRecord());
                }
            }
            escherParent.addChildRecord(shapeModel.getSpContainer());
        }
    }

    private void convertGroup(HSSFShapeGroup shape, EscherContainerRecord escherParent, Map shapeToObj) {
        EscherContainerRecord spgrContainer = new EscherContainerRecord();
        EscherContainerRecord spContainer = new EscherContainerRecord();
        EscherSpgrRecord spgr = new EscherSpgrRecord();
        EscherSpRecord sp = new EscherSpRecord();
        EscherOptRecord opt = new EscherOptRecord();
        EscherClientDataRecord clientData = new EscherClientDataRecord();
        spgrContainer.setRecordId((short)-4093);
        spgrContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        spgr.setRecordId((short)-4087);
        spgr.setOptions((short)1);
        spgr.setRectX1(shape.getX1());
        spgr.setRectY1(shape.getY1());
        spgr.setRectX2(shape.getX2());
        spgr.setRectY2(shape.getY2());
        sp.setRecordId((short)-4086);
        sp.setOptions((short)2);
        int shapeId = this.drawingManager.allocateShapeId(this.drawingGroupId);
        sp.setShapeId(shapeId);
        if (shape.getAnchor() instanceof HSSFClientAnchor) {
            sp.setFlags(513);
        } else {
            sp.setFlags(515);
        }
        opt.setRecordId((short)-4085);
        opt.setOptions((short)35);
        opt.addEscherProperty(new EscherBoolProperty(127, 262148));
        opt.addEscherProperty(new EscherBoolProperty(959, 524288));
        EscherRecord anchor = ConvertAnchor.createAnchor(shape.getAnchor());
        clientData.setRecordId((short)-4079);
        clientData.setOptions((short)0);
        spgrContainer.addChildRecord(spContainer);
        spContainer.addChildRecord(spgr);
        spContainer.addChildRecord(sp);
        spContainer.addChildRecord(opt);
        spContainer.addChildRecord(anchor);
        spContainer.addChildRecord(clientData);
        ObjRecord obj = new ObjRecord();
        CommonObjectDataSubRecord cmo = new CommonObjectDataSubRecord();
        cmo.setObjectType((short)0);
        cmo.setObjectId(shapeId);
        cmo.setLocked(true);
        cmo.setPrintable(true);
        cmo.setAutofill(true);
        cmo.setAutoline(true);
        GroupMarkerSubRecord gmo = new GroupMarkerSubRecord();
        EndSubRecord end = new EndSubRecord();
        obj.addSubRecord(cmo);
        obj.addSubRecord(gmo);
        obj.addSubRecord(end);
        shapeToObj.put(clientData, obj);
        escherParent.addChildRecord(spgrContainer);
        this.convertShapes(shape, spgrContainer, shapeToObj);
    }

    private EscherRecord findClientData(EscherContainerRecord spContainer) {
        Iterator<EscherRecord> iterator = spContainer.getChildIterator();
        while (iterator.hasNext()) {
            EscherRecord r = iterator.next();
            if (r.getRecordId() != -4079) continue;
            return r;
        }
        throw new IllegalArgumentException("Can not find client data record");
    }

    private void convertPatriarch(HSSFPatriarch patriarch) {
        EscherContainerRecord dgContainer = new EscherContainerRecord();
        EscherContainerRecord spgrContainer = new EscherContainerRecord();
        EscherContainerRecord spContainer1 = new EscherContainerRecord();
        EscherSpgrRecord spgr = new EscherSpgrRecord();
        EscherSpRecord sp1 = new EscherSpRecord();
        dgContainer.setRecordId((short)-4094);
        dgContainer.setOptions((short)15);
        EscherDgRecord dg = this.drawingManager.createDgRecord();
        this.drawingGroupId = dg.getDrawingGroupId();
        spgrContainer.setRecordId((short)-4093);
        spgrContainer.setOptions((short)15);
        spContainer1.setRecordId((short)-4092);
        spContainer1.setOptions((short)15);
        spgr.setRecordId((short)-4087);
        spgr.setOptions((short)1);
        spgr.setRectX1(patriarch.getX1());
        spgr.setRectY1(patriarch.getY1());
        spgr.setRectX2(patriarch.getX2());
        spgr.setRectY2(patriarch.getY2());
        sp1.setRecordId((short)-4086);
        sp1.setOptions((short)2);
        sp1.setShapeId(this.drawingManager.allocateShapeId(dg.getDrawingGroupId()));
        sp1.setFlags(5);
        dgContainer.addChildRecord(dg);
        dgContainer.addChildRecord(spgrContainer);
        spgrContainer.addChildRecord(spContainer1);
        spContainer1.addChildRecord(spgr);
        spContainer1.addChildRecord(sp1);
        this.addEscherRecord(dgContainer);
    }

    private static short sid(List records, int loc) {
        return ((Record)records.get(loc)).getSid();
    }
}

