/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.StandardRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianOutput;

public final class DrawingRecord
extends StandardRecord {
    public static final short sid = 236;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private byte[] recordData;
    private byte[] contd;

    public DrawingRecord() {
        this.recordData = EMPTY_BYTE_ARRAY;
    }

    public DrawingRecord(RecordInputStream in) {
        this.recordData = in.readRemainder();
    }

    public void processContinueRecord(byte[] record) {
        if (this.contd == null) {
            this.contd = record;
        } else {
            byte[] newBuffer = new byte[this.contd.length + record.length];
            System.arraycopy(this.contd, 0, newBuffer, 0, this.contd.length);
            System.arraycopy(record, 0, newBuffer, this.contd.length, record.length);
            this.contd = newBuffer;
        }
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.write(this.recordData);
    }

    @Override
    protected int getDataSize() {
        return this.recordData.length;
    }

    public int getDataLength() {
        if (this.contd != null) {
            return this.recordData.length + this.contd.length;
        }
        return this.recordData.length;
    }

    @Override
    public short getSid() {
        return 236;
    }

    public byte[] getData() {
        if (this.contd != null) {
            byte[] newBuffer = new byte[this.recordData.length + this.contd.length];
            System.arraycopy(this.recordData, 0, newBuffer, 0, this.recordData.length);
            System.arraycopy(this.contd, 0, newBuffer, this.recordData.length, this.contd.length);
            return newBuffer;
        }
        return this.recordData;
    }

    public void setData(byte[] thedata) {
        if (thedata == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.recordData = thedata;
    }

    @Override
    public Object clone() {
        DrawingRecord rec = new DrawingRecord();
        rec.recordData = (byte[])this.recordData.clone();
        if (this.contd != null) {
            rec.contd = (byte[])this.contd.clone();
        }
        return rec;
    }
}

