/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.DefaultEscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.NullEscherSerializationListener;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.util.LazilyConcatenatedByteArray;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractEscherHolderRecord
extends Record {
    private static boolean DESERIALISE;
    private List<EscherRecord> escherRecords;
    private LazilyConcatenatedByteArray rawDataContainer = new LazilyConcatenatedByteArray();

    public AbstractEscherHolderRecord() {
        this.escherRecords = new ArrayList<EscherRecord>();
    }

    public AbstractEscherHolderRecord(RecordInputStream in) {
        this.escherRecords = new ArrayList<EscherRecord>();
        if (!DESERIALISE) {
            this.rawDataContainer.concatenate(in.readRemainder());
        } else {
            byte[] data = in.readAllContinuedRemainder();
            this.convertToEscherRecords(0, data.length, data);
        }
    }

    protected void convertRawBytesToEscherRecords() {
        byte[] rawData = this.getRawData();
        this.convertToEscherRecords(0, rawData.length, rawData);
    }

    private void convertToEscherRecords(int offset, int size, byte[] data) {
        int bytesRead;
        this.escherRecords.clear();
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
        for (int pos = offset; pos < offset + size; pos += bytesRead) {
            EscherRecord r = recordFactory.createRecord(data, pos);
            bytesRead = r.fillFields(data, pos, recordFactory);
            this.escherRecords.add(r);
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buffer.append('[' + this.getRecordName() + ']' + nl);
        if (this.escherRecords.size() == 0) {
            buffer.append("No Escher Records Decoded" + nl);
        }
        for (EscherRecord r : this.escherRecords) {
            buffer.append(r.toString());
        }
        buffer.append("[/" + this.getRecordName() + ']' + nl);
        return buffer.toString();
    }

    protected abstract String getRecordName();

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, this.getSid());
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        byte[] rawData = this.getRawData();
        if (this.escherRecords.size() == 0 && rawData != null) {
            LittleEndian.putShort(data, 0 + offset, this.getSid());
            LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
            System.arraycopy(rawData, 0, data, 4 + offset, rawData.length);
            return rawData.length + 4;
        }
        LittleEndian.putShort(data, 0 + offset, this.getSid());
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        int pos = offset + 4;
        for (EscherRecord r : this.escherRecords) {
            pos += r.serialize(pos, data, new NullEscherSerializationListener());
        }
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        byte[] rawData = this.getRawData();
        if (this.escherRecords.size() == 0 && rawData != null) {
            return rawData.length;
        }
        int size = 0;
        for (EscherRecord r : this.escherRecords) {
            size += r.getRecordSize();
        }
        return size;
    }

    @Override
    public abstract short getSid();

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    public void addEscherRecord(int index, EscherRecord element) {
        this.escherRecords.add(index, element);
    }

    public boolean addEscherRecord(EscherRecord element) {
        return this.escherRecords.add(element);
    }

    public List<EscherRecord> getEscherRecords() {
        return this.escherRecords;
    }

    public void clearEscherRecords() {
        this.escherRecords.clear();
    }

    public EscherContainerRecord getEscherContainer() {
        for (EscherRecord er : this.escherRecords) {
            if (!(er instanceof EscherContainerRecord)) continue;
            return (EscherContainerRecord)er;
        }
        return null;
    }

    public List<EscherContainerRecord> getgetEscherContainers() {
        ArrayList<EscherContainerRecord> containers = new ArrayList<EscherContainerRecord>();
        for (EscherRecord er : this.escherRecords) {
            if (!(er instanceof EscherContainerRecord)) continue;
            containers.add((EscherContainerRecord)er);
        }
        return containers;
    }

    public EscherRecord findFirstWithId(short id2) {
        return this.findFirstWithId(id2, this.getEscherRecords());
    }

    private EscherRecord findFirstWithId(short id2, List<EscherRecord> records) {
        for (EscherRecord r : records) {
            if (r.getRecordId() != id2) continue;
            return r;
        }
        for (EscherRecord r : records) {
            EscherRecord found;
            if (!r.isContainerRecord() || (found = this.findFirstWithId(id2, r.getChildRecords())) == null) continue;
            return found;
        }
        return null;
    }

    public EscherRecord getEscherRecord(int index) {
        return this.escherRecords.get(index);
    }

    public void join(AbstractEscherHolderRecord record) {
        this.rawDataContainer.concatenate(record.getRawData());
    }

    public void processContinueRecord(byte[] record) {
        this.rawDataContainer.concatenate(record);
    }

    public byte[] getRawData() {
        return this.rawDataContainer.toArray();
    }

    public void setRawData(byte[] rawData) {
        this.rawDataContainer.clear();
        this.rawDataContainer.concatenate(rawData);
    }

    public void decode() {
        byte[] rawData = this.getRawData();
        this.convertToEscherRecords(0, rawData.length, rawData);
    }

    static {
        try {
            DESERIALISE = System.getProperty("poi.deserialize.escher") != null;
        }
        catch (SecurityException e) {
            DESERIALISE = false;
        }
    }
}

