/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientDataRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CommonObjectDataSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.EndSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.ObjRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFPicture;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFSimpleShape;

public class PictureShape
extends AbstractShape {
    private EscherContainerRecord spContainer;
    private ObjRecord objRecord;

    PictureShape(HSSFSimpleShape hssfShape, int shapeId) {
        this.spContainer = this.createSpContainer(hssfShape, shapeId);
        this.objRecord = this.createObjRecord(hssfShape, shapeId);
    }

    private EscherContainerRecord createSpContainer(HSSFSimpleShape hssfShape, int shapeId) {
        HSSFPicture shape = (HSSFPicture)hssfShape;
        EscherContainerRecord spContainer = new EscherContainerRecord();
        EscherSpRecord sp = new EscherSpRecord();
        EscherOptRecord opt = new EscherOptRecord();
        EscherClientDataRecord clientData = new EscherClientDataRecord();
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        sp.setRecordId((short)-4086);
        sp.setOptions((short)1202);
        sp.setShapeId(shapeId);
        sp.setFlags(2560);
        opt.setRecordId((short)-4085);
        opt.addEscherProperty(new EscherSimpleProperty(260, false, true, shape.getPictureIndex()));
        this.addStandardOptions(shape, opt);
        HSSFAnchor userAnchor = shape.getAnchor();
        if (userAnchor.isHorizontallyFlipped()) {
            sp.setFlags(sp.getFlags() | 0x40);
        }
        if (userAnchor.isVerticallyFlipped()) {
            sp.setFlags(sp.getFlags() | 0x80);
        }
        EscherRecord anchor = this.createAnchor(userAnchor);
        clientData.setRecordId((short)-4079);
        clientData.setOptions((short)0);
        spContainer.addChildRecord(sp);
        spContainer.addChildRecord(opt);
        spContainer.addChildRecord(anchor);
        spContainer.addChildRecord(clientData);
        return spContainer;
    }

    private ObjRecord createObjRecord(HSSFShape hssfShape, int shapeId) {
        HSSFShape shape = hssfShape;
        ObjRecord obj = new ObjRecord();
        CommonObjectDataSubRecord c = new CommonObjectDataSubRecord();
        c.setObjectType((short)((HSSFSimpleShape)shape).getShapeType());
        c.setObjectId(this.getCmoObjectId(shapeId));
        c.setLocked(true);
        c.setPrintable(true);
        c.setAutofill(true);
        c.setAutoline(true);
        c.setReserved2(0);
        EndSubRecord e = new EndSubRecord();
        obj.addSubRecord(c);
        obj.addSubRecord(e);
        return obj;
    }

    @Override
    public EscherContainerRecord getSpContainer() {
        return this.spContainer;
    }

    @Override
    public ObjRecord getObjRecord() {
        return this.objRecord;
    }
}

