/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.EvaluationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NumberEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.AggregateFunction;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.FinanceLib;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Function;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.NumericFunction;

public final class Npv
implements Function {
    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        int nArgs = args.length;
        if (nArgs < 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double rate = NumericFunction.singleOperandEvaluate(args[0], srcRowIndex, srcColumnIndex);
            ValueEval[] vargs = new ValueEval[args.length - 1];
            System.arraycopy(args, 1, vargs, 0, vargs.length);
            double[] values = AggregateFunction.ValueCollector.collectValues(vargs);
            double result = FinanceLib.npv(rate, values);
            NumericFunction.checkValue(result);
            return new NumberEval(result);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }
}

