/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.EvaluationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NumberEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.OperandResolver;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Fixed1ArgFunction;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Function;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.DateUtil;
import java.util.Date;
import java.util.GregorianCalendar;

public final class CalendarFieldFunction
extends Fixed1ArgFunction {
    public static final Function YEAR = new CalendarFieldFunction(1);
    public static final Function MONTH = new CalendarFieldFunction(2);
    public static final Function WEEKDAY = new CalendarFieldFunction(7);
    public static final Function DAY = new CalendarFieldFunction(5);
    public static final Function HOUR = new CalendarFieldFunction(11);
    public static final Function MINUTE = new CalendarFieldFunction(12);
    public static final Function SECOND = new CalendarFieldFunction(13);
    private final int _dateFieldId;

    private CalendarFieldFunction(int dateFieldId) {
        this._dateFieldId = dateFieldId;
    }

    @Override
    public final ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
        double val;
        try {
            ValueEval ve = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
            val = OperandResolver.coerceValueToDouble(ve);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        if (val < 0.0) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(this.getCalField(val));
    }

    private int getCalField(double serialDate) {
        if ((int)serialDate == 0) {
            switch (this._dateFieldId) {
                case 1: {
                    return 1900;
                }
                case 2: {
                    return 1;
                }
                case 5: {
                    return 0;
                }
            }
        }
        Date d = DateUtil.getJavaDate(serialDate, false);
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        int result = c.get(this._dateFieldId);
        if (this._dateFieldId == 2) {
            ++result;
        }
        return result;
    }
}

