/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.TwoDEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.BoolEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.EvaluationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.OperandResolver;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.RefEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Fixed0ArgFunction;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Fixed1ArgFunction;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Function;

public abstract class BooleanFunction
implements Function {
    public static final Function AND = new BooleanFunction(){

        @Override
        protected boolean getInitialResultValue() {
            return true;
        }

        @Override
        protected boolean partialEvaluate(boolean cumulativeResult, boolean currentValue) {
            return cumulativeResult && currentValue;
        }
    };
    public static final Function OR = new BooleanFunction(){

        @Override
        protected boolean getInitialResultValue() {
            return false;
        }

        @Override
        protected boolean partialEvaluate(boolean cumulativeResult, boolean currentValue) {
            return cumulativeResult || currentValue;
        }
    };
    public static final Function FALSE = new Fixed0ArgFunction(){

        @Override
        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex) {
            return BoolEval.FALSE;
        }
    };
    public static final Function TRUE = new Fixed0ArgFunction(){

        @Override
        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex) {
            return BoolEval.TRUE;
        }
    };
    public static final Function NOT = new Fixed1ArgFunction(){

        @Override
        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
            boolean boolArgVal;
            try {
                ValueEval ve = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
                Boolean b = OperandResolver.coerceValueToBoolean(ve, false);
                boolArgVal = b == null ? false : b;
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            return BoolEval.valueOf(!boolArgVal);
        }
    };

    @Override
    public final ValueEval evaluate(ValueEval[] args, int srcRow, int srcCol) {
        boolean boolResult;
        if (args.length < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            boolResult = this.calculate(args);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return BoolEval.valueOf(boolResult);
    }

    private boolean calculate(ValueEval[] args) throws EvaluationException {
        boolean result = this.getInitialResultValue();
        boolean atleastOneNonBlank = false;
        for (ValueEval arg : args) {
            Boolean tempVe;
            if (arg instanceof TwoDEval) {
                TwoDEval ae = (TwoDEval)arg;
                int height = ae.getHeight();
                int width = ae.getWidth();
                for (int rrIx = 0; rrIx < height; ++rrIx) {
                    for (int rcIx = 0; rcIx < width; ++rcIx) {
                        ValueEval ve = ae.getValue(rrIx, rcIx);
                        Boolean tempVe2 = OperandResolver.coerceValueToBoolean(ve, true);
                        if (tempVe2 == null) continue;
                        result = this.partialEvaluate(result, tempVe2);
                        atleastOneNonBlank = true;
                    }
                }
                continue;
            }
            if (arg instanceof RefEval) {
                ValueEval ve = ((RefEval)arg).getInnerValueEval();
                tempVe = OperandResolver.coerceValueToBoolean(ve, true);
            } else {
                tempVe = OperandResolver.coerceValueToBoolean(arg, false);
            }
            if (tempVe == null) continue;
            result = this.partialEvaluate(result, tempVe);
            atleastOneNonBlank = true;
        }
        if (!atleastOneNonBlank) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return result;
    }

    protected abstract boolean getInitialResultValue();

    protected abstract boolean partialEvaluate(boolean var1, boolean var2);
}

