/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.TwoDEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.BlankEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.BoolEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.EvaluationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NumberEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.OperandResolver;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.RefEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.StringEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Function;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.MathX;

public class Averagea
implements Function {
    private final boolean _isReferenceBoolCounted;
    private final boolean _isBlankCounted;
    static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final int DEFAULT_MAX_NUM_OPERANDS = 30;

    public Averagea() {
        this._isReferenceBoolCounted = false;
        this._isBlankCounted = false;
    }

    protected Averagea(boolean isReferenceBoolCounted, boolean isBlankCounted) {
        this._isReferenceBoolCounted = isReferenceBoolCounted;
        this._isBlankCounted = isBlankCounted;
    }

    @Override
    public final ValueEval evaluate(ValueEval[] args, int srcCellRow, int srcCellCol) {
        double d;
        try {
            double[] values = this.getNumberArray(args);
            d = this.evaluate(values);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(d);
    }

    protected double evaluate(double[] values) throws EvaluationException {
        if (values.length < 1) {
            throw new EvaluationException(ErrorEval.DIV_ZERO);
        }
        return MathX.average(values);
    }

    protected int getMaxNumOperands() {
        return 30;
    }

    protected final double[] getNumberArray(ValueEval[] operands) throws EvaluationException {
        if (operands.length > this.getMaxNumOperands()) {
            throw EvaluationException.invalidValue();
        }
        DoubleList retval = new DoubleList();
        int iSize = operands.length;
        for (int i = 0; i < iSize; ++i) {
            this.collectValues(operands[i], retval);
        }
        return retval.toArray();
    }

    public boolean isSubtotalCounted() {
        return true;
    }

    private void collectValues(ValueEval operand, DoubleList temp) throws EvaluationException {
        if (operand instanceof TwoDEval) {
            TwoDEval ae = (TwoDEval)operand;
            int width = ae.getWidth();
            int height = ae.getHeight();
            for (int rrIx = 0; rrIx < height; ++rrIx) {
                for (int rcIx = 0; rcIx < width; ++rcIx) {
                    ValueEval ve = ae.getValue(rrIx, rcIx);
                    if (!this.isSubtotalCounted() && ae.isSubTotal(rrIx, rcIx)) continue;
                    this.collectValue(ve, true, temp);
                }
            }
            return;
        }
        if (operand instanceof RefEval) {
            RefEval re = (RefEval)operand;
            this.collectValue(re.getInnerValueEval(), true, temp);
            return;
        }
        this.collectValue(operand, false, temp);
    }

    private void collectValue(ValueEval ve, boolean isViaReference, DoubleList temp) throws EvaluationException {
        if (ve == null) {
            throw new IllegalArgumentException("ve must not be null");
        }
        if (ve instanceof NumberEval) {
            NumberEval ne = (NumberEval)ve;
            temp.add(ne.getNumberValue());
            return;
        }
        if (ve instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)ve);
        }
        if (ve instanceof StringEval) {
            if (isViaReference) {
                temp.add(0.0);
                return;
            }
            String s = ((StringEval)ve).getStringValue();
            Double d = OperandResolver.parseDouble(s);
            if (d == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            temp.add(d);
            return;
        }
        if (ve instanceof BoolEval) {
            if (isViaReference || this._isReferenceBoolCounted) {
                BoolEval boolEval = (BoolEval)ve;
                temp.add(boolEval.getNumberValue());
            }
            return;
        }
        if (ve == BlankEval.instance) {
            if (this._isBlankCounted) {
                temp.add(0.0);
            }
            return;
        }
        throw new RuntimeException("Invalid ValueEval type passed for conversion: (" + ve.getClass() + ")");
    }

    private static class DoubleList {
        private double[] _array = new double[8];
        private int _count = 0;

        public double[] toArray() {
            if (this._count < 1) {
                return EMPTY_DOUBLE_ARRAY;
            }
            double[] result = new double[this._count];
            System.arraycopy(this._array, 0, result, 0, this._count);
            return result;
        }

        private void ensureCapacity(int reqSize) {
            if (reqSize > this._array.length) {
                int newSize = reqSize * 3 / 2;
                double[] newArr = new double[newSize];
                System.arraycopy(this._array, 0, newArr, 0, this._count);
                this._array = newArr;
            }
        }

        public void add(double value) {
            this.ensureCapacity(this._count + 1);
            this._array[this._count] = value;
            ++this._count;
        }
    }
}

