/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.SheetNameFormatter;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.EvaluationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.MissingArgEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.OperandResolver;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.StringEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Function;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.NumericFunction;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.CellReference;

public class Address
implements Function {
    public static final int REF_ABSOLUTE = 1;
    public static final int REF_ROW_ABSOLUTE_COLUMN_RELATIVE = 2;
    public static final int REF_ROW_RELATIVE_RELATIVE_ABSOLUTE = 3;
    public static final int REF_RELATIVE = 4;

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length < 2 || args.length > 5) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval ve;
            boolean pAbsRow;
            int row = (int)NumericFunction.singleOperandEvaluate(args[0], srcRowIndex, srcColumnIndex);
            int col = (int)NumericFunction.singleOperandEvaluate(args[1], srcRowIndex, srcColumnIndex);
            int refType = args.length > 2 ? (int)NumericFunction.singleOperandEvaluate(args[2], srcRowIndex, srcColumnIndex) : 1;
            boolean pAbsCol = switch (refType) {
                case 1 -> {
                    pAbsRow = true;
                    yield true;
                }
                case 2 -> {
                    pAbsRow = true;
                    yield false;
                }
                case 3 -> {
                    pAbsRow = false;
                    yield true;
                }
                case 4 -> {
                    pAbsRow = false;
                    yield false;
                }
                default -> throw new EvaluationException(ErrorEval.VALUE_INVALID);
            };
            if (args.length > 3) {
                ValueEval ve2 = OperandResolver.getSingleValue(args[3], srcRowIndex, srcColumnIndex);
                boolean a1 = ve2 == MissingArgEval.instance ? true : OperandResolver.coerceValueToBoolean(ve2, false);
            } else {
                boolean a1 = true;
            }
            String sheetName = args.length == 5 ? ((ve = OperandResolver.getSingleValue(args[4], srcRowIndex, srcColumnIndex)) == MissingArgEval.instance ? null : OperandResolver.coerceValueToString(ve)) : null;
            CellReference ref = new CellReference(row - 1, col - 1, pAbsRow, pAbsCol);
            StringBuffer sb = new StringBuffer(32);
            if (sheetName != null) {
                SheetNameFormatter.appendFormat(sb, sheetName);
                sb.append('!');
            }
            sb.append(ref.formatAsString());
            return new StringEval(sb.toString());
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }
}

