/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.EvaluationCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.EvaluationSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.EvaluationWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ForkedEvaluationCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.CellReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class ForkedEvaluationSheet
implements EvaluationSheet {
    private final EvaluationSheet _masterSheet;
    private final Map<RowColKey, ForkedEvaluationCell> _sharedCellsByRowCol;

    public ForkedEvaluationSheet(EvaluationSheet masterSheet) {
        this._masterSheet = masterSheet;
        this._sharedCellsByRowCol = new HashMap<RowColKey, ForkedEvaluationCell>();
    }

    @Override
    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        RowColKey key = new RowColKey(rowIndex, columnIndex);
        ForkedEvaluationCell result = this._sharedCellsByRowCol.get(key);
        if (result == null) {
            return this._masterSheet.getCell(rowIndex, columnIndex);
        }
        return result;
    }

    public ForkedEvaluationCell getOrCreateUpdatableCell(int rowIndex, int columnIndex) {
        RowColKey key = new RowColKey(rowIndex, columnIndex);
        ForkedEvaluationCell result = this._sharedCellsByRowCol.get(key);
        if (result == null) {
            EvaluationCell mcell = this._masterSheet.getCell(rowIndex, columnIndex);
            if (mcell == null) {
                CellReference cr = new CellReference(rowIndex, columnIndex);
                throw new UnsupportedOperationException("Underlying cell '" + cr.formatAsString() + "' is missing in master sheet.");
            }
            result = new ForkedEvaluationCell(this, mcell);
            this._sharedCellsByRowCol.put(key, result);
        }
        return result;
    }

    public void copyUpdatedCells(Sheet sheet) {
        Object[] keys = new RowColKey[this._sharedCellsByRowCol.size()];
        this._sharedCellsByRowCol.keySet().toArray(keys);
        Arrays.sort(keys);
    }

    public int getSheetIndex(EvaluationWorkbook mewb) {
        return mewb.getSheetIndex(this._masterSheet);
    }

    private static final class RowColKey
    implements Comparable<RowColKey> {
        private final int _rowIndex;
        private final int _columnIndex;

        public RowColKey(int rowIndex, int columnIndex) {
            this._rowIndex = rowIndex;
            this._columnIndex = columnIndex;
        }

        public boolean equals(Object obj) {
            assert (obj instanceof RowColKey) : "these private cache key instances are only compared to themselves";
            RowColKey other = (RowColKey)obj;
            return this._rowIndex == other._rowIndex && this._columnIndex == other._columnIndex;
        }

        public int hashCode() {
            return this._rowIndex ^ this._columnIndex;
        }

        @Override
        public int compareTo(RowColKey o) {
            int cmp = this._rowIndex - o._rowIndex;
            if (cmp != 0) {
                return cmp;
            }
            return this._columnIndex - o._columnIndex;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public int getColumnIndex() {
            return this._columnIndex;
        }
    }
}

