/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.CellCacheEntry;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.FormulaUsedBlankCellSet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.IEvaluationListener;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class FormulaCellCacheEntry
extends CellCacheEntry {
    private CellCacheEntry[] _sensitiveInputCells;
    private FormulaUsedBlankCellSet _usedBlankCellGroup;

    public boolean isInputSensitive() {
        if (this._sensitiveInputCells != null && this._sensitiveInputCells.length > 0) {
            return true;
        }
        return this._usedBlankCellGroup == null ? false : !this._usedBlankCellGroup.isEmpty();
    }

    public void setSensitiveInputCells(CellCacheEntry[] sensitiveInputCells) {
        this.changeConsumingCells(sensitiveInputCells == null ? CellCacheEntry.EMPTY_ARRAY : sensitiveInputCells);
        this._sensitiveInputCells = sensitiveInputCells;
    }

    public void clearFormulaEntry() {
        CellCacheEntry[] usedCells = this._sensitiveInputCells;
        if (usedCells != null) {
            for (int i = usedCells.length - 1; i >= 0; --i) {
                usedCells[i].clearConsumingCell(this);
            }
        }
        this._sensitiveInputCells = null;
        this.clearValue();
    }

    private void changeConsumingCells(CellCacheEntry[] usedCells) {
        int i;
        Set usedSet;
        CellCacheEntry[] prevUsedCells = this._sensitiveInputCells;
        int nUsed = usedCells.length;
        for (int i2 = 0; i2 < nUsed; ++i2) {
            usedCells[i2].addConsumingCell(this);
        }
        if (prevUsedCells == null) {
            return;
        }
        int nPrevUsed = prevUsedCells.length;
        if (nPrevUsed < 1) {
            return;
        }
        if (nUsed < 1) {
            usedSet = Collections.emptySet();
        } else {
            usedSet = new HashSet(nUsed * 3 / 2);
            for (i = 0; i < nUsed; ++i) {
                usedSet.add(usedCells[i]);
            }
        }
        for (i = 0; i < nPrevUsed; ++i) {
            CellCacheEntry prevUsed = prevUsedCells[i];
            if (usedSet.contains(prevUsed)) continue;
            prevUsed.clearConsumingCell(this);
        }
    }

    public void updateFormulaResult(ValueEval result, CellCacheEntry[] sensitiveInputCells, FormulaUsedBlankCellSet usedBlankAreas) {
        this.updateValue(result);
        this.setSensitiveInputCells(sensitiveInputCells);
        this._usedBlankCellGroup = usedBlankAreas;
    }

    public void notifyUpdatedBlankCell(FormulaUsedBlankCellSet.BookSheetKey bsk, int rowIndex, int columnIndex, IEvaluationListener evaluationListener) {
        if (this._usedBlankCellGroup != null && this._usedBlankCellGroup.containsCell(bsk, rowIndex, columnIndex)) {
            this.clearFormulaEntry();
            this.recurseClearCachedFormulaResults(evaluationListener);
        }
    }
}

