/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.DIB;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.EMF;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.ImagePainter;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.JPEG;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.PICT;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.PNG;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.WMF;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.HSLFException;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class PictureData {
    protected static final int CHECKSUM_SIZE = 16;
    protected byte[] rawdata;
    protected int offset;
    private String tempFilePath;
    protected static ImagePainter[] painters = new ImagePainter[8];

    public abstract int getType();

    public abstract byte[] getData();

    public abstract void setData(byte[] var1) throws IOException;

    protected abstract int getSignature();

    public byte[] getRawData() {
        return this.rawdata;
    }

    public void setRawData(byte[] data) {
        this.rawdata = data;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getUID() {
        byte[] uid = new byte[16];
        return uid;
    }

    public static byte[] getChecksum(byte[] data) {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HSLFException(e.getMessage());
        }
        sha.update(data);
        return sha.digest();
    }

    public static PictureData create(int type) {
        return switch (type) {
            case 2 -> new EMF();
            case 3 -> new WMF();
            case 4 -> new PICT();
            case 5 -> new JPEG();
            case 6 -> new PNG();
            case 7 -> new DIB();
            default -> throw new IllegalArgumentException("Unsupported picture type: " + type);
        };
    }

    public byte[] getHeader() {
        byte[] header = new byte[24];
        LittleEndian.putInt(header, 0, this.getSignature());
        return header;
    }

    public int getSize() {
        return this.getData().length;
    }

    public String getTempFilePath() {
        return this.tempFilePath;
    }

    public void setTempFilePath(String tempFilePath) {
        this.tempFilePath = tempFilePath;
    }

    public void dispose() {
        this.tempFilePath = null;
    }
}

