/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.CString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SoundData;

public final class Sound
extends RecordContainer {
    private byte[] _header = new byte[8];
    private CString _name;
    private CString _type;
    private SoundData _data;

    protected Sound(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof CString) {
            this._name = (CString)this._children[0];
        }
        if (this._children[1] instanceof CString) {
            this._type = (CString)this._children[1];
        }
        for (int i = 2; i < this._children.length; ++i) {
            if (!(this._children[i] instanceof SoundData)) continue;
            this._data = (SoundData)this._children[i];
            break;
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.Sound.typeID;
    }

    public String getSoundName() {
        return this._name.getText();
    }

    public String getSoundType() {
        return this._type.getText();
    }

    public byte[] getSoundData() {
        return this._data == null ? null : this._data.getData();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._header = null;
        if (this._name != null) {
            this._name.dispose();
            this._name = null;
        }
        if (this._type != null) {
            this._type.dispose();
            this._type = null;
        }
        if (this._data != null) {
            this._data.dispose();
            this._data = null;
        }
    }
}

