/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class HeadersFootersAtom
extends RecordAtom {
    public static final int fHasDate = 1;
    public static final int fHasTodayDate = 2;
    public static final int fHasUserDate = 4;
    public static final int fHasSlideNumber = 8;
    public static final int fHasHeader = 16;
    public static final int fHasFooter = 32;
    private byte[] _header;
    private byte[] _recdata;

    protected HeadersFootersAtom(byte[] source, int start, int len) {
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._recdata = new byte[len - 8];
        System.arraycopy(source, start + 8, this._recdata, 0, len - 8);
    }

    public HeadersFootersAtom() {
        this._recdata = new byte[4];
        this._header = new byte[8];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._recdata.length);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.HeadersFootersAtom.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._recdata);
    }

    public int getFormatId() {
        return LittleEndian.getShort(this._recdata, 0);
    }

    public void setFormatId(int formatId) {
        LittleEndian.putUShort(this._recdata, 0, formatId);
    }

    public int getMask() {
        return LittleEndian.getShort(this._recdata, 2);
    }

    public void setMask(int mask) {
        LittleEndian.putUShort(this._recdata, 2, mask);
    }

    public boolean getFlag(int bit) {
        return (this.getMask() & bit) != 0;
    }

    public void setFlag(int bit, boolean value) {
        int mask = this.getMask();
        mask = value ? (mask |= bit) : (mask &= ~bit);
        this.setMask(mask);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HeadersFootersAtom\n");
        buf.append("\tFormatId: " + this.getFormatId() + "\n");
        buf.append("\tMask    : " + this.getMask() + "\n");
        buf.append("\t  fHasDate        : " + this.getFlag(1) + "\n");
        buf.append("\t  fHasTodayDate   : " + this.getFlag(2) + "\n");
        buf.append("\t  fHasUserDate    : " + this.getFlag(4) + "\n");
        buf.append("\t  fHasSlideNumber : " + this.getFlag(8) + "\n");
        buf.append("\t  fHasHeader      : " + this.getFlag(16) + "\n");
        buf.append("\t  fHasFooter      : " + this.getFlag(32) + "\n");
        return buf.toString();
    }

    @Override
    public void dispose() {
        this._header = null;
        this._recdata = null;
    }
}

