/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.FontEntityAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogger;
import java.util.ArrayList;
import java.util.List;

public final class FontCollection
extends RecordContainer {
    private List<String> fonts;
    private byte[] _header = new byte[8];

    protected FontCollection(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.fonts = new ArrayList<String>();
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof FontEntityAtom) {
                FontEntityAtom atom = (FontEntityAtom)this._children[i];
                this.fonts.add(atom.getFontName());
                continue;
            }
            this.logger.log(POILogger.WARN, "Warning: FontCollection child wasn't a FontEntityAtom, was " + this._children[i]);
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.FontCollection.typeID;
    }

    public int addFont(String name) {
        int idx = this.getFontIndex(name);
        if (idx != -1) {
            return idx;
        }
        return this.addFont(name, 0, 0, 4, 34);
    }

    public int addFont(String name, int charset, int flags, int type, int pitch) {
        FontEntityAtom fnt = new FontEntityAtom();
        fnt.setFontIndex(this.fonts.size() << 4);
        fnt.setFontName(name);
        fnt.setCharSet(charset);
        fnt.setFontFlags(flags);
        fnt.setFontType(type);
        fnt.setPitchAndFamily(pitch);
        this.fonts.add(name);
        this.appendChildRecord(fnt);
        return this.fonts.size() - 1;
    }

    public int getFontIndex(String name) {
        for (int i = 0; i < this.fonts.size(); ++i) {
            if (!this.fonts.get(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfFonts() {
        return this.fonts.size();
    }

    public String getFontWithId(int id2) {
        if (id2 >= this.fonts.size()) {
            return null;
        }
        return this.fonts.get(id2);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._header = null;
        if (this.fonts != null) {
            this.fonts.clear();
            this.fonts = null;
        }
    }
}

