/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.CString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExMediaAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogger;

public final class ExVideoContainer
extends RecordContainer {
    private byte[] _header = new byte[8];
    private ExMediaAtom mediaAtom;
    private CString pathAtom;

    protected ExVideoContainer(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof ExMediaAtom) {
            this.mediaAtom = (ExMediaAtom)this._children[0];
        } else {
            this.logger.log(POILogger.ERROR, "First child record wasn't a ExMediaAtom, was of type " + this._children[0].getRecordType());
        }
        if (this._children[1] instanceof CString) {
            this.pathAtom = (CString)this._children[1];
        } else {
            this.logger.log(POILogger.ERROR, "Second child record wasn't a CString, was of type " + this._children[1].getRecordType());
        }
    }

    public ExVideoContainer() {
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        this._children = new Record[2];
        this.mediaAtom = new ExMediaAtom();
        this._children[0] = this.mediaAtom;
        this.pathAtom = new CString();
        this._children[1] = this.pathAtom;
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExVideoContainer.typeID;
    }

    public ExMediaAtom getExMediaAtom() {
        return this.mediaAtom;
    }

    public CString getPathAtom() {
        return this.pathAtom;
    }

    @Override
    public void dispose() {
        super.dispose();
        this._header = null;
        if (this.pathAtom != null) {
            this.pathAtom.dispose();
            this.pathAtom = null;
        }
        if (this.mediaAtom != null) {
            this.mediaAtom.dispose();
            this.mediaAtom = null;
        }
    }
}

