/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import android.graphics.Path;
import android.graphics.PointF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherArrayProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.ShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.AffineTransform;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.GeneralPath;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.PathIterator;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.Point2D;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

public final class Freeform
extends AutoShape {
    public static final byte[] SEGMENTINFO_MOVETO = new byte[]{0, 64};
    public static final byte[] SEGMENTINFO_LINETO = new byte[]{0, -84};
    public static final byte[] SEGMENTINFO_LINETO2 = new byte[]{0, -80};
    public static final byte[] SEGMENTINFO_ESCAPE = new byte[]{1, 0};
    public static final byte[] SEGMENTINFO_ESCAPE1 = new byte[]{3, 0};
    public static final byte[] SEGMENTINFO_ESCAPE2 = new byte[]{1, 32};
    public static final byte[] SEGMENTINFO_CUBICTO = new byte[]{0, -83};
    public static final byte[] SEGMENTINFO_CUBICTO1 = new byte[]{0, -81};
    public static final byte[] SEGMENTINFO_CUBICTO2 = new byte[]{0, -77};
    public static final byte[] SEGMENTINFO_CLOSE = new byte[]{1, 96};
    public static final byte[] SEGMENTINFO_END = new byte[]{0, -128};

    protected Freeform(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public Path[] getFreeformPath(Rectangle rect, PointF startArrowTailCenter, byte startArrowType, PointF endArrowTailCenter, byte endArrowType) {
        return ShapeKit.getFreeformPath(this.getSpContainer(), rect, startArrowTailCenter, startArrowType, endArrowTailCenter, endArrowType);
    }

    public Freeform(Shape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(0, parent instanceof ShapeGroup);
    }

    public Freeform() {
        this(null);
    }

    public void setPath(GeneralPath path) {
        Rectangle2D bounds = path.getBounds2D();
        PathIterator it = path.getPathIterator(new AffineTransform());
        ArrayList<byte[]> segInfo = new ArrayList<byte[]>();
        ArrayList<Point2D.Double> pntInfo = new ArrayList<Point2D.Double>();
        boolean isClosed = false;
        while (!it.isDone()) {
            double[] vals = new double[6];
            int type = it.currentSegment(vals);
            switch (type) {
                case 0: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    segInfo.add(ShapeKit.SEGMENTINFO_MOVETO);
                    break;
                }
                case 1: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    segInfo.add(ShapeKit.SEGMENTINFO_LINETO);
                    segInfo.add(ShapeKit.SEGMENTINFO_ESCAPE);
                    break;
                }
                case 3: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    pntInfo.add(new Point2D.Double(vals[2], vals[3]));
                    pntInfo.add(new Point2D.Double(vals[4], vals[5]));
                    segInfo.add(ShapeKit.SEGMENTINFO_CUBICTO);
                    segInfo.add(ShapeKit.SEGMENTINFO_ESCAPE2);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    pntInfo.add((Point2D.Double)pntInfo.get(0));
                    segInfo.add(ShapeKit.SEGMENTINFO_LINETO);
                    segInfo.add(ShapeKit.SEGMENTINFO_ESCAPE);
                    segInfo.add(ShapeKit.SEGMENTINFO_LINETO);
                    segInfo.add(ShapeKit.SEGMENTINFO_CLOSE);
                    isClosed = true;
                }
            }
            it.next();
        }
        if (!isClosed) {
            segInfo.add(ShapeKit.SEGMENTINFO_LINETO);
        }
        segInfo.add(new byte[]{0, -128});
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        opt.addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = new EscherArrayProperty(16709, false, null);
        verticesProp.setNumberOfElementsInArray(pntInfo.size());
        verticesProp.setNumberOfElementsInMemory(pntInfo.size());
        verticesProp.setSizeOfElements(65520);
        for (int i = 0; i < pntInfo.size(); ++i) {
            Point2D.Double pnt = (Point2D.Double)pntInfo.get(i);
            byte[] data = new byte[4];
            LittleEndian.putShort(data, 0, (short)((pnt.getX() - bounds.getX()) * 576.0 / 72.0));
            LittleEndian.putShort(data, 2, (short)((pnt.getY() - bounds.getY()) * 576.0 / 72.0));
            verticesProp.setElement(i, data);
        }
        opt.addEscherProperty(verticesProp);
        EscherArrayProperty segmentsProp = new EscherArrayProperty(16710, false, null);
        segmentsProp.setNumberOfElementsInArray(segInfo.size());
        segmentsProp.setNumberOfElementsInMemory(segInfo.size());
        segmentsProp.setSizeOfElements(2);
        for (int i = 0; i < segInfo.size(); ++i) {
            byte[] seg = (byte[])segInfo.get(i);
            segmentsProp.setElement(i, seg);
        }
        opt.addEscherProperty(segmentsProp);
        opt.addEscherProperty(new EscherSimpleProperty(322, (int)(bounds.getWidth() * 576.0 / 72.0)));
        opt.addEscherProperty(new EscherSimpleProperty(323, (int)(bounds.getHeight() * 576.0 / 72.0)));
        opt.sortProperties();
        this.setAnchor(bounds);
    }

    public GeneralPath getPath() {
        EscherArrayProperty segmentsProp;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        opt.addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 16709);
        if (verticesProp == null) {
            verticesProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 325);
        }
        if ((segmentsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 16710)) == null) {
            segmentsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 326);
        }
        if (verticesProp == null) {
            return null;
        }
        if (segmentsProp == null) {
            return null;
        }
        GeneralPath path = new GeneralPath();
        int numPoints = verticesProp.getNumberOfElementsInArray();
        int numSegments = segmentsProp.getNumberOfElementsInArray();
        int j = 0;
        for (int i = 0; i < numSegments && j < numPoints; ++i) {
            byte[] pnext;
            byte[] elem = segmentsProp.getElement(i);
            if (Arrays.equals(elem, ShapeKit.SEGMENTINFO_MOVETO)) {
                byte[] p = verticesProp.getElement(j++);
                short x = LittleEndian.getShort(p, 0);
                short y = LittleEndian.getShort(p, 2);
                path.moveTo((float)x * 72.0f / 576.0f, (float)y * 72.0f / 576.0f);
                continue;
            }
            if (Arrays.equals(elem, ShapeKit.SEGMENTINFO_CUBICTO) || Arrays.equals(elem, ShapeKit.SEGMENTINFO_CUBICTO2)) {
                ++i;
                byte[] p1 = verticesProp.getElement(j++);
                short x1 = LittleEndian.getShort(p1, 0);
                short y1 = LittleEndian.getShort(p1, 2);
                byte[] p2 = verticesProp.getElement(j++);
                short x2 = LittleEndian.getShort(p2, 0);
                short y2 = LittleEndian.getShort(p2, 2);
                byte[] p3 = verticesProp.getElement(j++);
                short x3 = LittleEndian.getShort(p3, 0);
                short y3 = LittleEndian.getShort(p3, 2);
                path.curveTo((float)x1 * 72.0f / 576.0f, (float)y1 * 72.0f / 576.0f, (float)x2 * 72.0f / 576.0f, (float)y2 * 72.0f / 576.0f, (float)x3 * 72.0f / 576.0f, (float)y3 * 72.0f / 576.0f);
                continue;
            }
            if (!Arrays.equals(elem, ShapeKit.SEGMENTINFO_LINETO)) continue;
            if (Arrays.equals(pnext = segmentsProp.getElement(++i), ShapeKit.SEGMENTINFO_ESCAPE)) {
                if (j + 1 >= numPoints) continue;
                byte[] p = verticesProp.getElement(j++);
                short x = LittleEndian.getShort(p, 0);
                short y = LittleEndian.getShort(p, 2);
                path.lineTo((float)x * 72.0f / 576.0f, (float)y * 72.0f / 576.0f);
                continue;
            }
            if (!Arrays.equals(pnext, ShapeKit.SEGMENTINFO_CLOSE)) continue;
            path.closePath();
        }
        return path;
    }

    @Override
    public com.ahmadullahpk.alldocumentreader.xs.java.awt.Shape getOutline() {
        GeneralPath path = this.getPath();
        Rectangle2D anchor = this.getAnchor2D();
        Rectangle2D bounds = path.getBounds2D();
        AffineTransform at = new AffineTransform();
        at.translate(anchor.getX(), anchor.getY());
        at.scale(anchor.getWidth() / bounds.getWidth(), anchor.getHeight() / bounds.getHeight());
        return at.createTransformedShape(path);
    }

    public ArrowPathAndTail getStartArrowPathAndTail(Rectangle rect) {
        return ShapeKit.getStartArrowPathAndTail(this._escherContainer, rect);
    }

    public ArrowPathAndTail getEndArrowPathAndTail(Rectangle rect) {
        return ShapeKit.getEndArrowPathAndTail(this._escherContainer, rect);
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

