/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.HSLFException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.PictureData;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public abstract class Metafile
extends PictureData {
    protected byte[] compress(byte[] bytes, int offset, int length) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream(out);
        deflater.write(bytes, offset, length);
        deflater.close();
        return out.toByteArray();
    }

    public void writeByte_WMFAndEMF(FileOutputStream out) {
        try {
            int count;
            byte[] rawdata = this.getRawData();
            ByteArrayInputStream is = new ByteArrayInputStream(rawdata);
            ((InputStream)is).skip(8L);
            Header header = new Header();
            header.read(rawdata, 16);
            ((InputStream)is).skip(header.getSize() + 16);
            InflaterInputStream inflater = new InflaterInputStream(is);
            byte[] chunk = new byte[4096];
            while ((count = inflater.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
            inflater.close();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    public static class Header {
        public int wmfsize;
        public Rectangle bounds;
        public Dimension size;
        public int zipsize;
        public int compression;
        public int filter = 254;

        public void read(byte[] data, int offset) {
            int pos = offset;
            this.wmfsize = LittleEndian.getInt(data, pos);
            int left = LittleEndian.getInt(data, pos += 4);
            int top = LittleEndian.getInt(data, pos += 4);
            int right = LittleEndian.getInt(data, pos += 4);
            int bottom = LittleEndian.getInt(data, pos += 4);
            this.bounds = new Rectangle(left, top, right - left, bottom - top);
            int width = LittleEndian.getInt(data, pos += 4);
            int height = LittleEndian.getInt(data, pos += 4);
            this.size = new Dimension(width, height);
            this.zipsize = LittleEndian.getInt(data, pos += 4);
            this.compression = LittleEndian.getUnsignedByte(data, pos += 4);
            this.filter = LittleEndian.getUnsignedByte(data, ++pos);
            ++pos;
        }

        public void write(OutputStream out) throws IOException {
            byte[] header = new byte[34];
            int pos = 0;
            LittleEndian.putInt(header, pos, this.wmfsize);
            LittleEndian.putInt(header, pos += 4, this.bounds.x);
            LittleEndian.putInt(header, pos += 4, this.bounds.y);
            LittleEndian.putInt(header, pos += 4, this.bounds.x + this.bounds.width);
            LittleEndian.putInt(header, pos += 4, this.bounds.y + this.bounds.height);
            LittleEndian.putInt(header, pos += 4, this.size.width);
            LittleEndian.putInt(header, pos += 4, this.size.height);
            LittleEndian.putInt(header, pos += 4, this.zipsize);
            header[pos += 4] = 0;
            header[++pos] = (byte)this.filter;
            ++pos;
            out.write(header);
        }

        public int getSize() {
            return 34;
        }
    }
}

