/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.Bitmap;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.IOException;

public final class DIB
extends Bitmap {
    public static final int HEADER_SIZE = 14;

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public int getSignature() {
        return 31360;
    }

    @Override
    public byte[] getData() {
        return DIB.addBMPHeader(super.getData());
    }

    public static byte[] addBMPHeader(byte[] data) {
        byte[] header = new byte[14];
        LittleEndian.putInt(header, 0, 19778);
        int imageSize = LittleEndian.getInt(data, 20);
        int fileSize = data.length + 14;
        int offset = fileSize - imageSize;
        LittleEndian.putInt(header, 2, fileSize);
        LittleEndian.putInt(header, 6, 0);
        LittleEndian.putInt(header, 10, offset);
        byte[] dib = new byte[header.length + data.length];
        System.arraycopy(header, 0, dib, 0, header.length);
        System.arraycopy(data, 0, dib, header.length, data.length);
        return dib;
    }

    @Override
    public void setData(byte[] data) throws IOException {
        byte[] dib = new byte[data.length - 14];
        System.arraycopy(data, 14, dib, 0, dib.length);
        super.setData(dib);
    }
}

