/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf;

import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.CFBFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.Property;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.Metafile;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.CorruptPowerPointFileException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.EncryptedPowerPointFileException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.CurrentUserAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExOleObjStg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PersistPtrHolder;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PersistRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.UserEditAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.ObjectData;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.PictureData;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public final class HSLFSlideShow {
    protected static final int CHECKSUM_SIZE = 16;
    private CurrentUserAtom currentUser;
    private byte[] _docstream;
    private Property _docProp;
    private Record[] _records;
    private List<PictureData> _pictures;
    private ObjectData[] _objects;
    private CFBFileSystem cfbFS;
    private IControl control;

    public HSLFSlideShow(IControl control, String fileName) throws IOException {
        boolean encrypted;
        this.control = control;
        this.cfbFS = new CFBFileSystem(new FileInputStream(fileName));
        this.readCurrentUserStream();
        this.readPowerPointStream();
        boolean bl = encrypted = this.cfbFS.getPropertyRawData("EncryptedSummary") != null;
        if (encrypted) {
            throw new EncryptedPowerPointFileException("Cannot process encrypted office files!");
        }
        this.buildRecords();
        this.readOtherStreams();
    }

    private void readPowerPointStream() throws IOException {
        this._docstream = this.cfbFS.getPropertyRawData("PowerPoint Document");
        this._docProp = this.cfbFS.getProperty("PowerPoint Document");
    }

    private void buildRecords() {
        this._records = this.read((int)this.currentUser.getCurrentEditOffset());
    }

    private Record[] read(int usrOffset) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        HashMap<Integer, Integer> offset2id = new HashMap<Integer, Integer>();
        while (usrOffset != 0) {
            byte[] data = this._docProp.getRecordData(usrOffset);
            UserEditAtom usr = (UserEditAtom)Record.buildRecordAtOffset(data, 0, usrOffset);
            lst.add(usrOffset);
            int psrOffset = usr.getPersistPointersOffset();
            data = this._docProp.getRecordData(psrOffset);
            PersistPtrHolder ptr = (PersistPtrHolder)Record.buildRecordAtOffset(data, 0, psrOffset);
            lst.add(psrOffset);
            Hashtable<Integer, Integer> entries = ptr.getSlideLocationsLookup();
            for (Integer id2 : entries.keySet()) {
                Integer offset = entries.get(id2);
                lst.add(offset);
                offset2id.put(offset, id2);
            }
            usrOffset = usr.getLastUserEditAtomOffset();
        }
        Object[] a = lst.toArray(new Integer[lst.size()]);
        Arrays.sort(a);
        Record[] rec = new Record[lst.size()];
        for (int i = 0; i < a.length; ++i) {
            Integer id2;
            Object offset = a[i];
            byte[] data = this._docProp.getRecordData((Integer)offset);
            rec[i] = Record.buildRecordAtOffset(data, 0, (Integer)offset);
            if (!(rec[i] instanceof PersistRecord)) continue;
            PersistRecord psr = (PersistRecord)((Object)rec[i]);
            id2 = (Integer)offset2id.get(offset);
            psr.setPersistId(id2);
        }
        return rec;
    }

    private void readCurrentUserStream() {
        try {
            this.currentUser = new CurrentUserAtom(this.cfbFS);
        }
        catch (IOException ie) {
            this.currentUser = new CurrentUserAtom();
        }
    }

    private void readOtherStreams() {
    }

    private void readPictures() throws IOException {
        if (this.control == null) {
            return;
        }
        Property property = this.cfbFS.getProperty("Pictures");
        if (property == null) {
            return;
        }
        this._pictures = new ArrayList<PictureData>();
        long rawDataSize = property.getPropertyRawDataSize();
        int pos = 0;
        while ((long)pos <= rawDataSize - 8L) {
            int offset = pos;
            int signature = property.getUShort(pos);
            int type = property.getUShort(pos += 2);
            int imgsize = property.getInt(pos += 2);
            pos += 4;
            if (imgsize < 0) break;
            if (type != 0) {
                try {
                    PictureData pict = PictureData.create(type - 61464);
                    pict.setOffset(offset);
                    if (pict.getType() == 5 || pict.getType() == 6 || pict.getType() == 7 || pict.getType() == 3 || pict.getType() == 2) {
                        String name = String.valueOf(System.currentTimeMillis()) + ".tmp";
                        File file = new File(this.control.getSysKit().getPictureManage().getPicTempPath() + File.separator + name);
                        try {
                            file.createNewFile();
                            FileOutputStream out = new FileOutputStream(file);
                            if (pict.getType() == 3 || pict.getType() == 2) {
                                byte[] rawdata = property.getRecordData(pict.getOffset());
                                pict.setRawData(rawdata);
                                ((Metafile)pict).writeByte_WMFAndEMF(out);
                            } else if (pict.getType() == 6) {
                                long a = property.getLong(pos + 17);
                                if (a == 727905341920923785L) {
                                    property.writeByte(out, pos + 17, imgsize - 17);
                                } else {
                                    a = property.getLong(pos + 33);
                                    if (a == 727905341920923785L) {
                                        property.writeByte(out, pos + 33, imgsize - 33);
                                    }
                                }
                            } else {
                                property.writeByte(out, pos + 17, imgsize - 17);
                            }
                            out.close();
                        }
                        catch (Exception e) {
                            this.control.getSysKit().getErrorKit().writerLog(e);
                        }
                        pict.setTempFilePath(file.getAbsolutePath());
                    }
                    this._pictures.add(pict);
                }
                catch (IllegalArgumentException e) {
                    this.control.getSysKit().getErrorKit().writerLog(e);
                }
            }
            pos += imgsize;
        }
    }

    public synchronized int appendRootLevelRecord(Record newRecord) {
        int addedAt = -1;
        Record[] r = new Record[this._records.length + 1];
        boolean added = false;
        for (int i = this._records.length - 1; i >= 0; --i) {
            if (added) {
                r[i] = this._records[i];
                continue;
            }
            r[i + 1] = this._records[i];
            if (!(this._records[i] instanceof PersistPtrHolder)) continue;
            r[i] = newRecord;
            added = true;
            addedAt = i;
        }
        this._records = r;
        return addedAt;
    }

    public int addPicture(PictureData img) {
        if (this._pictures == null) {
            try {
                this.readPictures();
            }
            catch (IOException e) {
                throw new CorruptPowerPointFileException(e.getMessage());
            }
        }
        int offset = 0;
        if (this._pictures.size() > 0) {
            PictureData prev = this._pictures.get(this._pictures.size() - 1);
            offset = prev.getOffset() + prev.getRawData().length + 8;
        }
        img.setOffset(offset);
        this._pictures.add(img);
        return offset;
    }

    public Record[] getRecords() {
        return this._records;
    }

    public byte[] getUnderlyingBytes() {
        return this._docstream;
    }

    public CurrentUserAtom getCurrentUserAtom() {
        return this.currentUser;
    }

    public PictureData[] getPictures() {
        if (this._pictures == null) {
            try {
                this.readPictures();
            }
            catch (IOException e) {
                throw new CorruptPowerPointFileException(e.getMessage());
            }
            catch (OutOfMemoryError e) {
                this.control.getSysKit().getErrorKit().writerLog(e, true);
                this.control.actionEvent(23, true);
                this.control = null;
            }
        }
        if (this._pictures != null) {
            return this._pictures.toArray(new PictureData[this._pictures.size()]);
        }
        return null;
    }

    public ObjectData[] getEmbeddedObjects() {
        if (this._objects == null) {
            ArrayList<ObjectData> objects = new ArrayList<ObjectData>();
            for (int i = 0; i < this._records.length; ++i) {
                if (!(this._records[i] instanceof ExOleObjStg)) continue;
                objects.add(new ObjectData((ExOleObjStg)this._records[i]));
            }
            this._objects = objects.toArray(new ObjectData[objects.size()]);
        }
        return this._objects;
    }

    public void dispose() {
        if (this.currentUser != null) {
            this.currentUser.dispose();
            this.currentUser = null;
        }
        if (this._records != null) {
            for (Record rec : this._records) {
                rec.dispose();
            }
            this._records = null;
        }
        if (this._pictures != null) {
            for (PictureData pd : this._pictures) {
                pd.dispose();
            }
            this._pictures.clear();
            this._pictures = null;
        }
        if (this._objects != null) {
            for (ObjectData od : this._objects) {
                od.dispose();
            }
            this._objects = null;
        }
        if (this.cfbFS != null) {
            this.cfbFS.dispose();
            this.cfbFS = null;
        }
        this.control = null;
        this._docstream = null;
    }
}

