/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage;

import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.BlockSize;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.CFBConstants;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.HexDump;
import java.io.IOException;
import java.io.InputStream;

public final class HeaderBlock {
    public static final long _signature = -2226271756974174256L;
    public static final int _bat_array_offset = 76;
    public static final int _max_bats_in_header = 109;
    public static final int _signature_offset = 0;
    public static final int _bat_count_offset = 44;
    public static final int _property_start_offset = 48;
    public static final int _sbat_start_offset = 60;
    public static final int _sbat_block_count_offset = 64;
    public static final int _xbat_start_offset = 68;
    public static final int _xbat_count_offset = 72;
    private BlockSize bigBlockSize;
    private int _bat_count;
    private int _property_start;
    private int _sbat_start;
    private int _sbat_count;
    private int _xbat_start;
    private int _xbat_count;
    private byte[] _data = new byte[512];

    public HeaderBlock(InputStream stream) throws IOException {
        stream.read(this._data);
        long signature = LittleEndian.getLong(this._data, 0);
        if (signature != -2226271756974174256L) {
            throw new IOException("Invalid header signature; read " + this.longToHex(signature) + ", expected " + this.longToHex(-2226271756974174256L));
        }
        if (this._data[30] == 12) {
            this.bigBlockSize = CFBConstants.LARGER_BIG_BLOCK_SIZE_DETAILS;
        } else if (this._data[30] == 9) {
            this.bigBlockSize = CFBConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;
        } else {
            throw new IOException("Unsupported blocksize  (2^" + this._data[30] + "). Expected 2^9 or 2^12.");
        }
        this._bat_count = LittleEndian.getInt(this._data, 44);
        this._property_start = LittleEndian.getInt(this._data, 48);
        this._sbat_start = LittleEndian.getInt(this._data, 60);
        this._sbat_count = LittleEndian.getInt(this._data, 64);
        this._xbat_start = LittleEndian.getInt(this._data, 68);
        this._xbat_count = LittleEndian.getInt(this._data, 72);
    }

    private String longToHex(long value) {
        return new String(HexDump.longToHex(value));
    }

    public int getPropertyStart() {
        return this._property_start;
    }

    public void setPropertyStart(int startBlock) {
        this._property_start = startBlock;
    }

    public int getSBATStart() {
        return this._sbat_start;
    }

    public int getSBATCount() {
        return this._sbat_count;
    }

    public void setSBATStart(int startBlock) {
        this._sbat_start = startBlock;
    }

    public void setSBATBlockCount(int count) {
        this._sbat_count = count;
    }

    public int getBATCount() {
        return this._bat_count;
    }

    public void setBATCount(int count) {
        this._bat_count = count;
    }

    public int[] getBATArray() {
        int[] result = new int[Math.min(this._bat_count, 109)];
        int offset = 76;
        for (int j = 0; j < result.length; ++j) {
            result[j] = LittleEndian.getInt(this._data, offset);
            offset += 4;
        }
        return result;
    }

    public int getXBATCount() {
        return this._xbat_count;
    }

    public int getXBATIndex() {
        return this._xbat_start;
    }

    public BlockSize getBigBlockSize() {
        return this.bigBlockSize;
    }

    public void dispose() {
        this._data = null;
        this.bigBlockSize = null;
    }
}

