/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem;

import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.RawDataBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Property {
    public static final int PROPERTY_TYPE_OFFSET = 66;
    public static final byte DIRECTORY_TYPE = 1;
    public static final byte DOCUMENT_TYPE = 2;
    public static final byte ROOT_TYPE = 5;
    private static final int NAME_SIZE_OFFSET = 64;
    private static final int PREVIOUS_PROPERTY_OFFSET = 68;
    private static final int NEXT_PROPERTY_OFFSET = 72;
    private static final int CHILD_PROPERTY_OFFSET = 76;
    protected static final int _NO_INDEX = -1;
    private static int _big_block_minimum_bytes = 4096;
    private static final int START_BLOCK_OFFSET = 116;
    private static final int SIZE_OFFSET = 120;
    protected static final byte _NODE_BLACK = 1;
    protected static final byte _NODE_RED = 0;
    private String _name;
    private short _name_size;
    private byte _property_type;
    private int _start_block;
    private int _size;
    private int _chlid_property;
    private int _next_property;
    private int _previous_property;
    private byte[] documentRawData;
    private RawDataBlock[] blocks;
    private int blockSize;
    protected Map<String, Property> properties = new HashMap<String, Property>();

    public Property(int index, byte[] array2, int offset) {
        this._name_size = LittleEndian.getShort(array2, 64 + offset);
        this._previous_property = LittleEndian.getShort(array2, 68 + offset);
        this._next_property = LittleEndian.getShort(array2, 72 + offset);
        this._chlid_property = LittleEndian.getShort(array2, 76 + offset);
        this._start_block = LittleEndian.getInt(array2, 116 + offset);
        this._size = LittleEndian.getInt(array2, 120 + offset);
        this._property_type = array2[66 + offset];
        int name_length = this._name_size / 2 - 1;
        if (name_length < 1) {
            this._name = this._property_type == 5 ? "Root Entry" : "aaa";
        } else {
            char[] char_array = new char[name_length];
            int name_offset = 0;
            for (int j = 0; j < name_length; ++j) {
                char_array[j] = (char)LittleEndian.getShort(array2, name_offset + offset);
                name_offset += 2;
            }
            this._name = new String(char_array, 0, name_length);
        }
    }

    public byte[] getDocumentRawData() {
        return this.documentRawData;
    }

    public void setDocumentRawData(byte[] rawData) {
        this.documentRawData = rawData;
    }

    public int getStartBlock() {
        return this._start_block;
    }

    public int getSize() {
        return this._size;
    }

    public int getPreviousPropertyIndex() {
        return this._previous_property;
    }

    public int getNextPropertyIndex() {
        return this._next_property;
    }

    public int getChildPropertyIndex() {
        return this._chlid_property;
    }

    public boolean shouldUseSmallBlocks() {
        return this.getSize() < _big_block_minimum_bytes;
    }

    public String getName() {
        return this._name;
    }

    public long getPropertyRawDataSize() {
        if (this.blocks != null) {
            return this.blocks[0].getData().length * this.blocks.length;
        }
        return this.documentRawData.length;
    }

    public RawDataBlock[] getBlocks() {
        return this.blocks;
    }

    public void setBlocks(RawDataBlock[] blocks) {
        this.blocks = blocks;
        this.blockSize = blocks[0].getData().length;
    }

    public boolean isDocument() {
        return this._property_type == 2;
    }

    public boolean isDirectory() {
        return this._property_type == 1;
    }

    public boolean isRoot() {
        return this._property_type == 5;
    }

    public int getUShort(int offset) {
        int b0 = this.getByteForOffset(offset);
        int b1 = this.getByteForOffset(offset + 1);
        return (b1 << 8) + (b0 << 0);
    }

    public long getUInt(int offset) {
        long retNum = this.getInt(offset);
        return retNum & 0xFFFFFFFFL;
    }

    public int getInt(int offset) {
        int b0 = this.getByteForOffset(offset);
        int b1 = this.getByteForOffset(offset + 1);
        int b2 = this.getByteForOffset(offset + 2);
        int b3 = this.getByteForOffset(offset + 3);
        return (b3 << 24) + (b2 << 16) + (b1 << 8) + (b0 << 0);
    }

    public long getLong(int offset) {
        long result = 0L;
        for (int j = offset + 8 - 1; j >= offset; --j) {
            result <<= 8;
            result |= (long)(0xFF & this.getByteForOffset(j));
        }
        return result;
    }

    public void writeByte(OutputStream out, int offset, int len) throws IOException {
        int BLOCKNUMBER = 16;
        int length = Math.min(len, this.blockSize * 16);
        byte[] data = new byte[length];
        int index = this.getBlockIndexForOffset(offset);
        int off = offset - this.blockSize * index;
        int writeLen = Math.min(len, this.blockSize - off);
        System.arraycopy(this.blocks[index].getData(), off, data, 0, writeLen);
        int blockCnt = 1;
        while (writeLen <= len && index < this.blocks.length) {
            if (blockCnt < 16) {
                ++index;
                ++blockCnt;
                if (writeLen + this.blockSize > len) {
                    if (len > writeLen && index < this.blocks.length) {
                        System.arraycopy(this.blocks[index].getData(), 0, data, writeLen, len - writeLen);
                    }
                    out.write(data, 0, len);
                    break;
                }
                System.arraycopy(this.blocks[index].getData(), 0, data, writeLen, this.blockSize);
                writeLen += this.blockSize;
                continue;
            }
            out.write(data, 0, writeLen);
            len -= writeLen;
            blockCnt = 0;
            writeLen = 0;
        }
        data = null;
    }

    private int getBlockIndexForOffset(int offset) {
        return offset / this.blockSize;
    }

    private int getByteForOffset(int offset) {
        int index = offset / this.blockSize;
        int off = offset - this.blockSize * index;
        return this.blocks[index].getData()[off] & 0xFF;
    }

    public byte[] getRecordData(int usrOffset) {
        int startIndex;
        int endIndex;
        int rlen = (int)this.getUInt(usrOffset + 4) + 8;
        if (rlen < 0) {
            rlen = 0;
        }
        if (this.documentRawData == null || this.documentRawData.length < rlen) {
            this.documentRawData = new byte[Math.max(rlen, this.blockSize)];
        }
        if ((endIndex = (usrOffset + rlen) / this.blockSize) > (startIndex = usrOffset / this.blockSize)) {
            int off = usrOffset % this.blockSize;
            System.arraycopy(this.blocks[startIndex].getData(), off, this.documentRawData, 0, this.blockSize - off);
            off = this.blockSize - off;
            if (startIndex + 1 < endIndex) {
                for (int i = startIndex + 1; i < endIndex; ++i) {
                    System.arraycopy(this.blocks[i].getData(), 0, this.documentRawData, off, this.blockSize);
                    off += this.blockSize;
                }
            }
            if (endIndex < this.blocks.length) {
                System.arraycopy(this.blocks[endIndex].getData(), 0, this.documentRawData, off, (usrOffset + rlen) % this.blockSize);
            }
        } else {
            int off = usrOffset % this.blockSize;
            System.arraycopy(this.blocks[startIndex].getData(), off, this.documentRawData, 0, rlen);
        }
        return this.documentRawData;
    }

    public void addChildProperty(Property property) {
        this.properties.put(property.getName(), property);
    }

    public Property getChlidProperty(String name) {
        return this.properties.get(name);
    }

    public void dispose() {
        this.documentRawData = null;
        this._name = null;
        this.blocks = null;
        if (this.properties != null) {
            Set<String> set = this.properties.keySet();
            for (String key : set) {
                this.properties.get(key).dispose();
            }
            this.properties.clear();
            this.properties = null;
        }
    }
}

