/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.dom4j;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Attribute;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.DocumentFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import java.util.Iterator;

public class ProxyXmlStartTag {
    private Element element;
    private DocumentFactory factory = DocumentFactory.getInstance();

    public ProxyXmlStartTag() {
    }

    public ProxyXmlStartTag(Element element) {
        this.element = element;
    }

    public void resetStartTag() {
        this.element = null;
    }

    public int getAttributeCount() {
        return this.element != null ? this.element.attributeCount() : 0;
    }

    public String getAttributeNamespaceUri(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return attribute.getNamespaceURI();
        }
        return null;
    }

    public String getAttributeLocalName(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return attribute.getName();
        }
        return null;
    }

    public String getAttributePrefix(int index) {
        String prefix;
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null && (prefix = attribute.getNamespacePrefix()) != null && prefix.length() > 0) {
            return prefix;
        }
        return null;
    }

    public String getAttributeRawName(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return attribute.getQualifiedName();
        }
        return null;
    }

    public String getAttributeValue(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return attribute.getValue();
        }
        return null;
    }

    public String getAttributeValueFromRawName(String rawName) {
        if (this.element != null) {
            Iterator iter = this.element.attributeIterator();
            while (iter.hasNext()) {
                Attribute attribute = (Attribute)iter.next();
                if (!rawName.equals(attribute.getQualifiedName())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public String getAttributeValueFromName(String namespaceURI, String localName) {
        if (this.element != null) {
            Iterator iter = this.element.attributeIterator();
            while (iter.hasNext()) {
                Attribute attribute = (Attribute)iter.next();
                if (!namespaceURI.equals(attribute.getNamespaceURI()) || !localName.equals(attribute.getName())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public boolean isAttributeNamespaceDeclaration(int index) {
        Attribute attribute;
        if (this.element != null && (attribute = this.element.attribute(index)) != null) {
            return "xmlns".equals(attribute.getNamespacePrefix());
        }
        return false;
    }

    public String getLocalName() {
        return this.element.getName();
    }

    public String getNamespaceUri() {
        return this.element.getNamespaceURI();
    }

    public String getPrefix() {
        return this.element.getNamespacePrefix();
    }

    public String getRawName() {
        return this.element.getQualifiedName();
    }

    public void modifyTag(String namespaceURI, String lName, String rawName) {
        this.element = this.factory.createElement(rawName, namespaceURI);
    }

    public void resetTag() {
        this.element = null;
    }

    public DocumentFactory getDocumentFactory() {
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public Element getElement() {
        return this.element;
    }
}

