/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.doc;

import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.Gradient;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.LinearGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.RadialGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bookmark.Bookmark;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Border;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Borders;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListData;
import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListLevel;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfoFactory;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.LineShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPGroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPPictureShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.FCKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherTextboxRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.HWPFDocument;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FieldsDocumentPart;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.ListFormatOverride;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.ListTables;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.POIListData;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.POIListLevel;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PicturesTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Bookmarks;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.BorderCode;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.CharacterRun;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Field;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HeaderStories;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.InlineWordArt;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.LineSpacingDescriptor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.OfficeDrawing;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.OfficeDrawings;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.POIBookmark;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Paragraph;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Picture;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.PictureType;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Range;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Section;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Table;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.TableCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.TableRow;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.util.Arrays;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.FontTypefaceManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ModelUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractReader;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.CellElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.HFElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.RowElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.TableElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.WPDocument;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DOCReader
extends AbstractReader {
    private boolean isBreakChar;
    private long offset;
    private long textboxIndex;
    private long docRealOffset;
    private String filePath;
    private WPDocument wpdoc;
    private HWPFDocument poiDoc;
    private Pattern hyperlinkPattern = Pattern.compile("[ \\t\\r\\n]*HYPERLINK \"(.*)\"[ \\t\\r\\n]*");
    private String hyperlinkAddress;
    private List<Bookmark> bms = new ArrayList<Bookmark>();

    public DOCReader(IControl control, String filePath) {
        this.control = control;
        this.filePath = filePath;
    }

    @Override
    public Object getModel() throws Exception {
        if (this.wpdoc != null) {
            return this.wpdoc;
        }
        this.wpdoc = new WPDocument();
        this.processDoc();
        return this.wpdoc;
    }

    private void processDoc() throws Exception {
        this.poiDoc = new HWPFDocument(new FileInputStream(new File(this.filePath)));
        this.processBulletNumber();
        this.processBookmark();
        this.offset = 0L;
        this.docRealOffset = 0L;
        Range range = this.poiDoc.getRange();
        int numSection = range.numSections();
        for (int i = 0; i < numSection && !this.abortReader; ++i) {
            String s;
            IElement elem;
            this.processSection(range.getSection(i));
            if (!this.isBreakChar || (elem = this.wpdoc.getLeaf(this.offset - 1L)) == null || !(elem instanceof LeafElement) || (s = elem.getText(this.wpdoc)) == null || s.length() != 1 || s.charAt(0) != '\f') continue;
            ((LeafElement)elem).setText(String.valueOf('\n'));
        }
        this.processHeaderFooter();
    }

    private void processBookmark() {
        Bookmarks bks = this.poiDoc.getBookmarks();
        if (bks != null) {
            for (int i = 0; i < bks.getBookmarksCount(); ++i) {
                POIBookmark poiBM = bks.getBookmark(i);
                Bookmark bm = new Bookmark(poiBM.getName(), poiBM.getStart(), poiBM.getEnd());
                this.control.getSysKit().getBookmarkManage().addBookmark(bm);
                this.bms.add(bm);
            }
        }
    }

    private void processBulletNumber() {
        ListTables listTables = this.poiDoc.getListTables();
        if (listTables == null) {
            return;
        }
        int size = listTables.getOverrideCount();
        for (int i = 0; i < size; ++i) {
            ListData listData = new ListData();
            POIListData poiData = listTables.getListData(listTables.getOverride(i + 1).getLsid());
            if (poiData == null) continue;
            listData.setListID(poiData.getLsid());
            POIListLevel[] levels = poiData.getLevels();
            int len = levels.length;
            ListLevel[] listLevels = new ListLevel[len];
            for (int j = 0; j < len; ++j) {
                listLevels[j] = new ListLevel();
                this.processListLevel(levels[j], listLevels[j]);
            }
            listData.setLevels(listLevels);
            listData.setSimpleList((byte)len);
            this.control.getSysKit().getListManage().putListData(listData.getListID(), listData);
        }
    }

    private void processListLevel(POIListLevel level, ListLevel listLevel) {
        listLevel.setStartAt(level.getStartAt());
        listLevel.setAlign((byte)level.getAlignment());
        listLevel.setFollowChar(level.getTypeOfCharFollowingTheNumber());
        listLevel.setNumberFormat(level.getNumberFormat());
        listLevel.setNumberText(this.converterNumberChar(level.getNumberChar()));
        listLevel.setSpecialIndent(level.getSpecialIndnet());
        listLevel.setTextIndent(level.getTextIndent());
    }

    private char[] converterNumberChar(char[] numChar) {
        if (numChar == null) {
            return null;
        }
        for (int i = 0; i < numChar.length; ++i) {
            if (numChar[i] == '\uf06c') {
                numChar[i] = 9679;
                continue;
            }
            if (numChar[i] == '\uf06e') {
                numChar[i] = 9632;
                continue;
            }
            if (numChar[i] == '\uf075') {
                numChar[i] = 9670;
                continue;
            }
            if (numChar[i] == '\uf0fc') {
                numChar[i] = 8730;
                continue;
            }
            if (numChar[i] == '\uf0d8') {
                numChar[i] = 9733;
                continue;
            }
            if (numChar[i] == '\uf0b2') {
                numChar[i] = 9734;
                continue;
            }
            if (numChar[i] < '\uf060') continue;
            numChar[i] = 9679;
        }
        return numChar;
    }

    private void processSection(Section section) {
        SectionElement secElem = new SectionElement();
        IAttributeSet attr = secElem.getAttribute();
        AttrManage.instance().setPageWidth(attr, section.getPageWidth());
        AttrManage.instance().setPageHeight(attr, section.getPageHeight());
        AttrManage.instance().setPageMarginLeft(attr, section.getMarginLeft());
        AttrManage.instance().setPageMarginRight(attr, section.getMarginRight());
        AttrManage.instance().setPageMarginTop(attr, section.getMarginTop());
        AttrManage.instance().setPageMarginBottom(attr, section.getMarginBottom());
        AttrManage.instance().setPageHeaderMargin(attr, section.getMarginHeader());
        AttrManage.instance().setPageFooterMargin(attr, section.getMarginFooter());
        if (section.getGridType() != 0) {
            AttrManage.instance().setPageLinePitch(attr, section.getLinePitch());
        }
        this.processSectionBorder(secElem, section);
        secElem.setStartOffset(this.offset);
        int paraCount = section.numParagraphs();
        for (int i = 0; i < paraCount && !this.abortReader; ++i) {
            Paragraph para = section.getParagraph(i);
            if (para.isInTable()) {
                Table table = section.getTable(para);
                this.processTable(table);
                i += table.numParagraphs() - 1;
                continue;
            }
            this.processParagraph(section.getParagraph(i));
        }
        secElem.setEndOffset(this.offset);
        this.wpdoc.appendSection(secElem);
    }

    private void processSectionBorder(SectionElement secElem, Section section) {
        BorderCode top = section.getTopBorder();
        BorderCode bottom = section.getBottomBorder();
        BorderCode left = section.getLeftBorder();
        BorderCode right = section.getRightBorder();
        if (top != null || bottom != null || left != null || right != null) {
            Border border;
            byte pageBorderInfo = (byte)section.getPageBorderInfo();
            byte offsetFrom = (byte)(pageBorderInfo >> 5 & 7);
            Borders borders = new Borders();
            borders.setOnType(offsetFrom);
            if (top != null) {
                border = new Border();
                border.setColor(top.getColor() == 0 ? -16777216 : this.converterColorForIndex(top.getColor()));
                border.setSpace((short)((float)top.getSpace() * 1.3333334f));
                borders.setTopBorder(border);
            }
            if (bottom != null) {
                border = new Border();
                border.setColor(bottom.getColor() == 0 ? -16777216 : this.converterColorForIndex(bottom.getColor()));
                border.setSpace((short)((float)bottom.getSpace() * 1.3333334f));
                borders.setBottomBorder(border);
            }
            if (left != null) {
                border = new Border();
                border.setColor(left.getColor() == 0 ? -16777216 : this.converterColorForIndex(left.getColor()));
                border.setSpace((short)((float)left.getSpace() * 1.3333334f));
                borders.setLeftBorder(border);
            }
            if (right != null) {
                border = new Border();
                border.setColor(right.getColor() == 0 ? -16777216 : this.converterColorForIndex(right.getColor()));
                border.setSpace((short)((float)right.getSpace() * 1.3333334f));
                borders.setRightBorder(border);
            }
            AttrManage.instance().setPageBorder(secElem.getAttribute(), this.control.getSysKit().getBordersManage().addBorders(borders));
        }
    }

    private void processHeaderFooter() {
        HeaderStories hs = new HeaderStories(this.poiDoc);
        this.offset = 0x1000000000000000L;
        this.docRealOffset = 0x1000000000000000L;
        Range range = hs.getOddHeaderSubrange();
        if (range != null) {
            this.processHeaderFooterPara(range, (short)5, (byte)1);
        }
        this.offset = 0x2000000000000000L;
        this.docRealOffset = 0x2000000000000000L;
        range = hs.getOddFooterSubrange();
        if (range != null) {
            this.processHeaderFooterPara(range, (short)6, (byte)1);
        }
    }

    private void processHeaderFooterPara(Range range, short elemType, byte hfType) {
        HFElement elem = new HFElement(elemType, hfType);
        elem.setStartOffset(this.offset);
        int paraCount = range.numParagraphs();
        for (int i = 0; i < paraCount && !this.abortReader; ++i) {
            Paragraph para = range.getParagraph(i);
            if (para.isInTable()) {
                Table table = range.getTable(para);
                this.processTable(table);
                i += table.numParagraphs() - 1;
                continue;
            }
            this.processParagraph(para);
        }
        elem.setEndOffset(this.offset);
        this.wpdoc.appendElement(elem, this.offset);
    }

    private void processTable(Table table) {
        TableElement tableElem = new TableElement();
        tableElem.setStartOffset(this.offset);
        Vector<Integer> dxs = new Vector<Integer>();
        int rowNum = table.numRows();
        for (int i = 0; i < rowNum; ++i) {
            TableRow tableRow = table.getRow(i);
            if (i == 0) {
                this.processTableAttribute(tableRow, tableElem.getAttribute());
            }
            RowElement rowElem = new RowElement();
            rowElem.setStartOffset(this.offset);
            this.processRowAttribute(tableRow, rowElem.getAttribute());
            int numCell = tableRow.numCells();
            int dx = 0;
            for (int j = 0; j < numCell; ++j) {
                TableCell cell = tableRow.getCell(j);
                cell.isBackward();
                CellElement cellElem = new CellElement();
                cellElem.setStartOffset(this.offset);
                this.processCellAttribute(cell, cellElem.getAttribute());
                int numPara = cell.numParagraphs();
                for (int k = 0; k < numPara; ++k) {
                    this.processParagraph(cell.getParagraph(k));
                }
                cellElem.setEndOffset(this.offset);
                if (this.offset > cellElem.getStartOffset()) {
                    rowElem.appendCell(cellElem);
                }
                if (dxs.contains(dx += cell.getWidth())) continue;
                dxs.add(dx);
            }
            rowElem.setEndOffset(this.offset);
            if (this.offset <= rowElem.getStartOffset()) continue;
            tableElem.appendRow(rowElem);
        }
        tableElem.setEndOffset(this.offset);
        if (this.offset > tableElem.getStartOffset()) {
            this.wpdoc.appendParagraph(tableElem, this.offset);
            int size = dxs.size();
            int[] maxDx = new int[size];
            for (int i = 0; i < size; ++i) {
                maxDx[i] = (Integer)dxs.get(i);
            }
            Arrays.sort(maxDx);
            int rowIndex = 0;
            RowElement row = (RowElement)tableElem.getElementForIndex(rowIndex++);
            while (row != null) {
                int cellIndex = 0;
                IElement cell = row.getElementForIndex(cellIndex);
                int i = 0;
                int dx = 0;
                while (cell != null) {
                    dx += AttrManage.instance().getTableCellWidth(cell.getAttribute());
                    while (i < size) {
                        if (dx > maxDx[i]) {
                            row.insertElementForIndex(new CellElement(), cellIndex + 1);
                            ++cellIndex;
                        } else {
                            ++i;
                            break;
                        }
                        ++i;
                    }
                    cell = row.getElementForIndex(++cellIndex);
                }
                row = (RowElement)tableElem.getElementForIndex(rowIndex++);
            }
        }
    }

    private void processTableAttribute(TableRow row, IAttributeSet attr) {
        if (row.getRowJustification() != 0) {
            AttrManage.instance().setParaHorizontalAlign(attr, row.getRowJustification());
        }
        if (row.getTableIndent() != 0) {
            AttrManage.instance().setParaIndentLeft(attr, row.getTableIndent());
        }
    }

    private void processRowAttribute(TableRow row, IAttributeSet attr) {
        if (row.getRowHeight() != 0) {
            AttrManage.instance().setTableRowHeight(attr, row.getRowHeight());
        }
        if (row.isTableHeader()) {
            AttrManage.instance().setTableHeaderRow(attr, true);
        }
        if (row.cantSplit()) {
            AttrManage.instance().setTableRowSplit(attr, true);
        }
    }

    private void processCellAttribute(TableCell cell, IAttributeSet attr) {
        if (cell.isFirstMerged()) {
            AttrManage.instance().setTableHorFirstMerged(attr, true);
        }
        if (cell.isMerged()) {
            AttrManage.instance().setTableHorMerged(attr, true);
        }
        if (cell.isFirstVerticallyMerged()) {
            AttrManage.instance().setTableVerFirstMerged(attr, true);
        }
        if (cell.isVerticallyMerged()) {
            AttrManage.instance().setTableVerMerged(attr, true);
        }
        AttrManage.instance().setTableCellVerAlign(attr, cell.getVertAlign());
        AttrManage.instance().setTableCellWidth(attr, cell.getWidth());
    }

    private void processParagraph(Paragraph para) {
        ListTables listTables;
        ParagraphElement paraElem = new ParagraphElement();
        IAttributeSet attr = paraElem.getAttribute();
        AttrManage.instance().setParaBefore(attr, para.getSpacingBefore());
        AttrManage.instance().setParaAfter(attr, para.getSpacingAfter());
        AttrManage.instance().setParaIndentLeft(attr, para.getIndentFromLeft());
        AttrManage.instance().setParaIndentRight(attr, para.getIndentFromRight());
        AttrManage.instance().setParaHorizontalAlign(attr, this.converterParaHorAlign(para.getJustification()));
        AttrManage.instance().setParaVerticalAlign(attr, para.getFontAlignment());
        this.converterSpecialIndent(attr, para.getFirstLineIndent());
        this.converterLineSpace(para.getLineSpacing(), attr);
        if (para.getIlfo() > 0 && (listTables = this.poiDoc.getListTables()) != null) {
            ListFormatOverride listFormatOverride = listTables.getOverride(para.getIlfo());
            if (listFormatOverride != null) {
                AttrManage.instance().setParaListID(attr, listFormatOverride.getLsid());
            }
            AttrManage.instance().setParaListLevel(attr, para.getIlvl());
        }
        if (para.isInTable()) {
            AttrManage.instance().setParaLevel(attr, para.getTableLevel());
        }
        paraElem.setStartOffset(this.offset);
        int runCount = para.numCharacterRuns();
        boolean isFieldCode = false;
        boolean isFieldText = false;
        Field field = null;
        CharacterRun run = null;
        String fieldCode = "";
        String fieldText = "";
        long before = this.docRealOffset;
        for (int i = 0; i < runCount && !this.abortReader; ++i) {
            CharacterRun preRun = run;
            run = para.getCharacterRun(i);
            String text = run.text();
            if (text.length() == 0 || run.isMarkedDeleted()) continue;
            this.docRealOffset += (long)text.length();
            char ch = text.charAt(0);
            char lastch = text.charAt(text.length() - 1);
            if (ch == '\t' && text.length() == 1 || ch == '\u0005') continue;
            if (ch == '\u0013' || lastch == '\u0013') {
                FieldsDocumentPart fieldsPart;
                if (ch == '\u0015' && lastch == '\u0013') continue;
                long area = this.offset & 0xF000000000000000L;
                fieldsPart = area == 0x1000000000000000L || area == 0x2000000000000000L ? (fieldsPart = FieldsDocumentPart.HEADER) : FieldsDocumentPart.MAIN;
                field = this.poiDoc.getFields().getFieldByStartOffset(fieldsPart, run.getStartOffset());
                isFieldCode = true;
                continue;
            }
            if (ch == '\u0014' || lastch == '\u0014') {
                isFieldCode = false;
                isFieldText = true;
                continue;
            }
            if (ch == '\u0015' || lastch == '\u0015') {
                if (preRun != null && fieldText != null && field != null && field.getType() == 58) {
                    if (fieldText.indexOf("EQ") >= 0 && fieldText.indexOf("jc") >= 0) {
                        this.processRun(preRun, para, field, paraElem, fieldCode, fieldText);
                    } else {
                        if (lastch == '\u0015') {
                            fieldText = fieldText + text.substring(0, text.length() - 1);
                        }
                        this.processRun(run, para, field, paraElem, fieldCode, fieldText);
                    }
                } else if (this.isPageNumber(field, fieldCode)) {
                    this.processRun(run, para, field, paraElem, fieldCode, fieldText);
                }
                isFieldText = false;
                isFieldCode = false;
                field = null;
                this.hyperlinkAddress = null;
                fieldCode = "";
                fieldText = "";
                continue;
            }
            if (isFieldCode) {
                fieldCode = fieldCode + run.text();
                continue;
            }
            if (isFieldText && this.isPageNumber(field, fieldCode)) {
                fieldText = fieldText + run.text();
                continue;
            }
            this.processRun(run, para, field, paraElem, null, null);
        }
        if (para.getTabClearPosition() > 0) {
            AttrManage.instance().setParaTabsClearPostion(attr, para.getTabClearPosition());
        }
        if (this.offset == paraElem.getStartOffset()) {
            paraElem.dispose();
            paraElem = null;
            return;
        }
        paraElem.setEndOffset(this.offset);
        this.wpdoc.appendParagraph(paraElem, this.offset);
        this.adjustBookmarkOffset(before, this.docRealOffset);
    }

    private boolean isPageNumber(Field field, String fieldCode) {
        if (field != null && (field.getType() == 33 || field.getType() == 26)) {
            return true;
        }
        return fieldCode != null && (fieldCode.contains("NUMPAGES") || fieldCode.contains("PAGE"));
    }

    private void converterSpecialIndent(IAttributeSet attr, int firstLintIndent) {
        AttrManage.instance().setParaSpecialIndent(attr, firstLintIndent);
        if (firstLintIndent < 0) {
            AttrManage.instance().setParaIndentLeft(attr, AttrManage.instance().getParaIndentLeft(attr) + firstLintIndent);
        }
    }

    private void converterLineSpace(LineSpacingDescriptor sd, IAttributeSet attr) {
        int lineSpaceType = 0;
        float lineSpaceValue = 1.0f;
        if (sd.getMultiLinespace() == 1) {
            float t = (float)sd.getDyaLine() / 240.0f;
            if (t == 1.0f) {
                lineSpaceType = 0;
                lineSpaceValue = 1.0f;
            } else if ((double)t == 1.5) {
                lineSpaceType = 1;
                lineSpaceValue = 1.5f;
            } else if (t == 2.0f) {
                lineSpaceType = 2;
                lineSpaceValue = 2.0f;
            } else {
                lineSpaceType = 2;
                lineSpaceValue = t;
            }
        } else {
            float t = sd.getDyaLine();
            if (t >= 0.0f) {
                lineSpaceType = 3;
                lineSpaceValue = t;
            } else {
                lineSpaceType = 4;
                lineSpaceValue = -t;
            }
        }
        AttrManage.instance().setParaLineSpace(attr, lineSpaceValue);
        AttrManage.instance().setParaLineSpaceType(attr, lineSpaceType);
    }

    private byte converterParaHorAlign(int js) {
        switch (js) {
            case 0: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                return 0;
            }
            case 1: 
            case 5: {
                return 1;
            }
            case 2: 
            case 8: {
                return 2;
            }
        }
        return 0;
    }

    private void processRun(CharacterRun run, Range parentRange, Field field, ParagraphElement paraElem, String fieldCode, String fieldText) {
        String text = run.text();
        if (fieldText != null) {
            text = fieldText;
        }
        if (text != null && text.length() > 0) {
            char ch = text.charAt(0);
            boolean bl = this.isBreakChar = ch == '\f';
            if (ch == '\b' || ch == '\u0001') {
                for (int i = 0; i < text.length() && !run.isVanished(); ++i) {
                    ch = text.charAt(i);
                    if (ch != '\b' && ch != '\u0001') continue;
                    LeafElement leaf = new LeafElement(String.valueOf(ch));
                    if (!this.processShape(run, leaf, ch == '\b', i)) {
                        return;
                    }
                    leaf.setStartOffset(this.offset);
                    ++this.offset;
                    leaf.setEndOffset(this.offset);
                    paraElem.appendLeaf(leaf);
                }
                return;
            }
        }
        LeafElement leaf = new LeafElement(text);
        IAttributeSet attr = leaf.getAttribute();
        AttrManage.instance().setFontSize(attr, (int)((double)((float)run.getFontSize() / 2.0f) + 0.5));
        int index = FontTypefaceManage.instance().addFontName(run.getFontName());
        if (index >= 0) {
            AttrManage.instance().setFontName(attr, index);
        }
        AttrManage.instance().setFontColor(attr, FCKit.BGRtoRGB(run.getIco24()));
        AttrManage.instance().setFontBold(attr, run.isBold());
        AttrManage.instance().setFontItalic(attr, run.isItalic());
        AttrManage.instance().setFontStrike(attr, run.isStrikeThrough());
        AttrManage.instance().setFontDoubleStrike(attr, run.isDoubleStrikeThrough());
        AttrManage.instance().setFontUnderline(attr, run.getUnderlineCode());
        AttrManage.instance().setFontUnderlineColr(attr, FCKit.BGRtoRGB(run.getUnderlineColor()));
        AttrManage.instance().setFontScript(attr, run.getSubSuperScriptIndex());
        AttrManage.instance().setFontHighLight(attr, this.converterColorForIndex(run.getHighlightedColor()));
        if (field != null && field.getType() == 88) {
            String formula;
            Matcher matcher;
            Range firstSubrange;
            if (this.hyperlinkAddress == null && (firstSubrange = field.firstSubrange(parentRange)) != null && (matcher = this.hyperlinkPattern.matcher(formula = firstSubrange.text())).find()) {
                this.hyperlinkAddress = matcher.group(1);
            }
            if (this.hyperlinkAddress != null && (index = this.control.getSysKit().getHyperlinkManage().addHyperlink(this.hyperlinkAddress, 1)) >= 0) {
                AttrManage.instance().setFontColor(attr, -16776961);
                AttrManage.instance().setFontUnderline(attr, 1);
                AttrManage.instance().setFontUnderlineColr(attr, -16776961);
                AttrManage.instance().setHyperlinkID(attr, index);
            }
        } else if (fieldCode != null) {
            if (fieldCode.indexOf("HYPERLINK") > 0) {
                int endIndex;
                index = fieldCode.indexOf("_Toc");
                if (index > 0 && (endIndex = fieldCode.lastIndexOf(34)) > 0 && endIndex > index) {
                    String bmName = fieldCode.substring(index, endIndex);
                    index = this.control.getSysKit().getHyperlinkManage().addHyperlink(bmName, 5);
                    if (index >= 0) {
                        AttrManage.instance().setFontColor(attr, -16776961);
                        AttrManage.instance().setFontUnderline(attr, 1);
                        AttrManage.instance().setFontUnderlineColr(attr, -16776961);
                        AttrManage.instance().setHyperlinkID(attr, index);
                    }
                }
            } else {
                long area = this.offset & 0xF000000000000000L;
                if (area == 0x1000000000000000L || area == 0x2000000000000000L) {
                    int pageNumberType = -1;
                    if (fieldCode != null) {
                        if (fieldCode.contains("NUMPAGES")) {
                            pageNumberType = 2;
                        } else if (fieldCode.contains("PAGE")) {
                            pageNumberType = 1;
                        }
                    }
                    if (pageNumberType > 0) {
                        AttrManage.instance().setFontPageNumberType(leaf.getAttribute(), pageNumberType);
                    }
                }
            }
        }
        leaf.setStartOffset(this.offset);
        this.offset += (long)text.length();
        leaf.setEndOffset(this.offset);
        paraElem.appendLeaf(leaf);
    }

    private int converterColorForIndex(short color2) {
        switch (color2) {
            case 1: {
                return -16777216;
            }
            case 2: {
                return -16776961;
            }
            case 3: {
                return -16711681;
            }
            case 4: {
                return -16711936;
            }
            case 5: {
                return -65281;
            }
            case 6: {
                return -65536;
            }
            case 7: {
                return -256;
            }
            case 8: {
                return -1;
            }
            case 9: {
                return -16776961;
            }
            case 10: {
                return -12303292;
            }
            case 11: {
                return -16711936;
            }
            case 12: {
                return -65281;
            }
            case 13: {
                return -65536;
            }
            case 14: {
                return -256;
            }
            case 15: {
                return -7829368;
            }
            case 16: {
                return -3355444;
            }
        }
        return -1;
    }

    private BackgroundAndFill converFill(HWPFAutoShape shape, OfficeDrawing drawing, int shapeType) {
        if (shapeType == 20 || shapeType == 32 || shapeType == 33 || shapeType == 34 || shapeType == 38) {
            return null;
        }
        BackgroundAndFill bgFill = null;
        if (shape != null) {
            int type = shape.getFillType();
            if (type == 0 || type == 9) {
                if (shape.getForegroundColor() != null) {
                    bgFill = new BackgroundAndFill();
                    bgFill.setFillType((byte)0);
                    bgFill.setForegroundColor(shape.getForegroundColor().getRGB());
                }
            } else if (type == 7 || type == 4 || type == 5 || type == 6) {
                bgFill = new BackgroundAndFill();
                int angle = shape.getFillAngle();
                switch (angle) {
                    case -90: 
                    case 0: {
                        angle += 90;
                        break;
                    }
                    case -45: {
                        angle = 135;
                        break;
                    }
                    case -135: {
                        angle = 45;
                    }
                }
                int focus = shape.getFillFocus();
                Color fillColor = shape.getForegroundColor();
                Color fillbackColor = shape.getFillbackColor();
                int[] colors = null;
                float[] positions = null;
                if (shape.isShaderPreset()) {
                    colors = shape.getShaderColors();
                    positions = shape.getShaderPositions();
                }
                if (colors == null) {
                    colors = new int[]{fillColor == null ? -1 : fillColor.getRGB(), fillbackColor == null ? -1 : fillbackColor.getRGB()};
                }
                if (positions == null) {
                    positions = new float[]{0.0f, 1.0f};
                }
                Gradient gradient = null;
                if (type == 7) {
                    gradient = new LinearGradientShader(angle, colors, positions);
                } else if (type == 4 || type == 5 || type == 6) {
                    gradient = new RadialGradientShader(shape.getRadialGradientPositionType(), colors, positions);
                }
                if (gradient != null) {
                    gradient.setFocus(focus);
                }
                bgFill.setFillType((byte)type);
                bgFill.setShader(gradient);
            } else if (type == 2) {
                byte[] data = drawing.getPictureData(this.control, shape.getBackgroundPictureIdx());
                if (data != null && this.isSupportPicture(PictureType.findMatchingType(data))) {
                    bgFill = new BackgroundAndFill();
                    bgFill.setFillType((byte)2);
                    int index = this.control.getSysKit().getPictureManage().getPictureIndex(drawing.getTempFilePath(this.control));
                    if (index < 0) {
                        com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture picture = new com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture();
                        picture.setTempFilePath(drawing.getTempFilePath(this.control));
                        picture.setPictureType(PictureType.findMatchingType(data).getExtension());
                        index = this.control.getSysKit().getPictureManage().addPicture(picture);
                        bgFill.setShader(new TileShader(this.control.getSysKit().getPictureManage().getPicture(index), 0, 1.0f, 1.0f));
                    }
                }
            } else if (type == 3) {
                byte[] data = drawing.getPictureData(this.control, shape.getBackgroundPictureIdx());
                if (data != null && this.isSupportPicture(PictureType.findMatchingType(data))) {
                    bgFill = new BackgroundAndFill();
                    bgFill.setFillType((byte)3);
                    int index = this.control.getSysKit().getPictureManage().getPictureIndex(drawing.getTempFilePath(this.control));
                    if (index < 0) {
                        com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture picture = new com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture();
                        picture.setTempFilePath(drawing.getTempFilePath(this.control));
                        picture.setPictureType(PictureType.findMatchingType(data).getExtension());
                        index = this.control.getSysKit().getPictureManage().addPicture(picture);
                    }
                    bgFill.setPictureIndex(index);
                }
            } else if (type == 1 && shape.getFillbackColor() != null) {
                bgFill = new BackgroundAndFill();
                bgFill.setFillType((byte)0);
                bgFill.setForegroundColor(shape.getFillbackColor().getRGB());
            }
        }
        return bgFill;
    }

    private void processRotation(HWPFAutoShape shape, IShape autoShape) {
        float angle = shape.getRotation();
        if (shape.getFlipHorizontal()) {
            autoShape.setFlipHorizontal(true);
            angle = -angle;
        }
        if (shape.getFlipVertical()) {
            autoShape.setFlipVertical(true);
            angle = -angle;
        }
        if (!(!(autoShape instanceof LineShape) || angle != 45.0f && angle != 135.0f && angle != 225.0f || autoShape.getFlipHorizontal() || autoShape.getFlipVertical())) {
            angle -= 90.0f;
        }
        autoShape.setRotation(angle);
    }

    private Rectangle processGrpSpRect(GroupShape parent, Rectangle rect) {
        if (parent != null) {
            rect.x += parent.getOffX();
            rect.y += parent.getOffY();
        }
        return rect;
    }

    private void processAutoshapePosition(HWPFAutoShape shape, WPAutoShape autoShape) {
        switch (shape.getPosition_H()) {
            case 0: {
                autoShape.setHorPositionType((byte)0);
                break;
            }
            case 1: {
                autoShape.setHorizontalAlignment((byte)1);
                break;
            }
            case 2: {
                autoShape.setHorizontalAlignment((byte)2);
                break;
            }
            case 3: {
                autoShape.setHorizontalAlignment((byte)3);
                break;
            }
            case 4: {
                autoShape.setHorizontalAlignment((byte)6);
                break;
            }
            case 5: {
                autoShape.setHorizontalAlignment((byte)7);
            }
        }
        switch (shape.getPositionRelTo_H()) {
            case 0: {
                autoShape.setHorizontalRelativeTo((byte)1);
                break;
            }
            case 1: {
                autoShape.setHorizontalRelativeTo((byte)2);
                break;
            }
            case 2: {
                autoShape.setHorizontalRelativeTo((byte)0);
                break;
            }
            case 3: {
                autoShape.setHorizontalRelativeTo((byte)3);
            }
        }
        switch (shape.getPosition_V()) {
            case 0: {
                autoShape.setVerPositionType((byte)0);
                break;
            }
            case 1: {
                autoShape.setVerticalAlignment((byte)4);
                break;
            }
            case 2: {
                autoShape.setVerticalAlignment((byte)2);
                break;
            }
            case 3: {
                autoShape.setVerticalAlignment((byte)5);
                break;
            }
            case 4: {
                autoShape.setVerticalAlignment((byte)6);
                break;
            }
            case 5: {
                autoShape.setVerticalAlignment((byte)7);
            }
        }
        switch (shape.getPositionRelTo_V()) {
            case 0: {
                autoShape.setVerticalRelativeTo((byte)1);
                break;
            }
            case 1: {
                autoShape.setVerticalRelativeTo((byte)2);
                break;
            }
            case 2: {
                autoShape.setVerticalRelativeTo((byte)10);
                break;
            }
            case 3: {
                autoShape.setVerticalRelativeTo((byte)11);
            }
        }
    }

    private byte[] getPictureframeData(OfficeDrawing darwing, HWPFShape poiShape) {
        EscherOptRecord escherOptRecord = (EscherOptRecord)poiShape.getSpContainer().getChildById((short)-4085);
        if (escherOptRecord == null) {
            return null;
        }
        EscherSimpleProperty escherProperty = (EscherSimpleProperty)escherOptRecord.lookup(260);
        if (escherProperty == null) {
            return null;
        }
        int bitmapIndex = escherProperty.getPropertyValue();
        return darwing.getPictureData(this.control, bitmapIndex);
    }

    private boolean convertShape(IElement leaf, OfficeDrawing drawing, GroupShape parent, HWPFShape poiShape, Rectangle rect, float zoomX, float zoomY) {
        if (rect == null) {
            return false;
        }
        if (poiShape instanceof HWPFAutoShape) {
            HWPFAutoShape shape = (HWPFAutoShape)poiShape;
            int shapeType = shape.getShapeType();
            BackgroundAndFill fill = this.converFill(shape, drawing, shapeType);
            Line line = poiShape.getLine(shapeType == 20);
            if (line != null || fill != null || shapeType == 202 || shapeType == 75) {
                rect = this.processGrpSpRect(parent, rect);
                WPAutoShape autoShape = null;
                autoShape = shapeType == 75 ? new WPPictureShape() : new WPAutoShape();
                autoShape.setShapeType(shapeType);
                autoShape.setAuotShape07(false);
                float angle = Math.abs(shape.getRotation());
                autoShape.setBounds(ModelUtil.processRect(rect, angle));
                autoShape.setBackgroundAndFill(fill);
                if (line != null) {
                    autoShape.setLine(line);
                }
                Float[] adj = shape.getAdjustmentValue();
                autoShape.setAdjustData(adj);
                this.processRotation(shape, autoShape);
                this.processAutoshapePosition(shape, autoShape);
                boolean isLineShape = false;
                if (shapeType == 75) {
                    byte[] b = this.getPictureframeData(drawing, shape);
                    if (b != null && this.isSupportPicture(PictureType.findMatchingType(b))) {
                        PictureShape picShape = new PictureShape();
                        int index = this.control.getSysKit().getPictureManage().getPictureIndex(drawing.getTempFilePath(this.control));
                        if (index < 0) {
                            com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture picture = new com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture();
                            picture.setTempFilePath(drawing.getTempFilePath(this.control));
                            picture.setPictureType(PictureType.findMatchingType(b).getExtension());
                            index = this.control.getSysKit().getPictureManage().addPicture(picture);
                        }
                        picShape.setPictureIndex(index);
                        picShape.setBounds(rect);
                        picShape.setZoomX((short)1000);
                        picShape.setZoomY((short)1000);
                        picShape.setPictureEffectInfor(drawing.getPictureEffectInfor());
                        ((WPPictureShape)autoShape).setPictureShape(picShape);
                    }
                } else if (shapeType == 20 || shapeType == 32 || shapeType == 33 || shapeType == 34 || shapeType == 38) {
                    int type;
                    isLineShape = true;
                    if (autoShape.getShapeType() == 33 && adj == null) {
                        autoShape.setAdjustData(new Float[]{Float.valueOf(1.0f)});
                    }
                    if ((type = shape.getStartArrowType()) > 0) {
                        autoShape.createStartArrow((byte)type, shape.getStartArrowWidth(), shape.getStartArrowLength());
                    }
                    if ((type = shape.getEndArrowType()) > 0) {
                        autoShape.createEndArrow((byte)type, shape.getEndArrowWidth(), shape.getEndArrowLength());
                    }
                } else if (shapeType == 0 || shapeType == 100) {
                    ArrowPathAndTail arrowPathAndTail;
                    int endArrowType;
                    ArrowPathAndTail arrowPathAndTail2;
                    isLineShape = true;
                    autoShape.setShapeType(233);
                    PointF startArrowTailCenter = null;
                    PointF endArrowTailCenter = null;
                    int startArrowType = shape.getStartArrowType();
                    if (startArrowType > 0 && (arrowPathAndTail2 = shape.getStartArrowPath(rect)) != null && arrowPathAndTail2.getArrowPath() != null) {
                        startArrowTailCenter = arrowPathAndTail2.getArrowTailCenter();
                        ExtendPath pathExtend = new ExtendPath();
                        pathExtend.setPath(arrowPathAndTail2.getArrowPath());
                        pathExtend.setArrowFlag(true);
                        if (startArrowType != 5) {
                            if ((line == null || line.getBackgroundAndFill() == null) && poiShape.getLineColor() != null) {
                                BackgroundAndFill arrowFill = new BackgroundAndFill();
                                arrowFill.setFillType((byte)0);
                                arrowFill.setForegroundColor(poiShape.getLineColor().getRGB());
                                pathExtend.setBackgroundAndFill(arrowFill);
                            } else {
                                pathExtend.setBackgroundAndFill(line.getBackgroundAndFill());
                            }
                        } else {
                            pathExtend.setLine(line);
                        }
                        autoShape.appendPath(pathExtend);
                    }
                    if ((endArrowType = shape.getEndArrowType()) > 0 && (arrowPathAndTail = shape.getEndArrowPath(rect)) != null && arrowPathAndTail.getArrowPath() != null) {
                        endArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                        ExtendPath pathExtend = new ExtendPath();
                        pathExtend.setPath(arrowPathAndTail.getArrowPath());
                        pathExtend.setArrowFlag(true);
                        if (endArrowType != 5) {
                            if ((line == null || line.getBackgroundAndFill() == null) && poiShape.getLineColor() != null) {
                                BackgroundAndFill arrowFill = new BackgroundAndFill();
                                arrowFill.setFillType((byte)0);
                                arrowFill.setForegroundColor(poiShape.getLineColor().getRGB());
                                pathExtend.setBackgroundAndFill(arrowFill);
                            } else {
                                pathExtend.setBackgroundAndFill(line.getBackgroundAndFill());
                            }
                        } else {
                            pathExtend.setLine(line);
                        }
                        autoShape.appendPath(pathExtend);
                    }
                    Path[] paths = shape.getFreeformPath(rect, startArrowTailCenter, (byte)startArrowType, endArrowTailCenter, (byte)endArrowType);
                    for (int i = 0; i < paths.length; ++i) {
                        ExtendPath pathExtend = new ExtendPath();
                        pathExtend.setPath(paths[i]);
                        if (line != null) {
                            pathExtend.setLine(line);
                        }
                        if (fill != null) {
                            pathExtend.setBackgroundAndFill(fill);
                        }
                        autoShape.appendPath(pathExtend);
                    }
                } else {
                    this.processTextbox(shape.getSpContainer(), autoShape, this.poiDoc.getMainTextboxRange().getSection(0));
                }
                if (parent == null) {
                    if (drawing.getWrap() == 3 && !drawing.isAnchorLock()) {
                        if (drawing.isBelowText()) {
                            autoShape.setWrap((short)6);
                        } else {
                            autoShape.setWrap((short)3);
                            fill = autoShape.getBackgroundAndFill();
                        }
                    } else {
                        autoShape.setWrap((short)2);
                    }
                    AttrManage.instance().setShapeID(leaf.getAttribute(), this.control.getSysKit().getWPShapeManage().addShape(autoShape));
                    return true;
                }
                parent.appendShapes(autoShape);
                return false;
            }
        } else if (poiShape instanceof HWPFShapeGroup) {
            HWPFShapeGroup poiGroup = (HWPFShapeGroup)poiShape;
            AbstractShape shape = null;
            WPGroupShape groupShape = new WPGroupShape();
            if (parent == null) {
                shape = new WPAutoShape();
                ((WPAutoShape)shape).addGroupShape(groupShape);
            } else {
                shape = groupShape;
            }
            float[] zoom = poiGroup.getShapeAnchorFit(rect, zoomX, zoomY);
            rect = this.processGrpSpRect(parent, rect);
            Rectangle childRect = poiGroup.getCoordinates(zoom[0] * zoomX, zoom[1] * zoomY);
            groupShape.setOffPostion(rect.x - childRect.x, rect.y - childRect.y);
            groupShape.setBounds(rect);
            groupShape.setParent(parent);
            groupShape.setRotation(poiGroup.getGroupRotation());
            groupShape.setFlipHorizontal(poiGroup.getFlipHorizontal());
            groupShape.setFlipVertical(poiGroup.getFlipVertical());
            HWPFShape[] shapes = poiGroup.getShapes();
            if (shapes != null) {
                for (int i = 0; i < shapes.length; ++i) {
                    this.convertShape(leaf, drawing, groupShape, shapes[i], shapes[i].getAnchor(rect, zoom[0] * zoomX, zoom[1] * zoomY), zoom[0] * zoomX, zoom[1] * zoomY);
                }
            }
            if (parent == null) {
                if (drawing.getWrap() == 3 && !drawing.isAnchorLock()) {
                    ((WPAutoShape)shape).setWrap((short)3);
                } else {
                    ((WPAutoShape)shape).setWrap((short)2);
                }
                AttrManage.instance().setShapeID(leaf.getAttribute(), this.control.getSysKit().getWPShapeManage().addShape(shape));
            } else {
                shape.setParent(parent);
                parent.appendShapes(shape);
            }
            return true;
        }
        return false;
    }

    private short getTextboxId(EscherContainerRecord escherContainer) {
        byte[] data;
        EscherTextboxRecord escherTextboxRecord = (EscherTextboxRecord)escherContainer.getChildById((short)-4083);
        if (escherTextboxRecord != null && (data = escherTextboxRecord.getData()) != null && data.length == 4) {
            return LittleEndian.getShort(data, 2);
        }
        return -1;
    }

    private void processTextbox(EscherContainerRecord escherContainer, WPAutoShape autoShape, Section section) {
        if (section == null) {
            return;
        }
        int txbx = this.getTextboxId(escherContainer) - 1;
        if (txbx >= 0) {
            this.processSimpleTextBox(escherContainer, autoShape, section);
        } else {
            this.processWordArtTextbox(escherContainer, autoShape);
        }
    }

    private void processSimpleTextBox(EscherContainerRecord escherContainer, WPAutoShape autoShape, Section section) {
        int txbx = this.getTextboxId(escherContainer) - 1;
        int startCP = this.poiDoc.getTextboxStart(txbx);
        int endCP = this.poiDoc.getTextboxEnd(txbx);
        long oldOffset = this.offset;
        this.offset = 0x5000000000000000L + (this.textboxIndex << 32);
        autoShape.setElementIndex((int)this.textboxIndex);
        SectionElement textboxElement = new SectionElement();
        textboxElement.setStartOffset(this.offset);
        this.wpdoc.appendElement(textboxElement, this.offset);
        IAttributeSet attr = textboxElement.getAttribute();
        AttrManage.instance().setPageWidth(attr, (int)((float)autoShape.getBounds().width * 15.0f));
        AttrManage.instance().setPageHeight(attr, (int)((float)autoShape.getBounds().height * 15.0f));
        if (section.getGridType() != 0) {
            AttrManage.instance().setPageLinePitch(attr, section.getLinePitch());
        }
        AttrManage.instance().setPageMarginTop(attr, (int)(ShapeKit.getTextboxMarginTop(escherContainer) * 15.0f));
        AttrManage.instance().setPageMarginBottom(attr, (int)(ShapeKit.getTextboxMarginBottom(escherContainer) * 15.0f));
        AttrManage.instance().setPageMarginLeft(attr, (int)(ShapeKit.getTextboxMarginLeft(escherContainer) * 15.0f));
        AttrManage.instance().setPageMarginRight(attr, (int)(ShapeKit.getTextboxMarginRight(escherContainer) * 15.0f));
        AttrManage.instance().setPageVerticalAlign(attr, (byte)0);
        autoShape.setTextWrapLine(ShapeKit.isTextboxWrapLine(escherContainer));
        textboxElement.setStartOffset(this.offset);
        int paraCount = section.numParagraphs();
        int charOffset = 0;
        for (int i = 0; i < paraCount && !this.abortReader; ++i) {
            Paragraph para = section.getParagraph(i);
            if ((charOffset += para.text().length()) <= startCP || charOffset > endCP) continue;
            if (para.isInTable()) {
                Table table = section.getTable(para);
                this.processTable(table);
                i += table.numParagraphs() - 1;
                continue;
            }
            this.processParagraph(section.getParagraph(i));
        }
        autoShape.setElementIndex((int)this.textboxIndex);
        textboxElement.setEndOffset(this.offset);
        ++this.textboxIndex;
        this.offset = oldOffset;
    }

    private void processWordArtTextbox(EscherContainerRecord escherContainer, WPAutoShape autoShape) {
        String text = ShapeKit.getUnicodeGeoText(escherContainer);
        if (text != null && text.length() > 0) {
            long oldOffset = this.offset;
            this.offset = 0x5000000000000000L + (this.textboxIndex << 32);
            autoShape.setElementIndex((int)this.textboxIndex);
            SectionElement textboxElement = new SectionElement();
            textboxElement.setStartOffset(this.offset);
            this.wpdoc.appendElement(textboxElement, this.offset);
            IAttributeSet attr = textboxElement.getAttribute();
            AttrManage.instance().setPageWidth(attr, (int)((float)autoShape.getBounds().width * 15.0f));
            AttrManage.instance().setPageHeight(attr, (int)((float)autoShape.getBounds().height * 15.0f));
            AttrManage.instance().setPageMarginTop(attr, (int)(ShapeKit.getTextboxMarginTop(escherContainer) * 15.0f));
            AttrManage.instance().setPageMarginBottom(attr, (int)(ShapeKit.getTextboxMarginBottom(escherContainer) * 15.0f));
            AttrManage.instance().setPageMarginLeft(attr, (int)(ShapeKit.getTextboxMarginLeft(escherContainer) * 15.0f));
            AttrManage.instance().setPageMarginRight(attr, (int)(ShapeKit.getTextboxMarginRight(escherContainer) * 15.0f));
            AttrManage.instance().setPageVerticalAlign(attr, (byte)0);
            autoShape.setTextWrapLine(ShapeKit.isTextboxWrapLine(escherContainer));
            int width = (int)((float)autoShape.getBounds().width - ShapeKit.getTextboxMarginLeft(escherContainer) - ShapeKit.getTextboxMarginRight(escherContainer));
            int height = (int)((float)autoShape.getBounds().height - ShapeKit.getTextboxMarginTop(escherContainer) - ShapeKit.getTextboxMarginBottom(escherContainer));
            int fontsize = 12;
            Paint paint = PaintKit.instance().getPaint();
            paint.setTextSize((float)fontsize);
            Paint.FontMetrics fm = paint.getFontMetrics();
            while ((int)paint.measureText(text) < width && (int)Math.ceil(fm.descent - fm.ascent) < height) {
                paint.setTextSize((float)(++fontsize));
                fm = paint.getFontMetrics();
            }
            textboxElement.setStartOffset(this.offset);
            ParagraphElement paraElem = new ParagraphElement();
            paraElem.setStartOffset(this.offset);
            long before = this.docRealOffset;
            LeafElement leaf = new LeafElement(text);
            IAttributeSet leafAttr = leaf.getAttribute();
            AttrManage.instance().setFontSize(leafAttr, (int)((float)(fontsize - 1) * 0.75f));
            Color color2 = ShapeKit.getForegroundColor(escherContainer, null, 2);
            if (color2 != null) {
                AttrManage.instance().setFontColor(leafAttr, color2.getRGB());
            }
            leaf.setStartOffset(this.offset);
            this.offset += (long)text.length();
            leaf.setEndOffset(this.offset);
            paraElem.appendLeaf(leaf);
            paraElem.setEndOffset(this.offset);
            this.wpdoc.appendParagraph(paraElem, this.offset);
            this.adjustBookmarkOffset(before, this.docRealOffset);
            autoShape.setElementIndex((int)this.textboxIndex);
            textboxElement.setEndOffset(this.offset);
            ++this.textboxIndex;
            this.offset = oldOffset;
        }
    }

    private void processPicturePosition(OfficeDrawing drawing, WPAutoShape autoShape) {
        switch (drawing.getHorizontalPositioning()) {
            case 0: {
                autoShape.setHorPositionType((byte)0);
                break;
            }
            case 1: {
                autoShape.setHorizontalAlignment((byte)1);
                break;
            }
            case 2: {
                autoShape.setHorizontalAlignment((byte)2);
                break;
            }
            case 3: {
                autoShape.setHorizontalAlignment((byte)3);
                break;
            }
            case 4: {
                autoShape.setHorizontalAlignment((byte)6);
                break;
            }
            case 5: {
                autoShape.setHorizontalAlignment((byte)7);
            }
        }
        switch (drawing.getHorizontalRelative()) {
            case 0: {
                autoShape.setHorizontalRelativeTo((byte)1);
                break;
            }
            case 1: {
                autoShape.setHorizontalRelativeTo((byte)2);
                break;
            }
            case 2: {
                autoShape.setHorizontalRelativeTo((byte)0);
                break;
            }
            case 3: {
                autoShape.setHorizontalRelativeTo((byte)3);
            }
        }
        switch (drawing.getVerticalPositioning()) {
            case 0: {
                autoShape.setVerPositionType((byte)0);
                break;
            }
            case 1: {
                autoShape.setVerticalAlignment((byte)4);
                break;
            }
            case 2: {
                autoShape.setVerticalAlignment((byte)2);
                break;
            }
            case 3: {
                autoShape.setVerticalAlignment((byte)5);
                break;
            }
            case 4: {
                autoShape.setVerticalAlignment((byte)6);
                break;
            }
            case 5: {
                autoShape.setVerticalAlignment((byte)7);
            }
        }
        switch (drawing.getVerticalRelativeElement()) {
            case 0: {
                autoShape.setVerticalRelativeTo((byte)1);
                break;
            }
            case 1: {
                autoShape.setVerticalRelativeTo((byte)2);
                break;
            }
            case 2: {
                autoShape.setVerticalRelativeTo((byte)10);
                break;
            }
            case 3: {
                autoShape.setVerticalRelativeTo((byte)11);
            }
        }
    }

    private boolean processShape(CharacterRun run, IElement leaf, boolean isWrap, int runIndex) {
        if (isWrap) {
            OfficeDrawings drawings = this.poiDoc.getOfficeDrawingsMain();
            OfficeDrawing drawing = drawings.getOfficeDrawingAt(run.getStartOffset() + runIndex);
            if (drawing == null) {
                return false;
            }
            Rectangle rect = new Rectangle();
            rect.x = (int)((float)drawing.getRectangleLeft() * 0.06666667f);
            rect.y = (int)((float)drawing.getRectangleTop() * 0.06666667f);
            rect.width = (int)((float)(drawing.getRectangleRight() - drawing.getRectangleLeft()) * 0.06666667f);
            rect.height = (int)((float)(drawing.getRectangleBottom() - drawing.getRectangleTop()) * 0.06666667f);
            byte[] b = drawing.getPictureData(this.control);
            if (b != null) {
                if (this.isSupportPicture(PictureType.findMatchingType(b))) {
                    PictureShape picShape = new PictureShape();
                    int index = this.control.getSysKit().getPictureManage().getPictureIndex(drawing.getTempFilePath(this.control));
                    if (index < 0) {
                        com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture picture = new com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture();
                        picture.setTempFilePath(drawing.getTempFilePath(this.control));
                        picture.setPictureType(PictureType.findMatchingType(b).getExtension());
                        index = this.control.getSysKit().getPictureManage().addPicture(picture);
                    }
                    picShape.setPictureIndex(index);
                    picShape.setBounds(rect);
                    picShape.setZoomX((short)1000);
                    picShape.setZoomY((short)1000);
                    picShape.setPictureEffectInfor(drawing.getPictureEffectInfor());
                    WPPictureShape wpPictureShape = new WPPictureShape();
                    wpPictureShape.setPictureShape(picShape);
                    if (drawing.getWrap() == 3 && !drawing.isAnchorLock()) {
                        if (drawing.isBelowText()) {
                            wpPictureShape.setWrap((short)6);
                        } else {
                            wpPictureShape.setWrap((short)3);
                        }
                        this.processPicturePosition(drawing, wpPictureShape);
                    } else {
                        wpPictureShape.setWrap((short)2);
                    }
                    AttrManage.instance().setShapeID(leaf.getAttribute(), this.control.getSysKit().getWPShapeManage().addShape(wpPictureShape));
                    return true;
                }
            } else {
                HWPFShape poiShape = drawing.getAutoShape();
                if (poiShape != null) {
                    return this.convertShape(leaf, drawing, null, poiShape, rect, 1.0f, 1.0f);
                }
            }
        } else {
            PicturesTable pictureTable = this.poiDoc.getPicturesTable();
            Picture pic = pictureTable.extractPicture(this.control.getSysKit().getPictureManage().getPicTempPath(), run, false);
            if (pic != null && this.isSupportPicture(pic.suggestPictureType())) {
                PictureShape picShape = new PictureShape();
                int index = this.control.getSysKit().getPictureManage().getPictureIndex(pic.getTempFilePath());
                if (index < 0) {
                    com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture picture = new com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture();
                    picture.setTempFilePath(pic.getTempFilePath());
                    picture.setPictureType(pic.suggestPictureType().getExtension());
                    index = this.control.getSysKit().getPictureManage().addPicture(picture);
                }
                picShape.setPictureIndex(index);
                Rectangle rect = new Rectangle();
                rect.width = (int)((float)pic.getDxaGoal() * 0.06666667f * (float)pic.getHorizontalScalingFactor() / 1000.0f);
                rect.height = (int)((float)pic.getDyaGoal() * 0.06666667f * (float)pic.getVerticalScalingFactor() / 1000.0f);
                picShape.setBounds(rect);
                picShape.setZoomX(pic.getZoomX());
                picShape.setZoomY(pic.getZoomY());
                picShape.setPictureEffectInfor(PictureEffectInfoFactory.getPictureEffectInfor(pic));
                WPPictureShape wpPictureShape = new WPPictureShape();
                wpPictureShape.setPictureShape(picShape);
                wpPictureShape.setWrap((short)2);
                AttrManage.instance().setShapeID(leaf.getAttribute(), this.control.getSysKit().getWPShapeManage().addShape(wpPictureShape));
                return true;
            }
            InlineWordArt inlineShape = pictureTable.extracInlineWordArt(run);
            if (inlineShape != null && inlineShape.getInlineWordArt() != null) {
                WPAutoShape autoShape = new WPAutoShape();
                Rectangle rect = new Rectangle();
                rect.width = (int)((float)inlineShape.getDxaGoal() * 0.06666667f * (float)inlineShape.getHorizontalScalingFactor() / 1000.0f);
                rect.height = (int)((float)inlineShape.getDyaGoal() * 0.06666667f * (float)inlineShape.getVerticalScalingFactor() / 1000.0f);
                autoShape.setBounds(rect);
                autoShape.setWrap((short)2);
                this.processWordArtTextbox(inlineShape.getInlineWordArt().getSpContainer(), autoShape);
                AttrManage.instance().setShapeID(leaf.getAttribute(), this.control.getSysKit().getWPShapeManage().addShape(autoShape));
                return true;
            }
        }
        return false;
    }

    private boolean isSupportPicture(PictureType picType) {
        String mineType = picType.getExtension();
        return mineType.equalsIgnoreCase("gif") || mineType.equalsIgnoreCase("jpeg") || mineType.equalsIgnoreCase("jpg") || mineType.equalsIgnoreCase("bmp") || mineType.equalsIgnoreCase("png") || mineType.equalsIgnoreCase("wmf") || mineType.equalsIgnoreCase("emf");
    }

    @Override
    public boolean searchContent(File file, String key) throws Exception {
        boolean isContain = false;
        HWPFDocument poiDoc = new HWPFDocument(new FileInputStream(file));
        Range range = poiDoc.getRange();
        StringBuilder sb = new StringBuilder();
        block0: for (int i = 0; i < range.numSections(); ++i) {
            Section section = range.getSection(i);
            for (int j = 0; j < section.numParagraphs(); ++j) {
                Paragraph para = section.getParagraph(j);
                for (int k = 0; k < para.numCharacterRuns(); ++k) {
                    sb.append(para.getCharacterRun(k).text());
                }
                if (sb.indexOf(key) >= 0) {
                    isContain = true;
                    continue block0;
                }
                sb.delete(0, sb.length());
            }
        }
        return isContain;
    }

    private void adjustBookmarkOffset(long before, long after) {
        for (Bookmark bm : this.bms) {
            if (bm.getStart() < before || bm.getStart() > after) continue;
            bm.setStart(this.offset);
        }
    }

    @Override
    public void dispose() {
        if (this.isReaderFinish()) {
            this.wpdoc = null;
            this.filePath = null;
            this.poiDoc = null;
            this.control = null;
            this.hyperlinkAddress = null;
            if (this.bms != null) {
                this.bms.clear();
                this.bms = null;
            }
        }
    }
}

