/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ddf;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBSERecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBinaryTagRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBitmapBlip;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBlipRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherChildAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientDataRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherDgRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherDggRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherMetafileBlip;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpgrRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSplitMenuColorsRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherTertiaryOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherTextboxRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.UnknownEscherRecord;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static Class<?>[] escherRecordClasses = new Class[]{EscherBSERecord.class, EscherOptRecord.class, EscherTertiaryOptRecord.class, EscherClientAnchorRecord.class, EscherDgRecord.class, EscherSpgrRecord.class, EscherSpRecord.class, EscherClientDataRecord.class, EscherDggRecord.class, EscherSplitMenuColorsRecord.class, EscherChildAnchorRecord.class, EscherTextboxRecord.class, EscherBinaryTagRecord.class};
    private static Map<Short, Constructor<? extends EscherRecord>> recordsMap = DefaultEscherRecordFactory.recordsToMap(escherRecordClasses);

    @Override
    public EscherRecord createRecord(byte[] data, int offset) {
        EscherRecord.EscherRecordHeader header = EscherRecord.EscherRecordHeader.readHeader(data, offset);
        if ((header.getOptions() & 0xF) == 15 && header.getRecordId() != -4083) {
            EscherContainerRecord r = new EscherContainerRecord();
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        if (header.getRecordId() >= -4072 && header.getRecordId() <= -3817) {
            EscherBlipRecord r = header.getRecordId() == -4065 || header.getRecordId() == -4067 || header.getRecordId() == -4066 ? new EscherBitmapBlip() : (header.getRecordId() == -4070 || header.getRecordId() == -4069 || header.getRecordId() == -4068 ? new EscherMetafileBlip() : new EscherBlipRecord());
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        Constructor<? extends EscherRecord> recordConstructor = recordsMap.get(header.getRecordId());
        EscherRecord escherRecord = null;
        if (recordConstructor == null) {
            return new UnknownEscherRecord();
        }
        try {
            escherRecord = recordConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return new UnknownEscherRecord();
        }
        escherRecord.setRecordId(header.getRecordId());
        escherRecord.setOptions(header.getOptions());
        return escherRecord;
    }

    private static Map<Short, Constructor<? extends EscherRecord>> recordsToMap(Class<?>[] recClasses) {
        HashMap<Short, Constructor<? extends EscherRecord>> result = new HashMap<Short, Constructor<? extends EscherRecord>>();
        Class[] EMPTY_CLASS_ARRAY = new Class[]{};
        for (int i = 0; i < recClasses.length; ++i) {
            Constructor<?> constructor;
            short sid;
            Class<?> recCls = recClasses[i];
            try {
                sid = recCls.getField("RECORD_ID").getShort(null);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            try {
                constructor = recCls.getConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            result.put(sid, constructor);
        }
        return result;
    }
}

