/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ddf;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherPropertyFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSerializationListener;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.HexDump;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractEscherOptRecord
extends EscherRecord {
    protected List<EscherProperty> properties = new ArrayList<EscherProperty>();

    public void addEscherProperty(EscherProperty prop) {
        this.properties.add(prop);
    }

    @Override
    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int pos = offset + 8;
        EscherPropertyFactory f = new EscherPropertyFactory();
        this.properties = f.createProperties(data, pos, this.getInstance());
        return bytesRemaining + 8;
    }

    public List<EscherProperty> getEscherProperties() {
        return this.properties;
    }

    public EscherProperty getEscherProperty(int index) {
        return this.properties.get(index);
    }

    private int getPropertiesSize() {
        int totalSize = 0;
        for (EscherProperty property : this.properties) {
            totalSize += property.getPropertySize();
        }
        return totalSize;
    }

    @Override
    public int getRecordSize() {
        return 8 + this.getPropertiesSize();
    }

    public <T extends EscherProperty> T lookup(int propId) {
        for (EscherProperty prop : this.properties) {
            if (prop.getPropertyNumber() != propId) continue;
            EscherProperty result = prop;
            return (T)result;
        }
        return null;
    }

    @Override
    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        LittleEndian.putInt(data, offset + 4, this.getPropertiesSize());
        int pos = offset + 8;
        for (EscherProperty property : this.properties) {
            pos += property.serializeSimplePart(data, pos);
        }
        for (EscherProperty property : this.properties) {
            pos += property.serializeComplexPart(data, pos);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public void sortProperties() {
        Collections.sort(this.properties, new Comparator<EscherProperty>(){

            @Override
            public int compare(EscherProperty p1, EscherProperty p2) {
                short s2;
                short s1 = p1.getPropertyNumber();
                return s1 < (s2 = p2.getPropertyNumber()) ? -1 : (s1 == s2 ? 0 : 1);
            }
        });
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(":");
        stringBuilder.append(nl);
        stringBuilder.append("  isContainer: ");
        stringBuilder.append(this.isContainerRecord());
        stringBuilder.append(nl);
        stringBuilder.append("  options: 0x");
        stringBuilder.append(HexDump.toHex(this.getOptions()));
        stringBuilder.append(nl);
        stringBuilder.append("  recordId: 0x");
        stringBuilder.append(HexDump.toHex(this.getRecordId()));
        stringBuilder.append(nl);
        stringBuilder.append("  numchildren: ");
        stringBuilder.append(this.getChildRecords().size());
        stringBuilder.append(nl);
        stringBuilder.append("  properties:");
        stringBuilder.append(nl);
        for (EscherProperty property : this.properties) {
            stringBuilder.append("    " + property.toString() + nl);
        }
        return stringBuilder.toString();
    }
}

