/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.picture;

import android.graphics.Bitmap;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureConverterMgr;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.PictureData;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.InflaterInputStream;

public class PictureManage {
    private final int CACHE_SIZE = 0x800000;
    private String picTempPath;
    private Map<String, Integer> picIndexs;
    private List<Picture> pictures;
    private IControl control;
    private static int bitmapTotalCacheSize;
    private static Map<String, Bitmap> bitmaps;
    private PictureConverterMgr picConverterMgr;

    public PictureManage(IControl control) {
        this.control = control;
        this.pictures = new ArrayList<Picture>();
        this.picIndexs = new HashMap<String, Integer>();
        File file = control.getMainFrame().getTemporaryDirectory();
        if (file == null) {
            control.getSysKit().getErrorKit().writerLog(new Throwable("SD Card Error"));
        } else {
            this.picTempPath = file.getAbsolutePath() + File.separator + "tempPic";
            file = new File(this.picTempPath);
            if (!file.exists()) {
                file.mkdir();
            }
            this.picTempPath = file.getAbsolutePath() + File.separator + System.currentTimeMillis();
            file = new File(this.picTempPath);
            if (!file.exists()) {
                file.mkdir();
            }
        }
    }

    public int addPicture(PackagePart picPart) throws Exception {
        String key = picPart.getPartName().getName();
        Integer index = this.picIndexs.get(key);
        if (index == null) {
            Picture picture = new Picture();
            picture.setTempFilePath(this.writeTempFile(picPart));
            picture.setPictureType(picPart.getPartName().getExtension());
            int size = this.pictures.size();
            this.pictures.add(picture);
            this.picIndexs.put(key, size);
            return size;
        }
        return index;
    }

    public int addPicture(PictureData pData) {
        Integer index = this.picIndexs.get(pData.getTempFilePath());
        if (index == null) {
            Picture picture = new Picture();
            picture.setTempFilePath(pData.getTempFilePath());
            picture.setPictureType((byte)pData.getType());
            int size = this.pictures.size();
            this.pictures.add(picture);
            this.picIndexs.put(pData.getTempFilePath(), size);
            return size;
        }
        return index;
    }

    public int addPicture(Picture picture) {
        if (picture.getTempFilePath() == null) {
            picture.setTempFilePath(this.writeTempFile(picture.getData()));
            picture.setData(null);
        } else {
            int index = this.getPictureIndex(picture.getTempFilePath());
            if (index >= 0) {
                return index;
            }
        }
        int size = this.pictures.size();
        this.pictures.add(picture);
        this.picIndexs.put(picture.getTempFilePath(), size);
        return size;
    }

    public Picture getPicture(int index) {
        if (index < 0 || index >= this.pictures.size()) {
            return null;
        }
        return this.pictures.get(index);
    }

    public int getPictureIndex(String key) {
        Integer a = this.picIndexs.get(key);
        if (a == null) {
            return -1;
        }
        return a;
    }

    public String writeTempFile(byte[] b) {
        try {
            return this.writeTempFile(b, 0, b.length);
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
            return null;
        }
    }

    public String writeTempFile(InflaterInputStream in) {
        String name = String.valueOf(System.currentTimeMillis()) + ".tmp";
        File file = new File(this.picTempPath + File.separator + name);
        try {
            int readBytes;
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            while ((readBytes = in.read(buf)) > 0) {
                out.write(buf, 0, readBytes);
            }
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
        }
        return file.getAbsolutePath();
    }

    public String writeTempFile(byte[] b, int offset, int len) {
        String name = String.valueOf(System.currentTimeMillis()) + ".tmp";
        File file = new File(this.picTempPath + File.separator + name);
        try {
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            out.write(b, offset, len);
            out.close();
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
        }
        return file.getAbsolutePath();
    }

    private String writeTempFile(PackagePart picPart) {
        try {
            if (picPart != null) {
                int len;
                String name = String.valueOf(System.currentTimeMillis()) + ".tmp";
                File file = new File(this.picTempPath + File.separator + name);
                file.createNewFile();
                FileOutputStream out = new FileOutputStream(file);
                InputStream in = picPart.getInputStream();
                byte[] b = new byte[8192];
                while ((len = in.read(b, 0, b.length)) != -1) {
                    out.write(b, 0, len);
                }
                in.close();
                out.close();
                return file.getAbsolutePath();
            }
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
        }
        return null;
    }

    public synchronized Bitmap getBitmap(String key) {
        return bitmaps.get(key);
    }

    public synchronized void addBitmap(String key, Bitmap bitmap) {
        if (bitmapTotalCacheSize > 0x800000) {
            String str = bitmaps.entrySet().iterator().next().getKey();
            Bitmap b = bitmaps.get(str);
            bitmapTotalCacheSize -= b.getWidth() * b.getHeight();
            bitmaps.remove(str).recycle();
        }
        bitmapTotalCacheSize += bitmap.getHeight() * bitmap.getHeight();
        bitmaps.put(key, bitmap);
    }

    private void checkPictureConverterMgr() {
        if (this.picConverterMgr == null) {
            this.picConverterMgr = new PictureConverterMgr(this.control);
        } else {
            this.picConverterMgr.setControl(this.control);
        }
    }

    public boolean isConverting(String path) {
        this.checkPictureConverterMgr();
        return this.picConverterMgr.isPictureConverting(path);
    }

    public boolean hasConvertingVectorgraph(int viewIndex) {
        this.checkPictureConverterMgr();
        return this.picConverterMgr.hasConvertingVectorgraph(viewIndex);
    }

    public void appendViewIndex(String path, int viewIndex) {
        this.checkPictureConverterMgr();
        if (this.picConverterMgr != null) {
            this.picConverterMgr.appendViewIndex(path, viewIndex);
        }
    }

    public String convertVectorgraphToPng(int viewIndex, byte imageType, String path, int width, int height, boolean singleThread) {
        String convertToPath = path.substring(0, path.length() - 4) + "converted.tmp";
        this.checkPictureConverterMgr();
        this.picConverterMgr.addConvertPicture(viewIndex, imageType, path, convertToPath, width, height, singleThread);
        return convertToPath;
    }

    public String convertToPng(int viewIndex, String path, String picType, boolean singleThread) {
        String convertToPath = path.substring(0, path.length() - 4) + "converted.tmp";
        this.checkPictureConverterMgr();
        this.picConverterMgr.addConvertPicture(viewIndex, path, convertToPath, picType, singleThread);
        return convertToPath;
    }

    public synchronized void clearBitmap() {
        for (Bitmap bitmap : bitmaps.values()) {
            bitmap.recycle();
        }
        bitmaps.clear();
        bitmapTotalCacheSize = 0;
    }

    public boolean hasBitmap() {
        return bitmaps.size() > 0;
    }

    public String getPicTempPath() {
        return this.picTempPath;
    }

    private void deleteTempFile(File folder) {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
        folder.delete();
    }

    public boolean saveBitmapToFile(Bitmap bitmap, Bitmap.CompressFormat picType, String fileName) {
        File file = new File(this.picTempPath + File.separatorChar + fileName + ".jpg");
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fOut = new FileOutputStream(file);
            bitmap.compress(picType, 100, (OutputStream)fOut);
            fOut.flush();
            fOut.close();
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
            return false;
        }
        return true;
    }

    public void dispose() {
        this.clearBitmap();
        if (this.pictures != null) {
            for (Picture picture : this.pictures) {
                picture.dispose();
            }
            this.pictures.clear();
        }
        this.picIndexs.clear();
        this.control = null;
        final File folder = new File(this.picTempPath);
        try {
            if (this.picConverterMgr != null) {
                this.picConverterMgr.dispose();
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        PictureManage.this.deleteTempFile(folder);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        bitmaps = new LinkedHashMap<String, Bitmap>(10);
    }
}

