/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.picture;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureConverterThread;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.VectorgraphConverterThread;
import com.ahmadullahpk.alldocumentreader.xs.fc.pdf.PDFLib;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.util.EMFUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PictureConverterMgr {
    private IControl control;
    private List<Thread> convertingThread;
    private Map<String, Thread> convertingPictPathMap;
    private Map<String, List<Integer>> vectorgraphViews;
    private Map<Integer, List<String>> viewVectorgraphs;

    public PictureConverterMgr(IControl control) {
        this.control = control;
        this.convertingThread = new ArrayList<Thread>();
        this.convertingPictPathMap = new HashMap<String, Thread>();
        this.vectorgraphViews = new HashMap<String, List<Integer>>();
        this.viewVectorgraphs = new HashMap<Integer, List<String>>();
    }

    public void setControl(IControl control) {
        this.control = control;
    }

    public synchronized void addConvertPicture(int viewIndex, byte type, String srcPath, String dstPath, int width, int height, boolean singleThread) {
        this.control.actionEvent(26, true);
        if (singleThread) {
            this.convertWMF_EMF(type, srcPath, dstPath, width, height, true);
        } else {
            VectorgraphConverterThread thread = new VectorgraphConverterThread(this, type, srcPath, dstPath, width, height);
            this.convertingThread.add(thread);
            this.convertingPictPathMap.put(dstPath, thread);
            ArrayList<Integer> listIndex = new ArrayList<Integer>();
            listIndex.add(viewIndex);
            this.vectorgraphViews.put(dstPath, listIndex);
            if (this.viewVectorgraphs.get(viewIndex) == null) {
                ArrayList<String> listPath = new ArrayList<String>();
                listPath.add(dstPath);
                this.viewVectorgraphs.put(viewIndex, listPath);
            } else {
                this.viewVectorgraphs.get(viewIndex).add(dstPath);
            }
            if (this.convertingThread.size() == 1) {
                this.convertingThread.get(this.convertingThread.size() - 1).start();
            }
        }
    }

    public void convertWMF_EMF(byte type, String sourPath, String destPath, int picWidth, int picHeight, boolean thumbnail) {
        try {
            Bitmap sBitmap = null;
            if (type == 3) {
                int ret = PDFLib.getPDFLib().wmf2Jpg(sourPath, destPath, picWidth, picHeight);
                sBitmap = BitmapFactory.decodeFile((String)destPath);
            } else if (type == 2) {
                sBitmap = EMFUtil.convert(sourPath, destPath, picWidth, picHeight);
            }
            if (this.control != null && (this.convertingPictPathMap.get(destPath) == null || this.control.getView() == null)) {
                return;
            }
            if (sBitmap != null) {
                this.control.getSysKit().getPictureManage().addBitmap(destPath, sBitmap);
                this.remove(destPath);
                if (!thumbnail) {
                    this.control.actionEvent(-268435456, null);
                }
            } else {
                this.remove(destPath);
            }
        }
        catch (OutOfMemoryError e) {
            if (this.control.getSysKit().getPictureManage().hasBitmap()) {
                this.control.getSysKit().getPictureManage().clearBitmap();
                this.convertWMF_EMF(type, sourPath, destPath, picWidth, picHeight, thumbnail);
            } else {
                this.control.getSysKit().getErrorKit().writerLog(e);
                this.remove(destPath);
            }
        }
        catch (Exception e) {
            if (this.control != null && (this.convertingPictPathMap.get(destPath) == null || this.control.getView() == null)) {
                return;
            }
            this.control.getSysKit().getErrorKit().writerLog(e);
            this.remove(destPath);
        }
    }

    public synchronized void addConvertPicture(int viewIndex, String srcPath, String dstPath, String picType, boolean singleThread) {
        this.control.actionEvent(26, true);
        if (singleThread) {
            this.convertPNG(srcPath, dstPath, picType, true);
        } else {
            PictureConverterThread thread = new PictureConverterThread(this, srcPath, dstPath, picType);
            this.convertingThread.add(thread);
            this.convertingPictPathMap.put(dstPath, thread);
            ArrayList<Integer> listIndex = new ArrayList<Integer>();
            listIndex.add(viewIndex);
            this.vectorgraphViews.put(dstPath, listIndex);
            if (this.viewVectorgraphs.get(viewIndex) == null) {
                ArrayList<String> listPath = new ArrayList<String>();
                listPath.add(dstPath);
                this.viewVectorgraphs.put(viewIndex, listPath);
            } else {
                this.viewVectorgraphs.get(viewIndex).add(dstPath);
            }
            if (this.convertingThread.size() == 1) {
                this.convertingThread.get(this.convertingThread.size() - 1).start();
            }
        }
    }

    public void convertPNG(String sourPath, String destPath, String picType, boolean thumbnail) {
        try {
            boolean ret = PDFLib.getPDFLib().convertToPNG(sourPath, destPath, picType);
            if (this.control != null && (this.convertingPictPathMap.get(destPath) == null || this.control.getView() == null)) {
                return;
            }
            if (ret) {
                FileInputStream in = new FileInputStream(destPath);
                Bitmap sBitmap = BitmapFactory.decodeStream((InputStream)in, null, null);
                if (sBitmap != null) {
                    this.control.getSysKit().getPictureManage().addBitmap(destPath, sBitmap);
                    this.remove(destPath);
                    if (!thumbnail) {
                        this.control.actionEvent(-268435456, null);
                    }
                } else {
                    this.remove(destPath);
                }
            } else {
                this.remove(destPath);
            }
        }
        catch (OutOfMemoryError e) {
            if (this.control.getSysKit().getPictureManage().hasBitmap()) {
                this.control.getSysKit().getPictureManage().clearBitmap();
                this.convertPNG(sourPath, destPath, picType, thumbnail);
            } else {
                this.control.getSysKit().getErrorKit().writerLog(e);
                this.remove(destPath);
            }
        }
        catch (Exception e) {
            if (this.control != null && (this.convertingPictPathMap.get(destPath) == null || this.control.getView() == null)) {
                return;
            }
            this.control.getSysKit().getErrorKit().writerLog(e);
            this.remove(destPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path) {
        IControl iControl = this.control;
        synchronized (iControl) {
            if (this.convertingPictPathMap != null) {
                Thread thread = this.convertingPictPathMap.remove(path);
                this.convertingThread.remove(thread);
                ArrayList<Integer> updateViewList = null;
                List<Integer> viewList = this.vectorgraphViews.remove(path);
                for (int i = 0; i < viewList.size(); ++i) {
                    int viewIndex = viewList.get(i);
                    List<String> vectorgraphs = this.viewVectorgraphs.get(viewIndex);
                    vectorgraphs.remove(path);
                    if (vectorgraphs.size() != 0) continue;
                    this.viewVectorgraphs.remove(viewIndex);
                    if (updateViewList == null) {
                        updateViewList = new ArrayList<Integer>();
                    }
                    updateViewList.add(viewIndex);
                }
                if (this.convertingThread.size() > 0) {
                    List<String> vectorgraphs = this.viewVectorgraphs.get(this.control.getCurrentViewIndex());
                    if (vectorgraphs != null && vectorgraphs.size() > 0) {
                        this.convertingPictPathMap.get(vectorgraphs.get(0)).start();
                    } else {
                        this.convertingThread.get(this.convertingThread.size() - 1).start();
                    }
                }
                if (updateViewList != null && updateViewList.size() > 0) {
                    if (updateViewList.contains(this.control.getCurrentViewIndex())) {
                        this.control.actionEvent(0x2000000A, null);
                    }
                    this.control.actionEvent(27, updateViewList);
                }
                if (this.convertingPictPathMap.size() == 0) {
                    this.control.actionEvent(26, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConvertingVectorgraph(int viewIndex) {
        IControl iControl = this.control;
        synchronized (iControl) {
            return this.viewVectorgraphs.containsKey(viewIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPictureConverting(String path) {
        IControl iControl = this.control;
        synchronized (iControl) {
            return this.vectorgraphViews.containsKey(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendViewIndex(String path, int viewIndex) {
        IControl iControl = this.control;
        synchronized (iControl) {
            if (this.isPictureConverting(path)) {
                this.vectorgraphViews.get(path).add(viewIndex);
                if (this.viewVectorgraphs.get(viewIndex) == null) {
                    ArrayList<String> listPath = new ArrayList<String>();
                    listPath.add(path);
                    this.viewVectorgraphs.put(viewIndex, listPath);
                } else {
                    this.viewVectorgraphs.get(viewIndex).add(path);
                }
            }
        }
    }

    public synchronized void dispose() {
        if (this.convertingPictPathMap != null) {
            Iterator<Thread> iter = this.convertingPictPathMap.values().iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().interrupt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.convertingPictPathMap.clear();
            this.vectorgraphViews.clear();
            this.viewVectorgraphs.clear();
        }
    }
}

