/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.wedgecallout;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import java.util.ArrayList;
import java.util.List;

public class WedgeCalloutDrawing {
    private static RectF rectF = new RectF();
    private static Path path = new Path();
    private static List<ExtendPath> paths = new ArrayList<ExtendPath>();
    private static final WedgeCalloutDrawing kit = new WedgeCalloutDrawing();

    public static WedgeCalloutDrawing instance() {
        return kit;
    }

    public Object getWedgeCalloutPath(AutoShape shape, Rect rect) {
        paths.clear();
        path.reset();
        switch (shape.getShapeType()) {
            case 61: {
                return WedgeCalloutDrawing.getWedgeRectCalloutPath(shape, rect);
            }
            case 62: {
                return WedgeCalloutDrawing.getWedgeRoundRectCalloutPath(shape, rect);
            }
            case 63: {
                return WedgeCalloutDrawing.getWedgeEllipseCalloutPath(shape, rect);
            }
            case 106: {
                return WedgeCalloutDrawing.getCloudCalloutPath(shape, rect);
            }
            case 180: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getBorderCallout1Path(shape, rect);
                }
                return WedgeCalloutDrawing.get03BorderCallout2Path(shape, rect);
            }
            case 47: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getBorderCallout2Path(shape, rect);
                }
                return WedgeCalloutDrawing.get03BorderCallout2Path(shape, rect);
            }
            case 48: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getBorderCallout3Path(shape, rect);
                }
                return WedgeCalloutDrawing.get03BorderCallout3Path(shape, rect);
            }
            case 49: {
                return WedgeCalloutDrawing.get03BorderCallout4Path(shape, rect);
            }
            case 179: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getAccentCallout1Path(shape, rect);
                }
                return WedgeCalloutDrawing.get03AccentCallout1Path(shape, rect);
            }
            case 44: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getAccentCallout2Path(shape, rect);
                }
                return WedgeCalloutDrawing.get03AccentCallout2Path(shape, rect);
            }
            case 45: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getAccentCallout3Path(shape, rect);
                }
                return WedgeCalloutDrawing.get03AccentCallout3(shape, rect);
            }
            case 46: {
                return WedgeCalloutDrawing.get03AccentCallout4(shape, rect);
            }
            case 178: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getCallout1(shape, rect);
                }
                return WedgeCalloutDrawing.get03AccentCallout1Path(shape, rect);
            }
            case 41: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getCallout2(shape, rect);
                }
                return WedgeCalloutDrawing.get03Callout2(shape, rect);
            }
            case 42: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getCallout3(shape, rect);
                }
                return WedgeCalloutDrawing.get03Callout3(shape, rect);
            }
            case 43: {
                return WedgeCalloutDrawing.get03Callout4(shape, rect);
            }
            case 181: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getAccentBorderCallout1(shape, rect);
                }
                return WedgeCalloutDrawing.get03BorderCallout2Path(shape, rect);
            }
            case 50: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getAccentBorderCallout2(shape, rect);
                }
                return WedgeCalloutDrawing.get03AccentBorderCallout2(shape, rect);
            }
            case 51: {
                if (shape.isAutoShape07()) {
                    return WedgeCalloutDrawing.getAccentBorderCallout3(shape, rect);
                }
                return WedgeCalloutDrawing.get03AccentBorderCallout3(shape, rect);
            }
            case 52: {
                return WedgeCalloutDrawing.get03AccentBorderCallout4(shape, rect);
            }
        }
        return null;
    }

    private static Path getWedgeRectCalloutPath(AutoShape shape, Rect rect) {
        float x = (float)(-rect.width()) * 0.2f;
        float y = (float)rect.height() * 0.6f;
        float z = (float)rect.width() / 12.0f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    x = (float)rect.width() * values[0].floatValue();
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue();
                }
            }
        } else {
            x = (float)(-rect.width()) * 0.433f;
            y = (float)rect.height() * 0.7f;
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    x = (float)rect.width() * values[0].floatValue() - (float)(rect.width() / 2);
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue() - (float)(rect.height() / 2);
                }
            }
        }
        if (Math.abs(y / x) < (float)rect.height() / (float)rect.width()) {
            z = (float)rect.height() / 12.0f;
            if (x >= 0.0f) {
                path.moveTo((float)rect.left, (float)rect.top);
                path.lineTo((float)rect.right, (float)rect.top);
                if (y >= 0.0f) {
                    path.lineTo((float)rect.right, rect.exactCenterY() + z);
                    path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                    path.lineTo((float)rect.right, (float)rect.bottom - z * 2.0f);
                } else {
                    path.lineTo((float)rect.right, (float)rect.top + z * 2.0f);
                    path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                    path.lineTo((float)rect.right, rect.exactCenterY() - z);
                }
                path.lineTo((float)rect.right, (float)rect.bottom);
                path.lineTo((float)rect.left, (float)rect.bottom);
            } else {
                path.moveTo((float)rect.left, (float)rect.top);
                path.lineTo((float)rect.right, (float)rect.top);
                path.lineTo((float)rect.right, (float)rect.bottom);
                path.lineTo((float)rect.left, (float)rect.bottom);
                if (y >= 0.0f) {
                    path.lineTo((float)rect.left, (float)rect.bottom - z * 2.0f);
                    path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                    path.lineTo((float)rect.left, rect.exactCenterY() + z);
                } else {
                    path.lineTo((float)rect.left, rect.exactCenterY() - z);
                    path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                    path.lineTo((float)rect.left, (float)rect.top + z * 2.0f);
                }
            }
        } else if (y >= 0.0f) {
            path.moveTo((float)rect.left, (float)rect.top);
            path.lineTo((float)rect.right, (float)rect.top);
            path.lineTo((float)rect.right, (float)rect.bottom);
            if (x >= 0.0f) {
                path.lineTo((float)rect.right - z * 2.0f, (float)rect.bottom);
                path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                path.lineTo(rect.exactCenterX() + z, (float)rect.bottom);
            } else {
                path.lineTo(rect.exactCenterX() - z, (float)rect.bottom);
                path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                path.lineTo((float)rect.left + z * 2.0f, (float)rect.bottom);
            }
            path.lineTo((float)rect.left, (float)rect.bottom);
        } else {
            path.moveTo((float)rect.left, (float)rect.top);
            if (x >= 0.0f) {
                path.lineTo(rect.exactCenterX() + z, (float)rect.top);
                path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                path.lineTo((float)rect.right - z * 2.0f, (float)rect.top);
            } else {
                path.lineTo((float)rect.left + z * 2.0f, (float)rect.top);
                path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                path.lineTo(rect.exactCenterX() - z, (float)rect.top);
            }
            path.lineTo((float)rect.right, (float)rect.top);
            path.lineTo((float)rect.right, (float)rect.bottom);
            path.lineTo((float)rect.left, (float)rect.bottom);
        }
        path.close();
        return path;
    }

    private static Path getWedgeRoundRectCalloutPath(AutoShape shape, Rect rect) {
        float x = (float)(-rect.width()) * 0.2f;
        float y = (float)rect.height() * 0.6f;
        float z = (float)rect.width() / 12.0f;
        float r = (float)Math.min(rect.width(), rect.height()) * 0.16667f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            if (values != null && values.length >= 3) {
                if (values[0] != null) {
                    x = (float)rect.width() * values[0].floatValue();
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue();
                }
                if (values[2] != null) {
                    r = (float)Math.min(rect.width(), rect.height()) * values[2].floatValue();
                }
            }
        } else {
            x = (float)(-rect.width()) * 0.433f;
            y = (float)rect.height() * 0.7f;
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    x = (float)rect.width() * values[0].floatValue() - (float)(rect.width() / 2);
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue() - (float)(rect.height() / 2);
                }
            }
        }
        if (Math.abs(y / x) < (float)rect.height() / (float)rect.width()) {
            z = (float)rect.height() / 12.0f;
            if (x >= 0.0f) {
                rectF.set((float)rect.left, (float)rect.top, (float)rect.left + r * 2.0f, (float)rect.top + r * 2.0f);
                path.arcTo(rectF, 180.0f, 90.0f);
                rectF.set((float)rect.right - r * 2.0f, (float)rect.top, (float)rect.right, (float)rect.top + r * 2.0f);
                path.arcTo(rectF, 270.0f, 90.0f);
                if (y >= 0.0f) {
                    path.lineTo((float)rect.right, rect.exactCenterY() + z);
                    path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                    path.lineTo((float)rect.right, (float)rect.bottom - z * 2.0f);
                } else {
                    path.lineTo((float)rect.right, (float)rect.top + z * 2.0f);
                    path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                    path.lineTo((float)rect.right, rect.exactCenterY() - z);
                }
                rectF.set((float)rect.right - r * 2.0f, (float)rect.bottom - r * 2.0f, (float)rect.right, (float)rect.bottom);
                path.arcTo(rectF, 0.0f, 90.0f);
                rectF.set((float)rect.left, (float)rect.bottom - r * 2.0f, (float)rect.left + r * 2.0f, (float)rect.bottom);
                path.arcTo(rectF, 90.0f, 90.0f);
            } else {
                rectF.set((float)rect.left, (float)rect.top, (float)rect.left + r * 2.0f, (float)rect.top + r * 2.0f);
                path.arcTo(rectF, 180.0f, 90.0f);
                rectF.set((float)rect.right - r * 2.0f, (float)rect.top, (float)rect.right, (float)rect.top + r * 2.0f);
                path.arcTo(rectF, 270.0f, 90.0f);
                rectF.set((float)rect.right - r * 2.0f, (float)rect.bottom - r * 2.0f, (float)rect.right, (float)rect.bottom);
                path.arcTo(rectF, 0.0f, 90.0f);
                rectF.set((float)rect.left, (float)rect.bottom - r * 2.0f, (float)rect.left + r * 2.0f, (float)rect.bottom);
                path.arcTo(rectF, 90.0f, 90.0f);
                if (y >= 0.0f) {
                    path.lineTo((float)rect.left, (float)rect.bottom - z * 2.0f);
                    path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                    path.lineTo((float)rect.left, rect.exactCenterY() + z);
                } else {
                    path.lineTo((float)rect.left, rect.exactCenterY() - z);
                    path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                    path.lineTo((float)rect.left, (float)rect.top + z * 2.0f);
                }
            }
        } else if (y >= 0.0f) {
            rectF.set((float)rect.left, (float)rect.top, (float)rect.left + r * 2.0f, (float)rect.top + r * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
            rectF.set((float)rect.right - r * 2.0f, (float)rect.top, (float)rect.right, (float)rect.top + r * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
            rectF.set((float)rect.right - r * 2.0f, (float)rect.bottom - r * 2.0f, (float)rect.right, (float)rect.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
            if (x >= 0.0f) {
                path.lineTo((float)rect.right - z * 2.0f, (float)rect.bottom);
                path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                path.lineTo(rect.exactCenterX() + z, (float)rect.bottom);
            } else {
                path.lineTo(rect.exactCenterX() - z, (float)rect.bottom);
                path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                path.lineTo((float)rect.left + z * 2.0f, (float)rect.bottom);
            }
            rectF.set((float)rect.left, (float)rect.bottom - r * 2.0f, (float)rect.left + r * 2.0f, (float)rect.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
        } else {
            rectF.set((float)rect.left, (float)rect.top, (float)rect.left + r * 2.0f, (float)rect.top + r * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
            if (x >= 0.0f) {
                path.lineTo(rect.exactCenterX() + z, (float)rect.top);
                path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                path.lineTo((float)rect.right - z * 2.0f, (float)rect.top);
            } else {
                path.lineTo((float)rect.left + z * 2.0f, (float)rect.top);
                path.lineTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
                path.lineTo(rect.exactCenterX() - z, (float)rect.top);
            }
            rectF.set((float)rect.right - r * 2.0f, (float)rect.top, (float)rect.right, (float)rect.top + r * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
            rectF.set((float)rect.right - r * 2.0f, (float)rect.bottom - r * 2.0f, (float)rect.right, (float)rect.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
            rectF.set((float)rect.left, (float)rect.bottom - r * 2.0f, (float)rect.left + r * 2.0f, (float)rect.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
        }
        path.close();
        return path;
    }

    private static Path getWedgeEllipseCalloutPath(AutoShape shape, Rect rect) {
        float x = (float)(-rect.width()) * 0.2f;
        float y = (float)rect.height() * 0.6f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    x = (float)rect.width() * values[0].floatValue();
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue();
                }
            }
        } else {
            x = (float)(-rect.width()) * 0.433f;
            y = (float)rect.height() * 0.7f;
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    x = (float)rect.width() * values[0].floatValue() - (float)(rect.width() / 2);
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue() - (float)(rect.height() / 2);
                }
            }
        }
        float angle1 = (float)Math.toDegrees(Math.atan2(rect.width(), rect.height())) / 2.0f;
        float angle2 = (float)Math.toDegrees(Math.atan2(Math.abs(y), Math.abs(x)));
        float start = 0.0f;
        path.moveTo(rect.exactCenterX() + x, rect.exactCenterY() + y);
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        if (y >= 0.0f) {
            start = x >= 0.0f ? angle2 + angle1 / 2.0f : 180.0f - angle2 + angle1 / 2.0f;
            path.arcTo(rectF, start, 360.0f - angle1);
        } else {
            start = x >= 0.0f ? 360.0f - angle2 - angle1 / 2.0f : 180.0f + angle2 - angle1 / 2.0f;
            path.arcTo(rectF, start, -360.0f + angle1);
        }
        path.close();
        return path;
    }

    private static Path getCloudCalloutPath(AutoShape shape, Rect rect) {
        float len = 468.0f;
        rectF.set(0.0f, 160.0f, 90.0f, 285.0f);
        path.arcTo(rectF, 120.0f, 148.0f);
        rectF.set(41.0f, 44.0f, 188.0f, 250.0f);
        path.arcTo(rectF, 172.5f, 127.5f);
        rectF.set(140.0f, 14.0f, 264.0f, 220.0f);
        path.arcTo(rectF, 218.0f, 90.0f);
        rectF.set(230.0f, 0.0f, 340.0f, 210.0f);
        path.arcTo(rectF, 219.0f, 92.0f);
        rectF.set(296.0f, 0.0f, 428.0f, 246.0f);
        path.arcTo(rectF, 232.0f, 101.0f);
        rectF.set(342.0f, 60.0f, 454.0f, 214.0f);
        path.arcTo(rectF, 293.0f, 89.0f);
        rectF.set(324.0f, 130.0f, 468.0f, 327.0f);
        path.arcTo(rectF, 319.0f, 119.0f);
        rectF.set(280.0f, 240.0f, 405.0f, 412.0f);
        path.arcTo(rectF, 1.0f, 122.0f);
        rectF.set(168.0f, 274.0f, 312.0f, 468.0f);
        path.arcTo(rectF, 16.0f, 130.0f);
        rectF.set(57.0f, 249.0f, 213.0f, 441.0f);
        path.arcTo(rectF, 56.0f, 74.0f);
        rectF.set(11.0f, 259.0f, 99.0f, 386.0f);
        path.arcTo(rectF, 84.0f, 140.0f);
        path.close();
        Matrix m = new Matrix();
        m.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(m);
        path.offset((float)rect.left, (float)rect.top);
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (shape.isAutoShape07()) {
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    adj1 = Math.round((float)rect.width() * values[0].floatValue());
                }
                if (values[1] != null) {
                    adj2 = Math.round((float)rect.height() * values[1].floatValue());
                }
            } else {
                adj1 = Math.round((float)rect.width() * -0.2f);
                adj2 = Math.round((float)rect.height() * 0.6f);
            }
        } else if (values != null && values.length >= 2) {
            if (values[0] != null) {
                adj1 = Math.round((float)rect.width() * values[0].floatValue() - (float)(rect.width() / 2));
            }
            if (values[1] != null) {
                adj2 = Math.round((float)rect.height() * values[1].floatValue() - (float)(rect.height() / 2));
            }
        } else {
            adj1 = Math.round((float)rect.width() * -0.433f);
            adj2 = Math.round((float)rect.height() * 0.7f);
        }
        double angle = WedgeCalloutDrawing.getAngle(adj1, adj2);
        int a = rect.width() / 2;
        int b = rect.height() / 2;
        float outx = (float)((double)(a * b) / Math.sqrt(Math.pow(b, 2.0) + Math.pow((double)a * Math.tan(angle * Math.PI / 180.0), 2.0)));
        if (angle > 90.0 && angle < 270.0) {
            outx = -outx;
        }
        float outy = (float)((double)outx * Math.tan(angle * Math.PI / 180.0));
        float sx = rect.centerX() + adj1;
        float sy = rect.centerY() + adj2;
        outx = (float)rect.centerX() + outx;
        outy = (float)rect.centerY() + outy;
        float r = (float)Math.min(rect.width(), rect.height()) / 468.0f;
        path.addCircle(sx, sy, 16.0f * r, Path.Direction.CW);
        float x = outx + 0.7f * (sx - outx);
        float y = outy + 0.7f * (sy - outy);
        path.addCircle(x, y, 24.0f * r, Path.Direction.CW);
        x = outx + 0.3f * (sx - outx);
        y = outy + 0.3f * (sy - outy);
        path.addCircle(x, y, 40.0f * r, Path.Direction.CW);
        return path;
    }

    private static double getAngle(double x, double y) {
        double angle = Math.acos(x / Math.sqrt(x * x + y * y)) * 180.0 / Math.PI;
        if (y < 0.0) {
            angle = 360.0 - angle;
        }
        return angle;
    }

    private static Path getBorderCallout1Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 1.125f;
        float x2 = (float)rect.left + (float)rect.width() * -0.38333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 4) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
        }
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        return path;
    }

    private static List<ExtendPath> getBorderCallout2Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 1.125f;
        float x3 = (float)rect.left + (float)rect.width() * -0.46667f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 6) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
            if (values[4] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[4].floatValue();
            }
            if (values[5] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[5].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getBorderCallout3Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 1.0f;
        float x3 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y4 = (float)rect.top + (float)rect.height() * 1.12963f;
        float x4 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 8) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
            if (values[4] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[4].floatValue();
            }
            if (values[5] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[5].floatValue();
            }
            if (values[6] != null) {
                y4 = (float)rect.top + (float)rect.height() * values[6].floatValue();
            }
            if (values[7] != null) {
                x4 = (float)rect.left + (float)rect.width() * values[7].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        path.lineTo(x4, y4);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getAccentCallout1Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 1.125f;
        float x2 = (float)rect.left + (float)rect.width() * -0.38333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 4) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, (float)rect.top);
        path.lineTo(x1, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getAccentCallout2Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 1.125f;
        float x3 = (float)rect.left + (float)rect.width() * -0.46667f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 6) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
            if (values[4] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[4].floatValue();
            }
            if (values[5] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[5].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setPath(path);
        extendPath.setBackgroundAndFill(fill);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, (float)rect.top);
        path.lineTo(x1, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getAccentCallout3Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 1.0f;
        float x3 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y4 = (float)rect.top + (float)rect.height() * 1.12963f;
        float x4 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 8) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
            if (values[4] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[4].floatValue();
            }
            if (values[5] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[5].floatValue();
            }
            if (values[6] != null) {
                y4 = (float)rect.top + (float)rect.height() * values[6].floatValue();
            }
            if (values[7] != null) {
                x4 = (float)rect.left + (float)rect.width() * values[7].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setPath(path);
        extendPath.setBackgroundAndFill(fill);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, (float)rect.top);
        path.lineTo(x1, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        path.lineTo(x4, y4);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getCallout1(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 1.125f;
        float x2 = (float)rect.left + (float)rect.width() * -0.38333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 4) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setPath(path);
        extendPath.setBackgroundAndFill(fill);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getCallout2(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 1.125f;
        float x3 = (float)rect.left + (float)rect.width() * -0.46667f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 6) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
            if (values[4] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[4].floatValue();
            }
            if (values[5] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[5].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setPath(path);
        extendPath.setBackgroundAndFill(fill);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getCallout3(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 1.0f;
        float x3 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y4 = (float)rect.top + (float)rect.height() * 1.12963f;
        float x4 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 8) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
            if (values[4] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[4].floatValue();
            }
            if (values[5] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[5].floatValue();
            }
            if (values[6] != null) {
                y4 = (float)rect.top + (float)rect.height() * values[6].floatValue();
            }
            if (values[7] != null) {
                x4 = (float)rect.left + (float)rect.width() * values[7].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setPath(path);
        extendPath.setBackgroundAndFill(fill);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        path.lineTo(x4, y4);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static Path getAccentBorderCallout1(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 1.125f;
        float x2 = (float)rect.left + (float)rect.width() * -0.38333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 4) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
        }
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        path.moveTo(x1, (float)rect.top);
        path.lineTo(x1, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        return path;
    }

    private static List<ExtendPath> getAccentBorderCallout2(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 1.125f;
        float x3 = (float)rect.left + (float)rect.width() * -0.46667f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 6) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
            if (values[4] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[4].floatValue();
            }
            if (values[5] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[5].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, (float)rect.top);
        path.lineTo(x1, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getAccentBorderCallout3(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 1.0f;
        float x3 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y4 = (float)rect.top + (float)rect.height() * 1.12963f;
        float x4 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 8) {
            if (values[0] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[1].floatValue();
            }
            if (values[2] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[2].floatValue();
            }
            if (values[3] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[3].floatValue();
            }
            if (values[4] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[4].floatValue();
            }
            if (values[5] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[5].floatValue();
            }
            if (values[6] != null) {
                y4 = (float)rect.top + (float)rect.height() * values[6].floatValue();
            }
            if (values[7] != null) {
                x4 = (float)rect.left + (float)rect.width() * values[7].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, (float)rect.top);
        path.lineTo(x1, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        path.lineTo(x4, y4);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03BorderCallout2Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03BorderCallout3Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y3 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x3 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
            if (values.length >= 5 && values[4] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[4].floatValue();
            }
            if (values.length >= 6 && values[5] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[5].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03BorderCallout4Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x3 = (float)rect.left + (float)rect.width() * 1.08333f;
        float y4 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x4 = (float)rect.left + (float)rect.width() * 1.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
            if (values.length >= 5 && values[4] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[4].floatValue();
            }
            if (values.length >= 6 && values[5] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[5].floatValue();
            }
            if (values.length >= 7 && values[6] != null) {
                x4 = (float)rect.left + (float)rect.width() * values[6].floatValue();
            }
            if (values.length >= 8 && values[7] != null) {
                y4 = (float)rect.top + (float)rect.height() * values[7].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        path.lineTo(x4, y4);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03AccentCallout1Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.38333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 4) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        extendPath.setLine(shape.getLine());
        extendPath.setPath(path);
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03AccentCallout2Path(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x2, (float)rect.top);
        path.lineTo(x2, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03AccentCallout3(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y3 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x3 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
            if (values.length >= 5 && values[4] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[4].floatValue();
            }
            if (values.length >= 6 && values[5] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[5].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x3, (float)rect.top);
        path.lineTo(x3, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03AccentCallout4(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x3 = (float)rect.left + (float)rect.width() * 1.08333f;
        float y4 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x4 = (float)rect.left + (float)rect.width() * 1.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
            if (values.length >= 5 && values[4] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[4].floatValue();
            }
            if (values.length >= 6 && values[5] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[5].floatValue();
            }
            if (values.length >= 7 && values[6] != null) {
                x4 = (float)rect.left + (float)rect.width() * values[6].floatValue();
            }
            if (values.length >= 8 && values[7] != null) {
                y4 = (float)rect.top + (float)rect.height() * values[7].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x4, (float)rect.top);
        path.lineTo(x4, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        path.lineTo(x4, y4);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03Callout2(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03Callout3(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y3 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x3 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
            if (values.length >= 5 && values[4] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[4].floatValue();
            }
            if (values.length >= 6 && values[5] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[5].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03Callout4(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x3 = (float)rect.left + (float)rect.width() * 1.08333f;
        float y4 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x4 = (float)rect.left + (float)rect.width() * 1.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
            if (values.length >= 5 && values[4] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[4].floatValue();
            }
            if (values.length >= 6 && values[5] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[5].floatValue();
            }
            if (values.length >= 7 && values[6] != null) {
                x4 = (float)rect.left + (float)rect.width() * values[6].floatValue();
            }
            if (values.length >= 8 && values[7] != null) {
                y4 = (float)rect.top + (float)rect.height() * values[7].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        path.lineTo(x4, y4);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03AccentBorderCallout2(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x2, (float)rect.top);
        path.lineTo(x2, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03AccentBorderCallout3(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y3 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x3 = (float)rect.left + (float)rect.width() * -0.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
            if (values.length >= 5 && values[4] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[4].floatValue();
            }
            if (values.length >= 6 && values[5] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[5].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x3, (float)rect.top);
        path.lineTo(x3, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> get03AccentBorderCallout4(AutoShape shape, Rect rect) {
        float y1 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x1 = (float)rect.left + (float)rect.width() * -0.08333f;
        float y2 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x2 = (float)rect.left + (float)rect.width() * -0.16667f;
        float y3 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x3 = (float)rect.left + (float)rect.width() * 1.08333f;
        float y4 = (float)rect.top + (float)rect.height() * 0.1875f;
        float x4 = (float)rect.left + (float)rect.width() * 1.08333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                x1 = (float)rect.left + (float)rect.width() * values[0].floatValue();
            }
            if (values.length >= 2 && values[1] != null) {
                y1 = (float)rect.top + (float)rect.height() * values[1].floatValue();
            }
            if (values.length >= 3 && values[2] != null) {
                x2 = (float)rect.left + (float)rect.width() * values[2].floatValue();
            }
            if (values.length >= 4 && values[3] != null) {
                y2 = (float)rect.top + (float)rect.height() * values[3].floatValue();
            }
            if (values.length >= 5 && values[4] != null) {
                x3 = (float)rect.left + (float)rect.width() * values[4].floatValue();
            }
            if (values.length >= 6 && values[5] != null) {
                y3 = (float)rect.top + (float)rect.height() * values[5].floatValue();
            }
            if (values.length >= 7 && values[6] != null) {
                x4 = (float)rect.left + (float)rect.width() * values[6].floatValue();
            }
            if (values.length >= 8 && values[7] != null) {
                y4 = (float)rect.top + (float)rect.height() * values[7].floatValue();
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo(x4, (float)rect.top);
        path.lineTo(x4, (float)rect.bottom);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        path.lineTo(x3, y3);
        path.lineTo(x4, y4);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        return paths;
    }
}

