/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.smartArt;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;

public class SmartArtPathBuilder {
    private static final float TODEGREE = 1.6666666f;
    private static Matrix sm = new Matrix();
    private static RectF s_rect = new RectF();
    private static Path path = new Path();

    public static Path getStarPath(AutoShape shape, Rect rect) {
        path.reset();
        switch (shape.getShapeType()) {
            case 240: {
                return SmartArtPathBuilder.getFunnelPath(shape, rect);
            }
            case 241: {
                return SmartArtPathBuilder.getGear6Path(shape, rect);
            }
            case 242: {
                return SmartArtPathBuilder.getGear9Path(shape, rect);
            }
            case 243: {
                return SmartArtPathBuilder.getLeftCircularArrowPath(shape, rect);
            }
            case 245: {
                return SmartArtPathBuilder.getPieWedgePath(shape, rect);
            }
            case 246: {
                return SmartArtPathBuilder.getSwooshArrowPath(shape, rect);
            }
        }
        return null;
    }

    private static Path getFunnelPath(AutoShape shape, Rect rect) {
        float width = 716.0f;
        float height = 536.0f;
        path.addOval(new RectF(28.0f, 22.0f, 688.0f, 238.0f), Path.Direction.CCW);
        path.moveTo(0.0f, 130.0f);
        path.arcTo(new RectF(0.0f, 0.0f, 716.0f, 260.0f), 180.0f, 180.0f);
        path.arcTo(new RectF(258.0f, 444.0f, 458.0f, 536.0f), 30.0f, 150.0f);
        path.close();
        sm.reset();
        sm.postScale((float)rect.width() / width, (float)rect.height() / height);
        path.transform(sm);
        path.offset((float)rect.left, (float)rect.top);
        return path;
    }

    private static Path getGear6Path(AutoShape shape, Rect rect) {
        float len = 6858000.0f;
        path.moveTo(5131482.0f, 1736961.0f);
        path.lineTo(6143269.0f, 1432030.0f);
        path.lineTo(6515568.0f, 2076873.0f);
        path.lineTo(5745593.0f, 2800638.0f);
        path.cubicTo(5857203.0f, 3212114.0f, 5857203.0f, 3645892.0f, 5745592.0f, 4057368.0f);
        path.lineTo(6515568.0f, 4781127.0f);
        path.lineTo(6143269.0f, 5425970.0f);
        path.lineTo(5131482.0f, 5121039.0f);
        path.cubicTo(4830937.0f, 5423437.0f, 4455271.0f, 5640328.0f, 4043114.0f, 5749407.0f);
        path.lineTo(3801303.0f, 6778110.0f);
        path.lineTo(3056697.0f, 6778110.0f);
        path.lineTo(2814884.0f, 5749410.0f);
        path.cubicTo(2402727.0f, 5640330.0f, 2027062.0f, 5423438.0f, 1726518.0f, 5121040.0f);
        path.lineTo(714731.0f, 5425970.0f);
        path.lineTo(342432.0f, 4781127.0f);
        path.lineTo(1112407.0f, 4057362.0f);
        path.cubicTo(1000796.0f, 3645886.0f, 1000796.0f, 3212108.0f, 1112407.0f, 2800632.0f);
        path.lineTo(342432.0f, 2076873.0f);
        path.lineTo(714731.0f, 1432030.0f);
        path.lineTo(1726518.0f, 1736961.0f);
        path.cubicTo(2027063.0f, 1434563.0f, 2402729.0f, 1217673.0f, 2814886.0f, 1108594.0f);
        path.lineTo(3056697.0f, 79890.0f);
        path.lineTo(3801303.0f, 79890.0f);
        path.lineTo(4043116.0f, 1108590.0f);
        path.cubicTo(4455273.0f, 1217671.0f, 4830938.0f, 1434562.0f, 5131482.0f, 1736961.0f);
        path.close();
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.left, (float)rect.top);
        return path;
    }

    private static Path getGear9Path(AutoShape shape, Rect rect) {
        float len = 5715040.0f;
        path.moveTo(4056564.0f, 911200.0f);
        path.lineTo(4501105.0f, 538168.0f);
        path.lineTo(4856239.0f, 836163.0f);
        path.lineTo(4566066.0f, 1338725.0f);
        path.cubicTo(4772395.0f, 1570831.0f, 4929267.0f, 1842544.0f, 5027111.0f, 2137283.0f);
        path.lineTo(5607429.0f, 2137269.0f);
        path.lineTo(5687931.0f, 2593823.0f);
        path.lineTo(5142605.0f, 2792288.0f);
        path.cubicTo(5151467.0f, 3102716.0f, 5096985.0f, 3411694.0f, 4982485.0f, 3700369.0f);
        path.lineTo(5427044.0f, 4073378.0f);
        path.lineTo(5195245.0f, 4474864.0f);
        path.lineTo(4649930.0f, 4276370.0f);
        path.cubicTo(4457179.0f, 4519870.0f, 4216835.0f, 4721542.0f, 3943563.0f, 4869081.0f);
        path.lineTo(4044350.0f, 5440580.0f);
        path.lineTo(3608711.0f, 5599139.0f);
        path.lineTo(3318566.0f, 5096561.0f);
        path.cubicTo(3014392.0f, 5159194.0f, 2700646.0f, 5159194.0f, 2396472.0f, 5096561.0f);
        path.lineTo(2106329.0f, 5599139.0f);
        path.lineTo(1670690.0f, 5440580.0f);
        path.lineTo(1771476.0f, 4869081.0f);
        path.cubicTo(1498205.0f, 4721541.0f, 1257861.0f, 4519869.0f, 1065110.0f, 4276369.0f);
        path.lineTo(519795.0f, 4474864.0f);
        path.lineTo(287996.0f, 4073378.0f);
        path.lineTo(732555.0f, 3700369.0f);
        path.cubicTo(618055.0f, 3411694.0f, 563574.0f, 3102715.0f, 572436.0f, 2792288.0f);
        path.lineTo(27109.0f, 2593823.0f);
        path.lineTo(107611.0f, 2137269.0f);
        path.lineTo(687928.0f, 2137283.0f);
        path.cubicTo(785773.0f, 1842544.0f, 942647.0f, 1570832.0f, 1148976.0f, 1338726.0f);
        path.lineTo(858801.0f, 836163.0f);
        path.lineTo(1213935.0f, 538168.0f);
        path.lineTo(1658476.0f, 911200.0f);
        path.cubicTo(1922884.0f, 748311.0f, 2217710.0f, 641003.0f, 2524962.0f, 595826.0f);
        path.lineTo(2625719.0f, 24319.0f);
        path.lineTo(3089321.0f, 24319.0f);
        path.lineTo(3190077.0f, 595823.0f);
        path.cubicTo(3497329.0f, 641001.0f, 3792154.0f, 748309.0f, 4056562.0f, 911199.0f);
        path.cubicTo(4056563.0f, 911199.0f, 4056563.0f, 911200.0f, 4056564.0f, 911200.0f);
        path.close();
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.left, (float)rect.top);
        return path;
    }

    private static Path getLeftCircularArrowPath(AutoShape shape, Rect rect) {
        shape.setFlipVertical(true);
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        int adj5 = 0;
        int len = 100;
        if (values != null && values.length == 5) {
            adj1 = Math.round((float)len * values[0].floatValue());
            adj2 = Math.round(values[1].floatValue() * 1.6666666f);
            adj3 = Math.round(values[2].floatValue() * 1.6666666f);
            adj4 = -Math.round(values[3].floatValue() * 1.6666666f);
            adj5 = Math.round((float)len * values[4].floatValue());
        } else {
            adj1 = Math.round((float)len * 0.125f);
            adj2 = 20;
            adj3 = 340;
            adj4 = -180;
            adj5 = Math.round((float)len * 0.125f);
        }
        int insideRadius = len / 2 - adj5;
        double y = (double)insideRadius * Math.sin((double)adj3 * Math.PI / 180.0);
        double x = (double)insideRadius * Math.cos((double)adj3 * Math.PI / 180.0);
        double k = Math.tan((double)(adj3 + adj2) * Math.PI / 180.0);
        double b = y - k * x;
        double offX1 = Math.sqrt(Math.pow(adj5, 2.0) / (Math.pow(k, 2.0) + 1.0));
        double offX2 = Math.sqrt(Math.pow(adj1 / 2, 2.0) / (Math.pow(k, 2.0) + 1.0));
        if (adj3 > 90 && adj3 < 270) {
            offX1 = -offX1;
            offX2 = -offX2;
        }
        double outerDegree = SmartArtPathBuilder.getAngle(x + offX2, k * (x + offX2) + b);
        double innerDegree = SmartArtPathBuilder.getAngle(x - offX2, k * (x - offX2) + b);
        s_rect.set((float)(adj5 - adj1 / 2 - len / 2), (float)(adj5 - adj1 / 2 - len / 2), (float)(len / 2 - adj5 + adj1 / 2), (float)(len / 2 - adj5 + adj1 / 2));
        path.arcTo(s_rect, (float)adj4, (float)(outerDegree - (double)adj4 + 360.0) % 360.0f);
        path.lineTo((float)(x + offX1), (float)(k * (x + offX1) + b));
        path.lineTo((float)((double)insideRadius * Math.cos((double)(adj3 + adj2) * Math.PI / 180.0)), (float)((double)insideRadius * Math.sin((double)(adj3 + adj2) * Math.PI / 180.0)));
        path.lineTo((float)(x - offX1), (float)(k * (x - offX1) + b));
        s_rect.set((float)(adj5 + adj1 / 2 - len / 2), (float)(adj5 + adj1 / 2 - len / 2), (float)(len / 2 - adj5 - adj1 / 2), (float)(len / 2 - adj5 - adj1 / 2));
        path.arcTo(s_rect, (float)innerDegree, (float)((double)adj4 - innerDegree - 360.0) % 360.0f);
        path.close();
        Matrix m = new Matrix();
        m.postScale((float)rect.width() / 100.0f, (float)rect.height() / 100.0f);
        path.transform(m);
        path.offset((float)rect.centerX(), (float)rect.centerY());
        return path;
    }

    private static double getAngle(double x, double y) {
        double angle = Math.acos(x / Math.sqrt(x * x + y * y)) * 180.0 / Math.PI;
        if (y < 0.0) {
            angle = 360.0 - angle;
        }
        return angle;
    }

    private static Path getPieWedgePath(AutoShape shape, Rect rect) {
        path.moveTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.arcTo(new RectF((float)rect.left, (float)rect.top, (float)(rect.left + rect.width() * 2), (float)(rect.top + rect.height() * 2)), 180.0f, 90.0f);
        path.close();
        return path;
    }

    private static Path getSwooshArrowPath(AutoShape shape, Rect rect) {
        float len = 3600000.0f;
        path.moveTo(0.0f, 3600000.0f);
        path.cubicTo(400000.0f, 2000000.0f, 1300000.0f, 950000.0f, 2700000.0f, 450000.0f);
        path.lineTo(2649297.0f, 0.0f);
        path.lineTo(3600000.0f, 720000.0f);
        path.lineTo(2852109.0f, 1800000.0f);
        path.lineTo(2801406.0f, 1350000.0f);
        path.cubicTo(1533802.0f, 1550000.0f, 600000.0f, 2300000.0f, 0.0f, 3600000.0f);
        path.close();
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.left, (float)rect.top);
        return path;
    }
}

