/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.flowChart;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class FlowChartDrawing {
    private static Rect flowRect = new Rect();
    private static RectF rectF = new RectF();
    private static Path path = new Path();
    private static final FlowChartDrawing kit = new FlowChartDrawing();

    public static FlowChartDrawing instance() {
        return kit;
    }

    public void drawFlowChart(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        int type = shape.getShapeType();
        switch (type) {
            case 109: {
                this.drawFlowChartProcess(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 176: {
                this.drawFlowChartAlternateProcess(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 110: {
                this.drawFlowChartDecision(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 111: {
                this.drawFlowChartInputOutput(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 112: {
                this.drawFlowChartPredefinedProcess(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 113: {
                this.drawFlowChartInternalStorage(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 114: {
                this.drawFlowChartDocument(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 115: {
                this.drawFlowChartMultidocument(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 116: {
                this.drawFlowChartTerminator(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 117: {
                this.drawFlowChartPreparation(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 118: {
                this.drawFlowChartManualInput(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 119: {
                this.drawFlowChartManualOperation(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 120: {
                this.drawFlowChartConnector(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 177: {
                this.drawFlowChartOffpageConnector(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 121: {
                this.drawFlowChartPunchedCard(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 122: {
                this.drawFlowChartPunchedTape(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 123: {
                this.drawFlowChartSummingJunction(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 124: {
                this.drawFlowChartOr(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 125: {
                this.drawFlowChartCollate(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 126: {
                this.drawFlowChartSort(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 127: {
                this.drawFlowChartExtract(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 128: {
                this.drawFlowChartMerge(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 130: {
                this.drawFlowChartOnlineStorage(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 135: {
                this.drawFlowChartDelay(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 131: {
                this.drawFlowChartMagneticTape(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 132: {
                this.drawFlowChartMagneticDisk(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 133: {
                this.drawFlowChartMagneticDrum(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
            case 134: {
                this.drawFlowChartDisplay(canvas, control, viewIndex, shape, rect, zoom);
                break;
            }
        }
    }

    private void drawFlowChartProcess(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        path.reset();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartAlternateProcess(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.18f;
        path.reset();
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addRoundRect(rectF, new float[]{x, x, x, x, x, x, x, x}, Path.Direction.CW);
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartDecision(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        path.reset();
        path.moveTo(rect.exactCenterX(), (float)rect.top);
        path.lineTo((float)rect.right, rect.exactCenterY());
        path.lineTo(rect.exactCenterX(), (float)rect.bottom);
        path.lineTo((float)rect.left, rect.exactCenterY());
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartInputOutput(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.2f;
        path.reset();
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartPredefinedProcess(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.125f;
        path.reset();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.left + x, (float)rect.bottom);
        path.moveTo((float)rect.right - x, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartInternalStorage(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.125f;
        float y = (float)rect.height() * 0.125f;
        path.reset();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CW);
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.left + x, (float)rect.bottom);
        path.moveTo((float)rect.left, (float)rect.top + y);
        path.lineTo((float)rect.right, (float)rect.top + y);
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartDocument(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.height() * 0.2f;
        float y = (float)rect.height() * 0.07f;
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        rectF.set(rect.exactCenterX(), (float)rect.bottom - x, (float)rect.right + (float)rect.width() / 2.0f, (float)rect.bottom + x - y * 2.0f);
        path.arcTo(rectF, 270.0f, -90.0f);
        rectF.set((float)rect.left, (float)rect.bottom - y * 2.0f, rect.exactCenterX(), (float)rect.bottom);
        path.arcTo(rectF, 0.0f, 180.0f);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartMultidocument(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        int x = (int)((double)rect.width() * 0.137);
        int y = (int)((double)rect.height() * 0.167);
        flowRect.set(rect.left + x, rect.top, rect.right, rect.bottom - y);
        this.drawFlowChartDocument(canvas, control, viewIndex, shape, flowRect, zoom);
        flowRect.set(rect.left + x / 2, rect.top + y / 2, rect.right - x / 2, rect.bottom - y / 2);
        this.drawFlowChartDocument(canvas, control, viewIndex, shape, flowRect, zoom);
        flowRect.set(rect.left, rect.top + y, rect.right - x, rect.bottom);
        this.drawFlowChartDocument(canvas, control, viewIndex, shape, flowRect, zoom);
    }

    private void drawFlowChartTerminator(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.16f;
        float y = (float)rect.height() * 0.5f;
        path.reset();
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addRoundRect(rectF, new float[]{x, y, x, y, x, y, x, y}, Path.Direction.CW);
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartPreparation(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.2f;
        path.reset();
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.top);
        path.lineTo((float)rect.right, rect.exactCenterY());
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        path.lineTo((float)rect.left + x, (float)rect.bottom);
        path.lineTo((float)rect.left, rect.exactCenterY());
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartManualInput(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.height() * 0.2f;
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top + x);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartManualOperation(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.2f;
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        path.lineTo((float)rect.left + x, (float)rect.bottom);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartConnector(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        path.reset();
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addOval(rectF, Path.Direction.CW);
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartOffpageConnector(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.height() * 0.2f;
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom - x);
        path.lineTo(rect.exactCenterX(), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom - x);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartPunchedCard(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.2f;
        float y = (float)rect.height() * 0.2f;
        path.reset();
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.top + y);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartPunchedTape(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.height() * 0.1f;
        path.reset();
        rectF.set((float)rect.left, (float)rect.top, rect.exactCenterX(), (float)rect.top + x * 2.0f);
        path.arcTo(rectF, 180.0f, -180.0f);
        rectF.set(rect.exactCenterX(), (float)rect.top, (float)rect.right, (float)rect.top + x * 2.0f);
        path.arcTo(rectF, 180.0f, 180.0f);
        rectF.set(rect.exactCenterX(), (float)rect.bottom - x * 2.0f, (float)rect.right, (float)rect.bottom);
        path.arcTo(rectF, 0.0f, -180.0f);
        rectF.set((float)rect.left, (float)rect.bottom - x * 2.0f, rect.exactCenterX(), (float)rect.bottom);
        path.arcTo(rectF, 0.0f, 180.0f);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartSummingJunction(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)Math.sqrt(2.0) * (float)rect.width() / 4.0f;
        float y = (float)Math.sqrt(2.0) * (float)rect.height() / 4.0f;
        float x0 = rect.exactCenterX();
        float y0 = rect.exactCenterY();
        path.reset();
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addOval(rectF, Path.Direction.CW);
        path.moveTo(x0 - x, y0 - y);
        path.lineTo(x0 + x, y0 + y);
        path.moveTo(x0 + x, y0 - y);
        path.lineTo(x0 - x, y0 + y);
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartOr(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        path.reset();
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addOval(rectF, Path.Direction.CW);
        path.moveTo(rect.exactCenterX(), (float)rect.top);
        path.lineTo(rect.exactCenterX(), (float)rect.bottom);
        path.moveTo((float)rect.left, rect.exactCenterY());
        path.lineTo((float)rect.right, rect.exactCenterY());
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartCollate(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo(rect.exactCenterX(), rect.exactCenterY());
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.lineTo(rect.exactCenterX(), rect.exactCenterY());
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartSort(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        path.reset();
        path.moveTo(rect.exactCenterX(), (float)rect.top);
        path.lineTo((float)rect.right, rect.exactCenterY());
        path.lineTo(rect.exactCenterX(), (float)rect.bottom);
        path.lineTo((float)rect.left, rect.exactCenterY());
        path.close();
        path.moveTo((float)rect.left, rect.exactCenterY());
        path.lineTo((float)rect.right, rect.exactCenterY());
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartExtract(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        path.reset();
        path.moveTo(rect.exactCenterX(), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartMerge(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo(rect.exactCenterX(), (float)rect.bottom);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartOnlineStorage(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.16f;
        path.reset();
        rectF.set((float)rect.right - x, (float)rect.top, (float)rect.right + x, (float)rect.bottom);
        path.arcTo(rectF, 90.0f, 180.0f);
        rectF.set((float)rect.left, (float)rect.top, (float)rect.left + x * 2.0f, (float)rect.bottom);
        path.arcTo(rectF, 270.0f, -180.0f);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartDelay(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top);
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.arcTo(rectF, 270.0f, 180.0f);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartMagneticTape(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.15f;
        float y = (float)rect.height() * 0.15f;
        path.reset();
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addOval(rectF, Path.Direction.CW);
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
        boolean border = shape.hasLine();
        shape.setLine(false);
        path.reset();
        path.moveTo(rect.exactCenterX(), (float)rect.bottom - y);
        path.lineTo((float)rect.right, (float)rect.bottom - y);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.moveTo(rect.exactCenterX(), (float)rect.bottom);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
        shape.setLine(border);
        path.reset();
        path.moveTo((float)rect.right - x, (float)rect.bottom - y);
        path.lineTo((float)rect.right, (float)rect.bottom - y);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo(rect.exactCenterX(), (float)rect.bottom);
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartMagneticDisk(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.height() * 0.32f;
        path.reset();
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.top + x);
        path.addOval(rectF, Path.Direction.CW);
        rectF.set((float)rect.left, (float)rect.bottom - x, (float)rect.right, (float)rect.bottom);
        path.arcTo(rectF, 0.0f, 180.0f);
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.top + x);
        path.arcTo(rectF, 180.0f, -180.0f);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartMagneticDrum(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.34f;
        path.reset();
        rectF.set((float)rect.right - x, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addOval(rectF, Path.Direction.CW);
        path.moveTo((float)rect.right - x / 2.0f, (float)rect.bottom);
        rectF.set((float)rect.right - x, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.arcTo(rectF, 90.0f, 180.0f);
        rectF.set((float)rect.left, (float)rect.top, (float)rect.left + x, (float)rect.bottom);
        path.arcTo(rectF, 270.0f, -180.0f);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }

    private void drawFlowChartDisplay(Canvas canvas, IControl control, int viewIndex, AutoShape shape, Rect rect, float zoom) {
        float x = (float)rect.width() * 0.16f;
        path.reset();
        path.moveTo((float)rect.left, rect.exactCenterY());
        path.lineTo((float)rect.left + x, (float)rect.top);
        rectF.set((float)rect.right - x * 2.0f, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.arcTo(rectF, 270.0f, 180.0f);
        path.lineTo((float)rect.left + x, (float)rect.bottom);
        path.close();
        AutoShapeKit.instance().drawShape(canvas, control, viewIndex, shape, path, rect, zoom);
    }
}

