/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.AShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.LinearGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.PatternShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureStretchInfo;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.IAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.Presentation;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class BackgroundDrawer {
    public static void drawLineAndFill(Canvas canvas, IControl control, int viewIndex, AbstractShape shape, Rect rect, float zoom) {
        if (shape.hasLine()) {
            Paint paint = PaintKit.instance().getPaint();
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth((float)shape.getLine().getLineWidth() * zoom);
            BackgroundDrawer.drawBackground(canvas, control, viewIndex, shape.getLine().getBackgroundAndFill(), rect, null, zoom, paint);
        }
        if (shape.getBackgroundAndFill() != null) {
            BackgroundDrawer.drawBackground(canvas, control, viewIndex, shape.getBackgroundAndFill(), rect, null, zoom);
        }
    }

    public static void drawPathBackground(Canvas canvas, IControl control, int viewIndex, BackgroundAndFill fill, Rect rect, IAnimation animation, float zoom, Path path, Paint paint) {
        if (fill == null) {
            return;
        }
        canvas.save();
        if (fill.isSlideBackgroundFill() && control != null && control.getView() instanceof Presentation) {
            canvas.clipRect(rect);
            canvas.rotate(0.0f);
            Dimension d = ((Presentation)control.getView()).getPGModel().getPageSize();
            rect.set(0, 0, (int)((float)d.width * zoom), (int)((float)d.height * zoom));
        }
        switch (fill.getFillType()) {
            case 0: {
                paint.setColor(fill.getForegroundColor());
                if (animation != null) {
                    int newAlpha = fill.getForegroundColor() >> 24 & 0xFF;
                    newAlpha = (int)((float)animation.getCurrentAnimationInfor().getAlpha() / 255.0f * (float)newAlpha);
                    paint.setAlpha(newAlpha);
                }
                canvas.drawPath(path, paint);
                break;
            }
            case 3: {
                canvas.clipPath(path);
                float x = rect.left;
                float y = rect.top;
                float w = rect.width();
                float h = rect.height();
                PictureStretchInfo stretch = fill.getStretch();
                if (stretch != null) {
                    x += stretch.getLeftOffset() * w;
                    y += stretch.getTopOffset() * h;
                    w *= 1.0f - stretch.getLeftOffset() - stretch.getRightOffset();
                    h *= 1.0f - stretch.getTopOffset() - stretch.getBottomOffset();
                }
                PictureKit.instance().drawPicture(canvas, control, viewIndex, fill.getPicture(control), x, y, zoom, w, h, null, animation);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                BackgroundDrawer.drawGradientAndTile(canvas, control, viewIndex, fill, rect, animation, zoom, path, paint);
                break;
            }
        }
        canvas.restore();
    }

    private static void drawGradientAndTile(Canvas canvas, IControl control, int viewIndex, BackgroundAndFill fill, Rect rect, IAnimation animation, float zoom, Path path, Paint paint) {
        AShader aShader = fill.getShader();
        if (aShader != null) {
            float r;
            Shader shader;
            if (aShader instanceof LinearGradientShader) {
                float lineWidth = paint.getStrokeWidth();
                if ((float)Math.abs(rect.left - rect.right) <= lineWidth) {
                    rect.set(Math.round((float)rect.left - lineWidth / 2.0f), Math.round(rect.top), Math.round((float)rect.right + lineWidth / 2.0f), Math.round(rect.bottom));
                } else if ((float)Math.abs(rect.top - rect.bottom) <= lineWidth) {
                    rect.set(Math.round(rect.left), Math.round((float)rect.top - lineWidth / 2.0f), Math.round(rect.right), Math.round((float)rect.bottom + lineWidth / 2.0f));
                }
            }
            if ((shader = aShader.getShader()) == null && (shader = aShader.createShader(control, viewIndex, new Rect(Math.round((float)rect.left * (r = 1.0f / zoom)), Math.round((float)rect.top * r), Math.round((float)rect.right * r), Math.round((float)rect.bottom * r)))) == null) {
                return;
            }
            Matrix m = new Matrix();
            float offX = rect.left;
            float offY = rect.top;
            if (aShader instanceof TileShader) {
                TileShader tileShader = (TileShader)aShader;
                offX += (float)tileShader.getOffsetX() * zoom;
                offY += (float)tileShader.getOffsetY() * zoom;
                m.postScale(zoom, zoom);
            } else if (!(aShader instanceof PatternShader)) {
                if (aShader instanceof LinearGradientShader) {
                    LinearGradientShader gradient = (LinearGradientShader)aShader;
                    float focusX = 1.0f;
                    float focusY = 1.0f;
                    if (gradient.getAngle() == 90) {
                        switch (gradient.getFocus()) {
                            case 100: {
                                focusX = 0.0f;
                                focusY = 0.0f;
                                break;
                            }
                            case 0: {
                                focusX = 1.0f;
                                break;
                            }
                            case -50: {
                                focusX = 0.5f;
                                focusY = 0.5f;
                                break;
                            }
                            case 50: {
                                focusX = -0.5f;
                                focusY = -0.5f;
                            }
                        }
                    } else {
                        switch (gradient.getFocus()) {
                            case 100: {
                                focusX = 0.0f;
                                focusY = 0.0f;
                                break;
                            }
                            case 0: {
                                focusX = 1.0f;
                                break;
                            }
                            case 50: {
                                focusX = 0.5f;
                                focusY = 0.5f;
                                break;
                            }
                            case -50: {
                                focusX = -0.5f;
                                focusY = -0.5f;
                            }
                        }
                    }
                    offX += focusX * (float)rect.width();
                    offY += focusY * (float)rect.height();
                }
                m.postScale((float)rect.width() / 100.0f, (float)rect.height() / 100.0f);
            }
            m.postTranslate(offX, offY);
            shader.setLocalMatrix(m);
            paint.setShader(shader);
            int newAlpha = aShader.getAlpha();
            if (animation != null) {
                newAlpha = (int)((float)animation.getCurrentAnimationInfor().getAlpha() / 255.0f * (float)newAlpha);
            }
            paint.setAlpha(newAlpha);
            if (path != null) {
                canvas.drawPath(path, paint);
            } else {
                canvas.drawRect(rect, paint);
            }
            paint.setShader(null);
        }
    }

    public static boolean drawBackground(Canvas canvas, IControl control, int viewIndex, BackgroundAndFill br, Rect rect, IAnimation animation, float zoom) {
        return BackgroundDrawer.drawBackground(canvas, control, viewIndex, br, rect, animation, zoom, PaintKit.instance().getPaint());
    }

    public static boolean drawBackground(Canvas canvas, IControl control, int viewIndex, BackgroundAndFill br, Rect rect, IAnimation animation, float zoom, Paint paint) {
        if (br != null) {
            canvas.save();
            if (br.isSlideBackgroundFill() && control != null && control.getView() instanceof Presentation) {
                canvas.clipRect(rect);
                canvas.rotate(0.0f);
                Dimension d = ((Presentation)control.getView()).getPGModel().getPageSize();
                rect.set(0, 0, (int)((float)d.width * zoom), (int)((float)d.height * zoom));
            }
            switch (br.getFillType()) {
                case 0: {
                    int color2 = paint.getColor();
                    paint.setColor(br.getForegroundColor());
                    if (animation != null) {
                        paint.setAlpha(animation.getCurrentAnimationInfor().getAlpha());
                    }
                    canvas.drawRect(rect, paint);
                    paint.setColor(color2);
                    canvas.restore();
                    return true;
                }
                case 3: {
                    float x = rect.left;
                    float y = rect.top;
                    float w = rect.width();
                    float h = rect.height();
                    PictureStretchInfo stretch = br.getStretch();
                    if (stretch != null) {
                        x += stretch.getLeftOffset() * w;
                        y += stretch.getTopOffset() * h;
                        w *= 1.0f - stretch.getLeftOffset() - stretch.getRightOffset();
                        h *= 1.0f - stretch.getTopOffset() - stretch.getBottomOffset();
                    }
                    PictureKit.instance().drawPicture(canvas, control, viewIndex, br.getPicture(control), x, y, zoom, w, h, null, animation);
                    canvas.restore();
                    return true;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    BackgroundDrawer.drawGradientAndTile(canvas, control, viewIndex, br, rect, animation, zoom, null, paint);
                    canvas.restore();
                    return true;
                }
            }
            canvas.restore();
        }
        return false;
    }
}

