/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.tableview.sort;

import androidx.annotation.NonNull;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.holder.AbstractSorterViewHolder;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.sort.SortState;
import java.util.ArrayList;
import java.util.List;

public class ColumnSortHelper {
    @NonNull
    private final List<Directive> mSortingColumns = new ArrayList<Directive>();
    @NonNull
    private final ColumnHeaderLayoutManager mColumnHeaderLayoutManager;
    @NonNull
    private static final Directive EMPTY_DIRECTIVE = new Directive(-1, SortState.UNSORTED);

    public ColumnSortHelper(@NonNull ColumnHeaderLayoutManager columnHeaderLayoutManager) {
        this.mColumnHeaderLayoutManager = columnHeaderLayoutManager;
    }

    private void sortingStatusChanged(int column, @NonNull SortState sortState) {
        AbstractViewHolder holder = this.mColumnHeaderLayoutManager.getViewHolder(column);
        if (holder != null) {
            if (holder instanceof AbstractSorterViewHolder) {
                ((AbstractSorterViewHolder)holder).onSortingStatusChanged(sortState);
            } else {
                throw new IllegalArgumentException("Column Header ViewHolder must extend AbstractSorterViewHolder");
            }
        }
    }

    public void setSortingStatus(int column, @NonNull SortState status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.mSortingColumns.remove(directive);
        }
        if (status != SortState.UNSORTED) {
            this.mSortingColumns.add(new Directive(column, status));
        }
        this.sortingStatusChanged(column, status);
    }

    public void clearSortingStatus() {
        this.mSortingColumns.clear();
    }

    public boolean isSorting() {
        return this.mSortingColumns.size() != 0;
    }

    @NonNull
    public SortState getSortingStatus(int column) {
        return this.getDirective((int)column).direction;
    }

    @NonNull
    private Directive getDirective(int column) {
        for (int i = 0; i < this.mSortingColumns.size(); ++i) {
            Directive directive = this.mSortingColumns.get(i);
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    private static class Directive {
        private final int column;
        @NonNull
        private final SortState direction;

        Directive(int column, @NonNull SortState direction) {
            this.column = column;
            this.direction = direction;
        }
    }
}

