/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.tableview.listener.scroll;

import android.util.Log;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.ITableView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.CellRecyclerView;

public class VerticalRecyclerViewListener
extends RecyclerView.OnScrollListener
implements RecyclerView.OnItemTouchListener {
    private static final String LOG_TAG = VerticalRecyclerViewListener.class.getSimpleName();
    @NonNull
    private final CellRecyclerView mRowHeaderRecyclerView;
    @NonNull
    private final CellRecyclerView mCellRecyclerView;
    private RecyclerView mLastTouchedRecyclerView;
    private int mYPosition;
    private boolean mIsMoved;
    @Nullable
    private RecyclerView mCurrentRVTouched = null;
    private float dx = 0.0f;
    private float dy = 0.0f;

    public VerticalRecyclerViewListener(@NonNull ITableView tableView) {
        this.mRowHeaderRecyclerView = tableView.getRowHeaderRecyclerView();
        this.mCellRecyclerView = tableView.getCellRecyclerView();
    }

    private boolean verticalDirection(@NonNull MotionEvent ev) {
        if (ev.getAction() == 2) {
            if (this.dx == 0.0f) {
                this.dx = ev.getX();
            }
            if (this.dy == 0.0f) {
                this.dy = ev.getY();
            }
            float xdiff = Math.abs(this.dx - ev.getX());
            float ydiff = Math.abs(this.dy - ev.getY());
            this.dx = ev.getX();
            this.dy = ev.getY();
            return xdiff <= ydiff;
        }
        return true;
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        if (this.mCurrentRVTouched != null && rv != this.mCurrentRVTouched) {
            return true;
        }
        if (!this.verticalDirection(e)) {
            this.mCurrentRVTouched = null;
            return false;
        }
        if (e.getAction() == 0) {
            this.mCurrentRVTouched = rv;
            if (rv.getScrollState() == 0) {
                if (this.mLastTouchedRecyclerView != null && rv != this.mLastTouchedRecyclerView) {
                    this.removeLastTouchedRecyclerViewScrollListener(false);
                }
                this.mYPosition = ((CellRecyclerView)rv).getScrolledY();
                rv.addOnScrollListener((RecyclerView.OnScrollListener)this);
                if (rv == this.mCellRecyclerView) {
                    Log.d((String)LOG_TAG, (String)"mCellRecyclerView scroll listener added");
                } else if (rv == this.mRowHeaderRecyclerView) {
                    Log.d((String)LOG_TAG, (String)"mRowHeaderRecyclerView scroll listener added");
                }
                this.mIsMoved = false;
            }
        } else if (e.getAction() == 2) {
            this.mCurrentRVTouched = rv;
            this.mIsMoved = true;
        } else if (e.getAction() == 1) {
            this.mCurrentRVTouched = null;
            int nScrollY = ((CellRecyclerView)rv).getScrolledY();
            if (this.mYPosition == nScrollY && !this.mIsMoved && rv.getScrollState() == 0) {
                rv.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                if (rv == this.mCellRecyclerView) {
                    Log.d((String)LOG_TAG, (String)"mCellRecyclerView scroll listener removed from up ");
                } else if (rv == this.mRowHeaderRecyclerView) {
                    Log.d((String)LOG_TAG, (String)"mRowHeaderRecyclerView scroll listener removed from up");
                }
            }
            this.mLastTouchedRecyclerView = rv;
        }
        return false;
    }

    public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        if (recyclerView == this.mCellRecyclerView) {
            super.onScrolled(recyclerView, dx, dy);
        } else if (recyclerView == this.mRowHeaderRecyclerView) {
            super.onScrolled(recyclerView, dx, dy);
            this.mCellRecyclerView.scrollBy(0, dy);
        }
    }

    public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        if (newState == 0) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            this.mIsMoved = false;
            this.mCurrentRVTouched = null;
            if (recyclerView == this.mCellRecyclerView) {
                Log.d((String)LOG_TAG, (String)"mCellRecyclerView scroll listener removed from onScrollStateChanged");
            } else if (recyclerView == this.mRowHeaderRecyclerView) {
                Log.d((String)LOG_TAG, (String)"mRowHeaderRecyclerView scroll listener removed from onScrollStateChanged");
            }
        }
    }

    public void removeLastTouchedRecyclerViewScrollListener(boolean isNeeded) {
        if (this.mLastTouchedRecyclerView == this.mCellRecyclerView) {
            this.mCellRecyclerView.removeOnScrollListener(this);
            this.mCellRecyclerView.stopScroll();
            Log.d((String)LOG_TAG, (String)"mCellRecyclerView scroll listener removed from last touched");
        } else {
            this.mRowHeaderRecyclerView.removeOnScrollListener(this);
            this.mRowHeaderRecyclerView.stopScroll();
            Log.d((String)LOG_TAG, (String)"mRowHeaderRecyclerView scroll listener removed from last touched");
            if (isNeeded) {
                this.mCellRecyclerView.removeOnScrollListener(this);
                this.mCellRecyclerView.stopScroll();
                Log.d((String)LOG_TAG, (String)"mCellRecyclerView scroll listener removed from last touched");
            }
        }
    }
}

