/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.tableview.listener.scroll;

import android.util.Log;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.ITableView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.CellRecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.listener.scroll.VerticalRecyclerViewListener;

public class HorizontalRecyclerViewListener
extends RecyclerView.OnScrollListener
implements RecyclerView.OnItemTouchListener {
    private static final String LOG_TAG = HorizontalRecyclerViewListener.class.getSimpleName();
    @NonNull
    private final CellRecyclerView mColumnHeaderRecyclerView;
    @Nullable
    private final RecyclerView.LayoutManager mCellLayoutManager;
    @Nullable
    private RecyclerView mLastTouchedRecyclerView;
    private int mXPosition;
    private boolean mIsMoved;
    private int mScrollPosition;
    private int mScrollPositionOffset = 0;
    @Nullable
    private RecyclerView mCurrentRVTouched = null;
    @NonNull
    private final VerticalRecyclerViewListener mVerticalRecyclerViewListener;

    public HorizontalRecyclerViewListener(@NonNull ITableView tableView) {
        this.mColumnHeaderRecyclerView = tableView.getColumnHeaderRecyclerView();
        this.mCellLayoutManager = tableView.getCellRecyclerView().getLayoutManager();
        this.mVerticalRecyclerViewListener = tableView.getVerticalRecyclerViewListener();
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        if (this.mCurrentRVTouched != null && rv != this.mCurrentRVTouched) {
            return true;
        }
        if (e.getAction() == 0) {
            this.mCurrentRVTouched = rv;
            if (rv.getScrollState() == 0) {
                if (this.mLastTouchedRecyclerView != null && rv != this.mLastTouchedRecyclerView) {
                    if (this.mLastTouchedRecyclerView == this.mColumnHeaderRecyclerView) {
                        this.mColumnHeaderRecyclerView.removeOnScrollListener(this);
                        this.mColumnHeaderRecyclerView.stopScroll();
                        Log.d((String)LOG_TAG, (String)"Scroll listener  has been removed to mColumnHeaderRecyclerView at last touch control");
                    } else {
                        int lastTouchedIndex = this.getIndex(this.mLastTouchedRecyclerView);
                        if (lastTouchedIndex >= 0 && lastTouchedIndex < this.mCellLayoutManager.getChildCount() && !((CellRecyclerView)this.mLastTouchedRecyclerView).isHorizontalScrollListenerRemoved()) {
                            ((RecyclerView)this.mCellLayoutManager.getChildAt(lastTouchedIndex)).removeOnScrollListener((RecyclerView.OnScrollListener)this);
                            Log.d((String)LOG_TAG, (String)("Scroll listener  has been removed to " + this.mLastTouchedRecyclerView.getId() + " CellRecyclerView at last touch control"));
                            ((RecyclerView)this.mCellLayoutManager.getChildAt(lastTouchedIndex)).stopScroll();
                        }
                    }
                }
                this.mXPosition = ((CellRecyclerView)rv).getScrolledX();
                rv.addOnScrollListener((RecyclerView.OnScrollListener)this);
                Log.d((String)LOG_TAG, (String)("Scroll listener  has been added to " + rv.getId() + " at action down"));
            }
        } else if (e.getAction() == 2) {
            this.mCurrentRVTouched = rv;
            this.mIsMoved = true;
        } else if (e.getAction() == 1) {
            this.mCurrentRVTouched = null;
            int nScrollX = ((CellRecyclerView)rv).getScrolledX();
            if (this.mXPosition == nScrollX && !this.mIsMoved) {
                rv.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                Log.d((String)LOG_TAG, (String)("Scroll listener  has been removed to " + rv.getId() + " at action up"));
            }
            this.mLastTouchedRecyclerView = rv;
        } else if (e.getAction() == 3) {
            this.renewScrollPosition(rv);
            rv.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            Log.d((String)LOG_TAG, (String)("Scroll listener  has been removed to " + rv.getId() + " at action cancel"));
            this.mIsMoved = false;
            this.mLastTouchedRecyclerView = rv;
            this.mCurrentRVTouched = null;
        }
        return false;
    }

    public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        if (recyclerView == this.mColumnHeaderRecyclerView) {
            super.onScrolled(recyclerView, dx, dy);
            for (int i = 0; i < this.mCellLayoutManager.getChildCount(); ++i) {
                CellRecyclerView child = (CellRecyclerView)this.mCellLayoutManager.getChildAt(i);
                child.scrollBy(dx, 0);
            }
        } else {
            super.onScrolled(recyclerView, dx, dy);
            for (int i = 0; i < this.mCellLayoutManager.getChildCount(); ++i) {
                CellRecyclerView child = (CellRecyclerView)this.mCellLayoutManager.getChildAt(i);
                if (child == recyclerView) continue;
                child.scrollBy(dx, 0);
            }
        }
    }

    public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        if (newState == 0) {
            this.renewScrollPosition(recyclerView);
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            Log.d((String)LOG_TAG, (String)("Scroll listener has been removed to " + recyclerView.getId() + " at onScrollStateChanged"));
            this.mIsMoved = false;
            boolean isNeeded = this.mLastTouchedRecyclerView != this.mColumnHeaderRecyclerView;
            this.mVerticalRecyclerViewListener.removeLastTouchedRecyclerViewScrollListener(isNeeded);
        }
    }

    private int getIndex(@NonNull RecyclerView rv) {
        for (int i = 0; i < this.mCellLayoutManager.getChildCount(); ++i) {
            if (this.mCellLayoutManager.getChildAt(i) != rv) continue;
            return i;
        }
        return -1;
    }

    private void renewScrollPosition(@NonNull RecyclerView recyclerView) {
        LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
        this.mScrollPosition = layoutManager.findFirstCompletelyVisibleItemPosition();
        if (this.mScrollPosition == -1) {
            this.mScrollPosition = layoutManager.findFirstVisibleItemPosition();
            if (this.mScrollPosition != layoutManager.findLastVisibleItemPosition()) {
                ++this.mScrollPosition;
            }
        }
        this.mScrollPositionOffset = layoutManager.findViewByPosition(this.mScrollPosition).getLeft();
    }

    public int getScrollPosition() {
        return this.mScrollPosition;
    }

    public int getScrollPositionOffset() {
        return this.mScrollPositionOffset;
    }

    public void setScrollPositionOffset(int offset) {
        this.mScrollPositionOffset = offset;
    }

    public void setScrollPosition(int position) {
        this.mScrollPosition = position;
    }
}

