/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.tableview.listener;

import android.view.View;
import androidx.annotation.NonNull;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.ITableView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.CellRecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.layoutmanager.CellLayoutManager;

public class TableViewLayoutChangeListener
implements View.OnLayoutChangeListener {
    @NonNull
    private final CellRecyclerView mCellRecyclerView;
    @NonNull
    private final CellRecyclerView mColumnHeaderRecyclerView;
    @NonNull
    private final CellLayoutManager mCellLayoutManager;

    public TableViewLayoutChangeListener(@NonNull ITableView tableView) {
        this.mCellRecyclerView = tableView.getCellRecyclerView();
        this.mColumnHeaderRecyclerView = tableView.getColumnHeaderRecyclerView();
        this.mCellLayoutManager = tableView.getCellLayoutManager();
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (v.isShown() && right - left != oldRight - oldLeft) {
            if (this.mColumnHeaderRecyclerView.getWidth() > this.mCellRecyclerView.getWidth()) {
                this.mCellLayoutManager.remeasureAllChild();
            } else if (this.mCellRecyclerView.getWidth() > this.mColumnHeaderRecyclerView.getWidth()) {
                this.mColumnHeaderRecyclerView.getLayoutParams().width = -2;
                this.mColumnHeaderRecyclerView.requestLayout();
            }
        }
    }
}

