/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.tableview.handler;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.ITableView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.layoutmanager.CellLayoutManager;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.layoutmanager.ColumnLayoutManager;

public class ScrollHandler {
    @NonNull
    private final ITableView mTableView;
    @NonNull
    private final CellLayoutManager mCellLayoutManager;
    @NonNull
    private final LinearLayoutManager mRowHeaderLayoutManager;
    @NonNull
    private final ColumnHeaderLayoutManager mColumnHeaderLayoutManager;

    public ScrollHandler(@NonNull ITableView tableView) {
        this.mTableView = tableView;
        this.mCellLayoutManager = tableView.getCellLayoutManager();
        this.mRowHeaderLayoutManager = tableView.getRowHeaderLayoutManager();
        this.mColumnHeaderLayoutManager = tableView.getColumnHeaderLayoutManager();
    }

    public void scrollToColumnPosition(int columnPosition) {
        if (!((View)this.mTableView).isShown()) {
            this.mTableView.getHorizontalRecyclerViewListener().setScrollPosition(columnPosition);
        }
        this.scrollColumnHeader(columnPosition, 0);
        this.scrollCellHorizontally(columnPosition, 0);
    }

    public void scrollToColumnPosition(int columnPosition, int offset) {
        if (!((View)this.mTableView).isShown()) {
            this.mTableView.getHorizontalRecyclerViewListener().setScrollPosition(columnPosition);
            this.mTableView.getHorizontalRecyclerViewListener().setScrollPositionOffset(offset);
        }
        this.scrollColumnHeader(columnPosition, offset);
        this.scrollCellHorizontally(columnPosition, offset);
    }

    public void scrollToRowPosition(int rowPosition) {
        this.mRowHeaderLayoutManager.scrollToPosition(rowPosition);
        this.mCellLayoutManager.scrollToPosition(rowPosition);
    }

    public void scrollToRowPosition(int rowPosition, int offset) {
        this.mRowHeaderLayoutManager.scrollToPositionWithOffset(rowPosition, offset);
        this.mCellLayoutManager.scrollToPositionWithOffset(rowPosition, offset);
    }

    private void scrollCellHorizontally(int columnPosition, int offset) {
        CellLayoutManager cellLayoutManager = this.mTableView.getCellLayoutManager();
        for (int i = cellLayoutManager.findFirstVisibleItemPosition(); i < cellLayoutManager.findLastVisibleItemPosition() + 1; ++i) {
            RecyclerView cellRowRecyclerView = (RecyclerView)cellLayoutManager.findViewByPosition(i);
            if (cellRowRecyclerView == null) continue;
            ColumnLayoutManager columnLayoutManager = (ColumnLayoutManager)cellRowRecyclerView.getLayoutManager();
            columnLayoutManager.scrollToPositionWithOffset(columnPosition, offset);
        }
    }

    private void scrollColumnHeader(int columnPosition, int offset) {
        this.mTableView.getColumnHeaderLayoutManager().scrollToPositionWithOffset(columnPosition, offset);
    }

    public int getColumnPosition() {
        return this.mColumnHeaderLayoutManager.findFirstVisibleItemPosition();
    }

    public int getColumnPositionOffset() {
        View child = this.mColumnHeaderLayoutManager.findViewByPosition(this.mColumnHeaderLayoutManager.findFirstVisibleItemPosition());
        if (child != null) {
            return child.getLeft();
        }
        return 0;
    }

    public int getRowPosition() {
        return this.mRowHeaderLayoutManager.findFirstVisibleItemPosition();
    }

    public int getRowPositionOffset() {
        View child = this.mRowHeaderLayoutManager.findViewByPosition(this.mRowHeaderLayoutManager.findFirstVisibleItemPosition());
        if (child != null) {
            return child.getLeft();
        }
        return 0;
    }
}

