/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.ITableView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.CellRecyclerView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.CellRowRecyclerViewAdapter;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.handler.ScrollHandler;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.handler.SelectionHandler;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.layoutmanager.CellLayoutManager;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.layoutmanager.ColumnLayoutManager;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.listener.itemclick.CellRecyclerViewItemClickListener;
import java.util.ArrayList;
import java.util.List;

public class CellRecyclerViewAdapter<C>
extends AbstractRecyclerViewAdapter<C> {
    @NonNull
    private final ITableView mTableView;
    @NonNull
    private final RecyclerView.RecycledViewPool mRecycledViewPool;
    private int mRecyclerViewId = 0;

    public CellRecyclerViewAdapter(@NonNull Context context, @Nullable List<C> itemList, @NonNull ITableView tableView) {
        super(context, itemList);
        this.mTableView = tableView;
        this.mRecycledViewPool = new RecyclerView.RecycledViewPool();
    }

    @NonNull
    public AbstractViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        CellRecyclerView recyclerView = new CellRecyclerView(this.mContext);
        recyclerView.setRecycledViewPool(this.mRecycledViewPool);
        if (this.mTableView.isShowHorizontalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.mTableView.getHorizontalItemDecoration());
        }
        recyclerView.setHasFixedSize(this.mTableView.hasFixedWidth());
        recyclerView.addOnItemTouchListener(this.mTableView.getHorizontalRecyclerViewListener());
        if (this.mTableView.isAllowClickInsideCell()) {
            recyclerView.addOnItemTouchListener(new CellRecyclerViewItemClickListener(recyclerView, this.mTableView));
        }
        ColumnLayoutManager mColumnLayoutManager = new ColumnLayoutManager(this.mContext, this.mTableView);
        if (this.mTableView.getReverseLayout()) {
            mColumnLayoutManager.setReverseLayout(true);
        }
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)mColumnLayoutManager);
        recyclerView.setAdapter(new CellRowRecyclerViewAdapter(this.mContext, this.mTableView));
        recyclerView.setId(this.mRecyclerViewId);
        ++this.mRecyclerViewId;
        return new CellRowViewHolder((View)recyclerView);
    }

    public void onBindViewHolder(@NonNull AbstractViewHolder holder, int yPosition) {
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        CellRowRecyclerViewAdapter viewAdapter = (CellRowRecyclerViewAdapter)viewHolder.recyclerView.getAdapter();
        List rowList = (List)this.mItemList.get(yPosition);
        viewAdapter.setYPosition(yPosition);
        viewAdapter.setItems(rowList);
    }

    public void onViewAttachedToWindow(@NonNull AbstractViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        ScrollHandler scrollHandler = this.mTableView.getScrollHandler();
        ((ColumnLayoutManager)viewHolder.recyclerView.getLayoutManager()).scrollToPositionWithOffset(scrollHandler.getColumnPosition(), scrollHandler.getColumnPositionOffset());
        SelectionHandler selectionHandler = this.mTableView.getSelectionHandler();
        if (selectionHandler.isAnyColumnSelected()) {
            AbstractViewHolder cellViewHolder = (AbstractViewHolder)viewHolder.recyclerView.findViewHolderForAdapterPosition(selectionHandler.getSelectedColumnPosition());
            if (cellViewHolder != null) {
                if (!this.mTableView.isIgnoreSelectionColors()) {
                    cellViewHolder.setBackgroundColor(this.mTableView.getSelectedColor());
                }
                cellViewHolder.setSelected(AbstractViewHolder.SelectionState.SELECTED);
            }
        } else if (selectionHandler.isRowSelected(holder.getAdapterPosition())) {
            selectionHandler.changeSelectionOfRecyclerView(viewHolder.recyclerView, AbstractViewHolder.SelectionState.SELECTED, this.mTableView.getSelectedColor());
        }
    }

    public void onViewDetachedFromWindow(@NonNull AbstractViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        this.mTableView.getSelectionHandler().changeSelectionOfRecyclerView(((CellRowViewHolder)holder).recyclerView, AbstractViewHolder.SelectionState.UNSELECTED, this.mTableView.getUnSelectedColor());
    }

    public void onViewRecycled(@NonNull AbstractViewHolder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        viewHolder.recyclerView.clearScrolledX();
    }

    public void notifyCellDataSetChanged() {
        CellRecyclerView[] visibleRecyclerViews = this.mTableView.getCellLayoutManager().getVisibleCellRowRecyclerViews();
        if (visibleRecyclerViews.length > 0) {
            for (CellRecyclerView cellRowRecyclerView : visibleRecyclerViews) {
                RecyclerView.Adapter adapter;
                if (cellRowRecyclerView == null || (adapter = cellRowRecyclerView.getAdapter()) == null) continue;
                adapter.notifyDataSetChanged();
            }
        } else {
            this.notifyDataSetChanged();
        }
    }

    @NonNull
    public List<C> getColumnItems(int columnPosition) {
        ArrayList cellItems = new ArrayList();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            List rowList = (List)this.mItemList.get(i);
            if (rowList.size() <= columnPosition) continue;
            cellItems.add(rowList.get(columnPosition));
        }
        return cellItems;
    }

    public void removeColumnItems(int column) {
        CellRecyclerView[] visibleRecyclerViews;
        for (CellRecyclerView cellRowRecyclerView : visibleRecyclerViews = this.mTableView.getCellLayoutManager().getVisibleCellRowRecyclerViews()) {
            AbstractRecyclerViewAdapter adapter;
            if (cellRowRecyclerView == null || (adapter = (AbstractRecyclerViewAdapter)cellRowRecyclerView.getAdapter()) == null) continue;
            adapter.deleteItem(column);
        }
        ArrayList cellItems = new ArrayList();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            ArrayList rowList = new ArrayList((List)this.mItemList.get(i));
            if (rowList.size() > column) {
                rowList.remove(column);
            }
            cellItems.add(rowList);
        }
        this.setItems(cellItems, false);
    }

    public void addColumnItems(int column, @NonNull List<C> cellColumnItems) {
        if (cellColumnItems.size() != this.mItemList.size() || cellColumnItems.contains(null)) {
            return;
        }
        CellLayoutManager layoutManager = this.mTableView.getCellLayoutManager();
        for (int i = layoutManager.findFirstVisibleItemPosition(); i < layoutManager.findLastVisibleItemPosition() + 1; ++i) {
            RecyclerView cellRowRecyclerView = (RecyclerView)layoutManager.findViewByPosition(i);
            ((AbstractRecyclerViewAdapter)cellRowRecyclerView.getAdapter()).addItem(column, cellColumnItems.get(i));
        }
        ArrayList cellItems = new ArrayList();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            ArrayList<C> rowList = new ArrayList<C>((List)this.mItemList.get(i));
            if (rowList.size() > column) {
                rowList.add(column, cellColumnItems.get(i));
            }
            cellItems.add(rowList);
        }
        this.setItems(cellItems, false);
    }

    static class CellRowViewHolder
    extends AbstractViewHolder {
        final CellRecyclerView recyclerView;

        CellRowViewHolder(@NonNull View itemView) {
            super(itemView);
            this.recyclerView = (CellRecyclerView)itemView;
        }
    }
}

